/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.panel;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.dataEntry.IDataEditPanel;
import com.harrand.coreclasses.display.IPanelContainer;
import com.harrand.coreclasses.element.IIdfAsIs;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.interfaces.implementation.BasicCollector;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.Icons;
import com.harrand.coregui.command.idf.AddToCollector;
import com.harrand.coregui.command.idf.UpdateInCollector;
import com.harrand.coregui.dataEntry.CloseChecker;
import com.harrand.coregui.display.BasicSizeStorable;
import com.harrand.coregui.display.ISizeStorable;
import com.harrand.coregui.display.ISpaceConservable;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.panel.XpHeaderPanel;
import com.harrand.coregui.text.FocusRestorer;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.Trigger;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrenchgui.sub.NbEditPanel;
import com.harrand.dbwrenchgui.sub.editor.DbwEditor;
import com.harrand.util.Validator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public final class TriggerEditPanel
extends JPanel
implements DataEditor,
IObserver,
ISizeStorable,
ITitled,
IDataEditPanel,
ISpaceConservable,
IIdfAsIs {
    private final Table table_;
    private Trigger trg_;
    private Trigger lastTrg_;
    private final String className_;
    private static final ISizeStorable basicSizeStorable__ = new BasicSizeStorable(new Dimension(450, 450));
    private IPanelContainer panelContainer_;
    private JPanel mainEditPanel_;
    private XpHeaderPanel header_;
    private JLabel lblName_;
    private final JLabel lblTable = new JLabel("Table");
    private final JTextField txtName_ = new JTextField("");
    private final JTextField txtTable = new JTextField("");
    private final JLabel lblEvent_ = new JLabel("On Event");
    private JCheckBox chkOnDelete_;
    private JCheckBox chkOnInsert_;
    private JCheckBox chkOnUpdate_;
    private JLabel lblSqlText_;
    private final JLabel lblOracleNote_ = new JLabel("(NOTE: The above switches are ignored for Oracle triggers. Instead specify those values below in the SQL Text.)");
    private DbwEditor editor;
    private final JLabel lblExec_ = new JLabel("Execute");
    private final JLabel lblForEach_ = new JLabel("For Each");
    private final JRadioButton rdoBefore_ = new JRadioButton("Before");
    private final JRadioButton rdoAfter_ = new JRadioButton("After");
    private final JRadioButton rdoRow_ = new JRadioButton("Row");
    private final JRadioButton rdoStatement_ = new JRadioButton("Statement");
    private final ButtonGroup grpExec_;
    private final ButtonGroup grpForEach_ = new ButtonGroup();
    private boolean conserveSpace_ = false;
    private boolean startedUpdate_ = false;
    private FocusRestorer focusRestorer_;
    private final SwingThemeCtrl themeCtrl_;

    public TriggerEditPanel(Trigger currentTrigger, Table table) {
        this.grpExec_ = new ButtonGroup();
        this.lastTrg_ = currentTrigger;
        this.table_ = table;
        this.table_.addObserver(this);
        this.className_ = Trigger.getClassName();
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.txtTable.setText(table.getName());
        this.setupGui();
        this.editor.addObserver(this);
        this.buildFocusRestorer();
        this.updateDirty();
    }

    private void setupGui() {
        this.initComponents();
        this.buildControls();
        this.layoutComponents();
        this.loadData();
        this.setCosmetics();
        this.setNames();
        this.addListeners();
    }

    @Override
    public void setSyncOnEdit(boolean sync) {
    }

    private void buildControls() {
        String div = "";
        this.lblName_ = new JLabel(App.getResource("trigger.name.label") + div);
        this.chkOnDelete_ = new JCheckBox(App.getResource("trigger.on.delete.label"));
        this.chkOnInsert_ = new JCheckBox(App.getResource("trigger.on.insert.label"));
        this.chkOnUpdate_ = new JCheckBox(App.getResource("trigger.on.update.label"));
        this.lblSqlText_ = new JLabel(App.getResource("trigger.sql.text.label") + div);
        this.editor = new DbwEditor();
        this.grpExec_.add(this.rdoBefore_);
        this.grpExec_.add(this.rdoAfter_);
        this.grpForEach_.add(this.rdoRow_);
        this.grpForEach_.add(this.rdoStatement_);
    }

    private void initHeaderPanel() {
        String hdrTitle = StrHelper.getAddOrEditText(this.lastTrg_) + App.getResource("trigger.label");
        this.header_ = new XpHeaderPanel(hdrTitle, null);
    }

    private void loadData() {
        if (this.lastTrg_ != null) {
            this.txtName_.setText(this.lastTrg_.getName());
            this.chkOnDelete_.setSelected(this.lastTrg_.getFireOnDeleteFlag());
            this.chkOnInsert_.setSelected(this.lastTrg_.getFireOnInsertFlag());
            this.chkOnUpdate_.setSelected(this.lastTrg_.getFireOnUpdateFlag());
            this.rdoBefore_.setSelected(this.lastTrg_.getExecBefore());
            this.rdoAfter_.setSelected(!this.lastTrg_.getExecBefore());
            this.rdoRow_.setSelected(this.lastTrg_.getForEachRow());
            this.rdoStatement_.setSelected(!this.lastTrg_.getForEachRow());
            this.editor.setText(this.lastTrg_.getSql());
        } else {
            this.txtName_.setText("");
            this.chkOnDelete_.setSelected(false);
            this.chkOnInsert_.setSelected(false);
            this.chkOnUpdate_.setSelected(false);
            this.rdoAfter_.setSelected(true);
            this.rdoStatement_.setSelected(true);
            this.editor.setText("");
        }
    }

    private void layoutComponents() {
        this.buildMainPanel();
        this.setLayout(new BorderLayout());
        this.refreshDisplay();
    }

    private void buildMainPanel() {
        JPanel checkPanel = new JPanel();
        JPanel textPanel = new JPanel();
        this.initHeaderPanel();
        this.buildCheckPanel(checkPanel);
        this.buildTextPanel(textPanel);
        this.mainEditPanel_ = new JPanel();
        this.themeCtrl_.process(checkPanel);
        this.themeCtrl_.process(textPanel);
        int inset = 4;
        this.mainEditPanel_.setBorder(new EmptyBorder(new Insets(inset, inset, inset, inset)));
        this.mainEditPanel_.setLayout(new BorderLayout(4, 4));
        this.mainEditPanel_.add((Component)checkPanel, "North");
        this.mainEditPanel_.add((Component)textPanel, "Center");
    }

    private void refreshDisplay() {
        this.removeAll();
        if (!this.conserveSpace_) {
            this.add((Component)this.header_, "North");
        }
        this.add((Component)this.mainEditPanel_, "Center");
        this.setBorders();
    }

    private void buildCheckPanel(JPanel checkPanel) {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        checkPanel.setLayout(gbl);
        int row = 0;
        GuiHelper.addGridbagPair(this.lblName_, this.txtName_, gbc, checkPanel, row++);
        GuiHelper.addGridbagPair(this.lblTable, this.txtTable, gbc, checkPanel, row++);
        JPanel rowPanel = new JPanel(new GridLayout(1, 3));
        this.themeCtrl_.process(rowPanel);
        rowPanel.add(this.chkOnDelete_);
        rowPanel.add(this.chkOnInsert_);
        rowPanel.add(this.chkOnUpdate_);
        GuiHelper.addGridbagPair(this.lblEvent_, rowPanel, gbc, checkPanel, row++);
        GuiHelper.addGridbagPair(this.lblExec_, this.getExecRadioPanel(), gbc, checkPanel, row++);
        GuiHelper.addGridbagPair(this.lblForEach_, this.getForEachRadioPanel(), gbc, checkPanel, row++);
        GuiHelper.addGridbagPair(new JLabel(), this.lblOracleNote_, gbc, checkPanel, row++);
    }

    private JPanel getExecRadioPanel() {
        JPanel panel = new JPanel(new GridLayout(1, 3));
        panel.add(this.rdoBefore_);
        panel.add(this.rdoAfter_);
        panel.add(new JLabel(""));
        return panel;
    }

    private JPanel getForEachRadioPanel() {
        JPanel panel = new JPanel(new GridLayout(1, 3));
        panel.add(this.rdoStatement_);
        panel.add(this.rdoRow_);
        panel.add(new JLabel(""));
        return panel;
    }

    private void buildTextPanel(JPanel textPanel) {
        textPanel.setLayout(new BorderLayout());
        textPanel.add((Component)this.lblSqlText_, "North");
        textPanel.add((Component)this.editor, "Center");
    }

    private void setBorders() {
        if (this.conserveSpace_) {
            this.mainEditPanel_.setBorder(null);
            GuiHelper.addEmptyBorder(this);
        } else {
            GuiHelper.addBodyPanelBorder(this.mainEditPanel_);
        }
    }

    private void setNames() {
        this.setName("TriggerEditPanel");
        this.lblName_.setName("lblName");
        this.txtName_.setName("txtName");
        this.lblEvent_.setName("lblEvent");
        this.chkOnDelete_.setName("chkOnDelete");
        this.chkOnInsert_.setName("chkOnInsert");
        this.chkOnUpdate_.setName("chkOnUpdate");
        this.lblSqlText_.setName("lblSqlText");
        this.editor.setName("sqlTextPanel");
        this.rdoAfter_.setName("rdoAfter");
        this.rdoBefore_.setName("rdoBefore");
        this.rdoRow_.setName("rdoRow");
        this.rdoStatement_.setName("rdoStatement");
    }

    private void setCosmetics() {
        this.themeCtrl_.process(this);
        this.themeCtrl_.process(this.lblName_);
        this.themeCtrl_.process(this.txtName_);
        this.themeCtrl_.process(this.chkOnDelete_);
        this.themeCtrl_.process(this.chkOnInsert_);
        this.themeCtrl_.process(this.chkOnUpdate_);
        this.themeCtrl_.process(this.lblSqlText_);
        this.themeCtrl_.process(this.editor);
        this.chkOnDelete_.setMnemonic('D');
        this.chkOnInsert_.setMnemonic('I');
        this.chkOnUpdate_.setMnemonic('U');
        this.rdoBefore_.setMnemonic('B');
        this.rdoAfter_.setMnemonic('F');
        this.rdoStatement_.setMnemonic('T');
        this.rdoRow_.setMnemonic('R');
        this.lblOracleNote_.setForeground(Color.GRAY);
        this.lblTable.setEnabled(false);
        this.txtTable.setEnabled(false);
    }

    private void buildFocusRestorer() {
        ArrayList<JComponent> comps = new ArrayList<JComponent>();
        comps.add(this.txtName_);
        comps.add(this.chkOnDelete_);
        comps.add(this.chkOnInsert_);
        comps.add(this.chkOnUpdate_);
        comps.add(this.rdoAfter_);
        comps.add(this.rdoBefore_);
        comps.add(this.rdoRow_);
        comps.add(this.rdoStatement_);
        this.focusRestorer_ = new FocusRestorer(comps);
    }

    private void addListeners() {
        this.txtName_.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                TriggerEditPanel.this.updateDirty();
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        ActionListener lisCheckDirty = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TriggerEditPanel.this.updateDirty();
            }
        };
        this.chkOnDelete_.addActionListener(lisCheckDirty);
        this.chkOnInsert_.addActionListener(lisCheckDirty);
        this.chkOnUpdate_.addActionListener(lisCheckDirty);
        this.rdoAfter_.addActionListener(lisCheckDirty);
        this.rdoBefore_.addActionListener(lisCheckDirty);
        this.rdoRow_.addActionListener(lisCheckDirty);
        this.rdoStatement_.addActionListener(lisCheckDirty);
    }

    private void updateDirty() {
        if (this.panelContainer_ != null) {
            this.panelContainer_.setTitle(this.getTitle());
        }
    }

    @Override
    public boolean isDirty() {
        String nm = this.txtName_.getText();
        boolean onDelete = this.chkOnDelete_.isSelected();
        boolean onInsert = this.chkOnInsert_.isSelected();
        boolean onUpdate = this.chkOnUpdate_.isSelected();
        boolean execBefore = this.rdoBefore_.isSelected();
        boolean forEachRow = this.rdoRow_.isSelected();
        String sql = this.editor.getText();
        if (this.lastTrg_ != null) {
            if (!this.lastTrg_.getName().equals(nm)) {
                return true;
            }
            if (!this.lastTrg_.getSql().equals(sql)) {
                return true;
            }
            if (onDelete != this.lastTrg_.getFireOnDeleteFlag()) {
                return true;
            }
            if (onInsert != this.lastTrg_.getFireOnInsertFlag()) {
                return true;
            }
            if (onUpdate != this.lastTrg_.getFireOnUpdateFlag()) {
                return true;
            }
            if (execBefore != this.lastTrg_.getExecBefore()) {
                return true;
            }
            if (forEachRow != this.lastTrg_.getForEachRow()) {
                return true;
            }
        } else {
            if (Validator.isStringValid(nm)) {
                return true;
            }
            if (Validator.isStringValid(sql)) {
                return true;
            }
            if (onDelete) {
                return true;
            }
            if (onInsert) {
                return true;
            }
            if (onUpdate) {
                return true;
            }
            if (execBefore) {
                return true;
            }
            if (forEachRow) {
                return true;
            }
        }
        return false;
    }

    @Override
    public ITestResult validateData() {
        String name = this.txtName_.getText();
        boolean onDelete = this.chkOnDelete_.isSelected();
        boolean onInsert = this.chkOnInsert_.isSelected();
        boolean onUpdate = this.chkOnUpdate_.isSelected();
        boolean execBefore = this.rdoBefore_.isSelected();
        boolean forEachRow = this.rdoRow_.isSelected();
        String sql = this.editor.getText();
        Trigger newTrg = null;
        try {
            newTrg = new Trigger(name, onDelete, onInsert, onUpdate, sql, execBefore, forEachRow);
        }
        catch (Exception e) {
            DataEntryResult result = new DataEntryResult(false, e.getMessage());
            return result;
        }
        ITestResult result = BasicCollector.verifyNoDupsNoException(this.table_, this.lastTrg_, newTrg);
        if (!result.getPassed()) {
            return result;
        }
        this.trg_ = newTrg;
        return result;
    }

    @Override
    public void update(UpdateChain chain) {
        if (!this.startedUpdate_ && chain.hasClassName(this.className_) && this.lastTrg_ != null) {
            this.lastTrg_ = this.table_.getKeys(this.className_).contains(this.lastTrg_.getName()) ? (Trigger)this.table_.get(this.className_, this.lastTrg_.getName()) : null;
            this.loadData();
        }
        if (chain.hasClassName(NbEditPanel.class.getName())) {
            this.updateDirty();
        }
    }

    public Trigger getTrigger() {
        this.validateData();
        return this.trg_;
    }

    @Override
    public Identifiable getDataObject() {
        return this.getTrigger();
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(basicSizeStorable__.getSize());
    }

    @Override
    public String getTitle() {
        StringBuilder sb = new StringBuilder(this.getBasicTitle());
        if (this.isDirty()) {
            sb.append("*");
        }
        return sb.toString();
    }

    private String getBasicTitle() {
        String title = this.getTrigger() != null ? this.getTrigger().getName() : "Add Trigger";
        return title;
    }

    @Override
    public Collector getCollector() {
        return this.table_;
    }

    @Override
    public Identifiable getIdfAsIs() {
        return this.trg_;
    }

    @Override
    public String getToolTip() {
        return this.getTitle();
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.TRIGGER;
    }

    @Override
    public ITestResult save() {
        if (this.startedUpdate_) {
            return new DataEntryResult();
        }
        ITestResult result = this.validateData();
        if (result.getPassed()) {
            this.startedUpdate_ = true;
            if (this.lastTrg_ == null) {
                AddToCollector addCmd = new AddToCollector(this.table_, this.trg_);
                addCmd.setCommandChain(App.getCommandChain());
                addCmd.actionPerformed(null);
            } else {
                boolean autoSave = false;
                UpdateInCollector.doUpdate(this.table_, this.lastTrg_, this.trg_, App.getCommandChain(), null, autoSave);
            }
            this.lastTrg_ = this.trg_;
            this.updateDirty();
            this.focusRestorer_.restoreFocus();
            this.startedUpdate_ = false;
        }
        return result;
    }

    @Override
    public void setPanelContainer(IPanelContainer panelContainer) {
        this.panelContainer_ = panelContainer;
    }

    public boolean allowClose() {
        String nm = this.lastTrg_ != null ? this.lastTrg_.getName() : "";
        CloseChecker checker = new CloseChecker(this.isDirty(), nm);
        checker.doCheck();
        if (checker.getDoSave()) {
            this.save();
        }
        return checker.getAllowClose();
    }

    @Override
    public boolean getConserveSpace() {
        return this.conserveSpace_;
    }

    @Override
    public void setConserveSpace(boolean conserveSpace) {
        this.conserveSpace_ = conserveSpace;
        this.editor.setEditable(!conserveSpace);
        this.refreshDisplay();
    }

    @Override
    public Dimension getSize() {
        return basicSizeStorable__.getSize();
    }

    @Override
    public void setSize(Dimension size) {
        basicSizeStorable__.setSize(size);
    }

    private void initComponents() {
        this.setLayout(null);
    }
}

