/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.panel;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.listener.DataEditorVerifier;
import com.harrand.coregui.listener.EditSyncActionListener;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.command.table.ChangeTableProps;
import com.harrand.dbwrenchgui.db.SqlReservedWordGui;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TablePropPanel
extends JPanel
implements DataEditor,
IObserver {
    private Table table_;
    private JLabel lblName_;
    private JTextField txtName_ = new JTextField("");
    private JLabel lblComment_;
    private JTextField txtComment_ = new JTextField("");
    private JLabel lblTableOpts_;
    private JTextField txtTableOpts_ = new JTextField("");
    private boolean syncOnEdit_ = false;
    private boolean startedUpdate_ = false;
    private String className_;
    private ActionListener editSyncActionListener_;
    private InputVerifier verifier_;
    private SwingThemeCtrl themeCtrl_;

    public TablePropPanel(Table table) {
        TablePropPanel tablePropPanel = this;
        this.className_ = tablePropPanel.table_.getClassName();
        LookupUtil.getLookupDb();
        this.table_ = table;
        this.buildControls();
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.setupGui();
        this.loadData();
        this.buildListeners();
        this.setSyncOnEdit(true);
        this.table_.addObserver(this);
    }

    public String getComment() {
        return this.txtComment_.getText();
    }

    public String getTableName() {
        return this.txtName_.getText();
    }

    public String getTableOptions() {
        return this.txtTableOpts_.getText();
    }

    public void setTable(Table table) {
        if (this.table_ != null) {
            this.table_.removeObserver(this);
        }
        this.table_ = table;
        this.loadData();
        this.table_.addObserver(this);
    }

    @Override
    public void setSyncOnEdit(boolean sync) {
        this.syncOnEdit_ = sync;
        if (this.syncOnEdit_) {
            this.addTextVerifiers();
        } else {
            this.removeTextVerifiers();
        }
    }

    private void checkReservedWord(String newName) {
        boolean oldSyncValue = this.syncOnEdit_;
        this.setSyncOnEdit(false);
        SqlReservedWordGui.instance().warnIfReserved(newName);
        this.setSyncOnEdit(oldSyncValue);
    }

    private Database getDb() {
        return LookupUtil.getLookupDb();
    }

    private void addTextVerifiers() {
        this.txtName_.setInputVerifier(this.verifier_);
        this.txtName_.addActionListener(this.editSyncActionListener_);
        this.txtComment_.setInputVerifier(this.verifier_);
        this.txtComment_.addActionListener(this.editSyncActionListener_);
        this.txtTableOpts_.setInputVerifier(this.verifier_);
        this.txtTableOpts_.addActionListener(this.editSyncActionListener_);
    }

    private void removeTextVerifiers() {
        this.txtName_.setInputVerifier(null);
        this.txtName_.removeActionListener(this.editSyncActionListener_);
        this.txtComment_.setInputVerifier(null);
        this.txtComment_.removeActionListener(this.editSyncActionListener_);
        this.txtTableOpts_.setInputVerifier(null);
        this.txtTableOpts_.removeActionListener(this.editSyncActionListener_);
    }

    private void buildListeners() {
        this.editSyncActionListener_ = new EditSyncActionListener(this);
        this.verifier_ = new DataEditorVerifier(this);
    }

    private void setupGui() {
        this.buildControls();
        this.layoutComponents();
        this.setCosmetics();
        this.setNames();
        this.addListeners();
    }

    private void buildControls() {
        String div = "";
        this.lblName_ = new JLabel("Table Name" + div);
        this.lblComment_ = new JLabel("Comment" + div);
        this.lblTableOpts_ = new JLabel("Table Options" + div);
    }

    private void loadData() {
        if (this.table_ != null) {
            this.txtName_.setText(this.table_.getName());
            this.txtComment_.setText(this.table_.getComment());
            this.txtTableOpts_.setText(this.table_.getTableOptions());
        } else {
            this.txtName_.setText("");
            this.txtComment_.setText("");
            this.txtTableOpts_.setText("");
        }
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout(4, 4));
        this.add((Component)this.getMainContainerPanel(), "Center");
        GuiHelper.addEmptyBorder(this);
    }

    private JPanel getMainContainerPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.getMainPanel(), "North");
        return panel;
    }

    private JPanel getMainPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        panel.setLayout(gbl);
        int row = 0;
        GuiHelper.addGridbagPair(this.lblName_, this.txtName_, gbc, panel, row++);
        GuiHelper.addGridbagPair(this.lblComment_, this.txtComment_, gbc, panel, row++);
        GuiHelper.addGridbagPair(this.lblTableOpts_, this.txtTableOpts_, gbc, panel, row++);
        int pad = 4;
        panel.setBorder(BorderFactory.createEmptyBorder(pad, pad, 0, 20 * pad));
        return panel;
    }

    private void setCosmetics() {
        this.themeCtrl_.process(this);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
    }

    private void setNames() {
        this.setName("TablePropPanel");
        this.txtName_.setName("txtName");
        this.txtComment_.setName("txtComment");
        this.txtTableOpts_.setName("txtTableOpts");
    }

    private void addListeners() {
    }

    public Table getTable() {
        this.validateData();
        return this.table_;
    }

    @Override
    public Identifiable getDataObject() {
        return this.getTable();
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(500, 50, 460, 235);
    }

    private void syncData() {
        DataEntryResult rslt;
        String newName;
        this.startedUpdate_ = true;
        String oldName = this.table_.getName();
        if (!oldName.equals(newName = this.getTableName())) {
            this.checkReservedWord(newName);
        }
        Schema schema = this.table_.getSchema();
        ITestResult iTestResult = rslt = oldName.equalsIgnoreCase(newName) ? new DataEntryResult(true) : schema.checkDuplicateName(this.table_.getMapName(), newName);
        if (rslt.getPassed()) {
            this.setBusyCursor();
            ChangeTableProps changeCmd = new ChangeTableProps(this.table_, newName, this.getComment(), this.getTableOptions());
            changeCmd.actionPerformed(null);
            this.setDefaultCursor();
        } else {
            this.removeTextVerifiers();
            GuiMessageHelper.showInputErrMsg(null, rslt);
            this.txtName_.setText(oldName);
            this.addTextVerifiers();
        }
        this.startedUpdate_ = false;
    }

    @Override
    public ITestResult validateData() {
        DataEntryResult result = new DataEntryResult(true);
        this.syncData();
        return result;
    }

    @Override
    public void update(UpdateChain chain) {
        if (!this.startedUpdate_) {
            this.loadData();
        }
    }

    private void setBusyCursor() {
        GuiHelper.setBusyCursor(this);
        GuiHelper.setBusyCursor(this.txtName_);
        GuiHelper.setBusyCursor(this.txtComment_);
        GuiHelper.setBusyCursor(this.txtTableOpts_);
        GuiHelper.setBusyCursor(this.lblName_);
        GuiHelper.setBusyCursor(this.lblComment_);
        GuiHelper.setBusyCursor(this.lblTableOpts_);
    }

    private void setDefaultCursor() {
        GuiHelper.setDefaultCursor(this);
        GuiHelper.setDefaultCursor(this.txtName_);
        GuiHelper.setDefaultCursor(this.txtComment_);
        GuiHelper.setDefaultCursor(this.txtTableOpts_);
        GuiHelper.setDefaultCursor(this.lblName_);
        GuiHelper.setDefaultCursor(this.lblComment_);
        GuiHelper.setDefaultCursor(this.lblTableOpts_);
    }

    public ImageIcon getIcon() {
        return null;
    }

    public String getToolTip() {
        return this.getTitle();
    }

    @Override
    public String getTitle() {
        return "Table Properties";
    }

    @Override
    public Collector getCollector() {
        return this.getDb();
    }
}

