/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.panel;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.Icons;
import com.harrand.coregui.command.CommandChainMgr;
import com.harrand.coregui.command.idf.RenameIdf;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.listener.DataEditorVerifier;
import com.harrand.coregui.listener.EditSyncActionListener;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrenchgui.db.SqlReservedWordGui;
import com.harrand.util.ResMgr;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SchemaEditPanel
extends JPanel
implements DataEditor,
IObserver,
ITitled {
    private Database db_;
    private Schema schema_ = null;
    private String className_ = Schema.getClassName();
    private JPanel namePanel_;
    private JLabel lblName_;
    private JTextField txtName_ = new JTextField("");
    private JLabel lblComment_;
    private JTextField txtComment_ = new JTextField("");
    private boolean syncOnEdit_ = false;
    private boolean startedUpdate_ = false;
    private ActionListener editSyncActionListener_;
    private InputVerifier verifier_;
    private SwingThemeCtrl themeCtrl_;

    public SchemaEditPanel(Schema schema) {
        this.buildControls();
        this.db_ = schema.getDb();
        this.schema_ = schema;
        this.init();
    }

    public SchemaEditPanel(Database db) {
        this.buildControls();
        this.db_ = db;
        this.schema_ = null;
        this.init();
    }

    private void init() {
        this.db_.addObserver(this);
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.setupGui();
        this.loadData();
        this.buildListeners();
    }

    @Override
    public void setSyncOnEdit(boolean sync) {
        this.syncOnEdit_ = sync;
        if (this.syncOnEdit_) {
            this.txtName_.setInputVerifier(this.verifier_);
            this.txtName_.addActionListener(this.editSyncActionListener_);
            this.txtComment_.setInputVerifier(this.verifier_);
            this.txtComment_.addActionListener(this.editSyncActionListener_);
        } else {
            this.txtName_.setInputVerifier(null);
            this.txtName_.addActionListener(this.editSyncActionListener_);
            this.txtComment_.setInputVerifier(null);
            this.txtComment_.removeActionListener(this.editSyncActionListener_);
        }
    }

    private void buildListeners() {
        this.editSyncActionListener_ = new EditSyncActionListener(this);
        this.verifier_ = new DataEditorVerifier(this);
    }

    private void setupGui() {
        this.layoutComponents();
        this.setCosmetics();
        this.setNames();
    }

    private void buildControls() {
        String div = "";
        this.lblName_ = new JLabel(App.getRes("schema.name.label") + div);
        this.lblComment_ = new JLabel("Comment" + div);
    }

    private void loadData() {
        if (this.schema_ != null) {
            this.txtName_.setText(this.schema_.getName());
            this.txtComment_.setText(this.schema_.getComment());
        } else {
            this.txtName_.setText("");
            this.txtComment_.setText("");
        }
    }

    private void layoutComponents() {
        this.namePanel_ = new JPanel();
        this.buildNamePanel(this.namePanel_);
        int inset = 4;
        this.setBorder(GuiHelper.getEmptyBorder());
        this.themeCtrl_.process(this.namePanel_);
        this.setLayout(new BorderLayout(0, 4));
        this.add((Component)this.namePanel_, "North");
    }

    private void buildNamePanel(JPanel panel) {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        panel.setLayout(gbl);
        int row = 0;
        GuiHelper.addGridbagPair(this.lblName_, this.txtName_, gbc, panel, row++);
        GuiHelper.addGridbagPair(this.lblComment_, this.txtComment_, gbc, panel, row++);
    }

    private void setNames() {
        this.setName("SchemaEditPanel");
        this.lblName_.setName("lblName");
        this.txtName_.setName("txtName");
        this.txtComment_.setName("txtComment");
    }

    private void setCosmetics() {
        this.themeCtrl_.process(this);
        this.themeCtrl_.process(this.lblName_);
        this.themeCtrl_.process(this.txtName_);
        this.themeCtrl_.process(this.lblComment_);
        this.themeCtrl_.process(this.txtComment_);
    }

    public Schema getSchema() {
        this.validateData();
        return this.schema_;
    }

    @Override
    public Identifiable getDataObject() {
        return this.getSchema();
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(500, 50, 360, 185);
    }

    private void syncData() throws Exception {
        String newName = this.txtName_.getText();
        String newComment = this.txtComment_.getText();
        boolean syncOnEditWasOn = this.syncOnEdit_;
        ITestResult result = Schema.checkName(newName);
        if (!result.getPassed()) {
            throw new Exception(result.getDetail());
        }
        if (this.schema_ != null) {
            if (this.syncOnEdit_) {
                this.setSyncOnEdit(false);
            }
            String oldNm = this.schema_.getName();
            String oldCmm = this.schema_.getComment();
            if (!oldNm.equals(newName)) {
                ITestResult dupRslt;
                ITestResult iTestResult = dupRslt = oldNm.equalsIgnoreCase(newName) ? new DataEntryResult(true) : this.db_.checkDuplicateName(Schema.getClassName(), newName);
                if (dupRslt.getPassed()) {
                    SqlReservedWordGui.instance().warnIfReserved(newName);
                    this.setBusyCursor();
                    RenameIdf cmdRnm = new RenameIdf(this.db_, this.schema_, oldNm, newName, CommandChainMgr.getCmdChain());
                    cmdRnm.setRenameMgr(this.db_.getRenameMgr());
                    cmdRnm.actionPerformed(new ActionEvent(this, 0, ""));
                    this.setDefaultCursor();
                } else {
                    GuiMessageHelper.showInputErrMsg(null, dupRslt);
                    this.txtName_.setText(oldNm);
                }
            }
            if (syncOnEditWasOn) {
                this.setSyncOnEdit(true);
            }
            if (!oldCmm.equals(newComment)) {
                this.setBusyCursor();
                this.schema_.setComment(newComment);
                Robot robot = new Robot();
                robot.delay(50);
                this.setDefaultCursor();
            }
        } else {
            Schema newSchema = new Schema(newName);
            newSchema.setComment(newComment);
            this.checkDupName(newSchema);
            this.schema_ = newSchema;
        }
    }

    private void checkDupName(Schema newSchema) throws Exception {
        ITestResult dupResult;
        String oldNm;
        String newNm = newSchema.getName();
        String string = oldNm = this.schema_ != null ? this.schema_.getName() : "";
        if (!newNm.equalsIgnoreCase(oldNm) && !(dupResult = this.db_.checkDuplicateName(newSchema.getMapName(), newSchema.getName())).getPassed()) {
            throw new Exception(dupResult.getDetail());
        }
    }

    @Override
    public ITestResult validateData() {
        DataEntryResult result;
        block2: {
            try {
                this.syncData();
                result = new DataEntryResult(true);
            }
            catch (Exception e) {
                result = new DataEntryResult(false, e.getMessage());
                if (this.schema_ == null) break block2;
                this.loadData();
            }
        }
        return result;
    }

    private void setBusyCursor() {
        GuiHelper.setBusyCursor(this);
        GuiHelper.setBusyCursor(this.namePanel_);
        GuiHelper.setBusyCursor(this.txtName_);
        GuiHelper.setBusyCursor(this.txtComment_);
        GuiHelper.setBusyCursor(this.lblName_);
        GuiHelper.setBusyCursor(this.lblComment_);
    }

    private void setDefaultCursor() {
        GuiHelper.setDefaultCursor(this);
        GuiHelper.setDefaultCursor(this.namePanel_);
        GuiHelper.setDefaultCursor(this.txtName_);
        GuiHelper.setDefaultCursor(this.txtComment_);
        GuiHelper.setDefaultCursor(this.lblName_);
        GuiHelper.setDefaultCursor(this.lblComment_);
    }

    @Override
    public void update(UpdateChain chain) {
        if (!this.startedUpdate_ && chain.hasClassName(this.className_) && this.schema_ != null) {
            this.schema_ = this.db_.getKeys(this.className_).contains(this.schema_.getName()) ? (Schema)this.db_.get(this.className_, this.schema_.getName()) : null;
            this.loadData();
        }
        this.startedUpdate_ = false;
    }

    @Override
    public String getTitle() {
        StringBuffer sb = this.schema_ == null ? new StringBuffer(ResMgr.getRes("add.label")) : new StringBuffer(ResMgr.getRes("edit.label"));
        sb.append(" " + App.getRes("schema.label"));
        return sb.toString();
    }

    @Override
    public String getToolTip() {
        return this.getTitle();
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.SCHEMA;
    }

    @Override
    public Collector getCollector() {
        return this.db_;
    }
}

