/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.panel;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.dataEntry.IDataEditPanel;
import com.harrand.coreclasses.dataEntry.IDefaultNamer;
import com.harrand.coreclasses.dataEntry.UntitledNamer;
import com.harrand.coreclasses.display.IPanelContainer;
import com.harrand.coreclasses.element.IIdfAsIs;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ICloseVerify;
import com.harrand.coreclasses.interfaces.IRefreshable;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.interfaces.implementation.BasicCollector;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.Icons;
import com.harrand.coregui.command.idf.AddToCollector;
import com.harrand.coregui.command.idf.UpdateInCollector;
import com.harrand.coregui.dataEntry.CloseChecker;
import com.harrand.coregui.dataEntry.IFocusable;
import com.harrand.coregui.display.BasicSizeStorable;
import com.harrand.coregui.display.ISizeStorable;
import com.harrand.coregui.display.ISpaceConservable;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.panel.XpHeaderPanel;
import com.harrand.dbwrench.object.Proc;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrenchgui.sub.NbEditPanel;
import com.harrand.dbwrenchgui.sub.editor.DbwEditor;
import com.harrand.util.LogUtil;
import com.harrand.util.Validator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public final class ProcEditPanel
extends JPanel
implements DataEditor,
IObserver,
ICloseVerify,
IDataEditPanel,
ISizeStorable,
IFocusable,
ISpaceConservable,
IRefreshable,
IIdfAsIs {
    private Schema schema_;
    private Proc lastProc_ = null;
    private Proc proc_ = null;
    private final String className_ = Proc.getClassName();
    private IPanelContainer panelContainer_;
    private static ISizeStorable basicSizeStorable__ = new BasicSizeStorable(new Dimension(500, 500));
    private JPanel mainEditPanel_;
    private JLabel lblName_;
    private final JTextField txtName_ = new JTextField("");
    private JLabel lblComment_;
    private final JTextField txtComment_ = new JTextField("");
    private JLabel lblSrc_;
    private final JTextPane txtNote_ = new JTextPane();
    private DbwEditor editor;
    private XpHeaderPanel header_;
    private final JButton btnHelp_ = new JButton(Icons.QUESTION_SMALL);
    private final IDefaultNamer namer_ = new UntitledNamer();
    private boolean startedUpdate_ = false;
    private boolean conserveSpace_ = false;
    private int objId_ = -1;
    private SwingThemeCtrl themeCtrl_;

    public ProcEditPanel(Proc proc) {
        this.buildControls();
        this.setProc(proc);
        this.init();
    }

    public ProcEditPanel(Schema schema) {
        this.buildControls();
        this.schema_ = schema;
        this.setProc(null);
        this.init();
    }

    public void setProc(Proc proc) {
        this.lastProc_ = proc;
        if (this.lastProc_ != null) {
            this.schema_ = this.lastProc_.getSchema();
            this.objId_ = this.schema_.getId(this.lastProc_);
        } else {
            this.objId_ = -1;
        }
        this.schema_.addObserver(this);
        this.loadData();
        this.updateDirty();
    }

    private void init() {
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.setupGui();
        this.buildFocusRestorer();
    }

    private void buildFocusRestorer() {
        ArrayList<JTextField> comps = new ArrayList<JTextField>();
        comps.add(this.txtComment_);
    }

    @Override
    public void setSyncOnEdit(boolean sync) {
    }

    @Override
    public void transferFocus() {
        this.txtComment_.requestFocus();
    }

    private void setupGui() {
        this.layoutComponents();
        this.setCosmetics();
        this.setNames();
        this.addListeners();
    }

    private void buildControls() {
        String div = "";
        this.lblName_ = new JLabel(App.getResource("proc.name.label") + div);
        this.lblSrc_ = new JLabel("Source Code" + div);
        this.lblComment_ = new JLabel("Comment" + div);
        this.txtNote_.setText("Procedure Name is parsed from Source Code, see the Help tab for more details");
        this.txtNote_.setBackground(this.getBackground());
        this.txtNote_.setEditable(false);
        this.txtNote_.setForeground(Color.BLACK);
        this.editor = new DbwEditor();
        this.editor.addObserver(this);
    }

    private void loadData() {
        if (this.lastProc_ != null) {
            this.txtComment_.setText(this.lastProc_.getComment());
            this.editor.setText(this.lastProc_.getSrc());
        } else {
            this.txtComment_.setText("");
            this.editor.setText("");
        }
        this.updateTxtName();
    }

    private void layoutComponents() {
        this.buildMainPanel();
        this.setLayout(new BorderLayout());
        this.refreshDisplay();
    }

    @Override
    public void refresh() {
        if (this.objId_ >= 0 && this.schema_.contains(this.objId_)) {
            Identifiable idf = this.schema_.getIdf(this.objId_);
            if (idf instanceof Proc) {
                this.setProc((Proc)idf);
            } else {
                String msg = idf == null ? "null" : idf.getClass().getName();
                LogUtil.logErr("ProcEditPan.Refresh: expected Proc but was: " + msg);
            }
            this.loadData();
        }
    }

    private void refreshDisplay() {
        this.removeAll();
        if (!this.conserveSpace_) {
            this.add((Component)this.header_, "North");
        }
        this.add((Component)this.mainEditPanel_, "Center");
        this.setBorders();
    }

    private void buildMainPanel() {
        JPanel namePanel = new JPanel();
        JPanel textPanel = new JPanel();
        JPanel panel = new JPanel();
        this.initHeaderPanel();
        this.buildNamePanel(namePanel);
        this.buildTextPanel(textPanel);
        this.mainEditPanel_ = new JPanel();
        this.themeCtrl_.process(namePanel);
        this.themeCtrl_.process(textPanel);
        this.mainEditPanel_.setLayout(new BorderLayout(0, 4));
        this.mainEditPanel_.add((Component)namePanel, "North");
        this.mainEditPanel_.add((Component)textPanel, "Center");
    }

    private void initHeaderPanel() {
        String hdrTitle = StrHelper.getAddOrEditText(this.lastProc_) + App.getResource("proc.label");
        this.header_ = new XpHeaderPanel(hdrTitle, null);
    }

    private void setBorders() {
        if (this.conserveSpace_) {
            this.mainEditPanel_.setBorder(null);
            GuiHelper.addEmptyBorder(this);
        } else {
            GuiHelper.addReducedBodyPanelBorder(this.mainEditPanel_);
            this.setBorder(null);
        }
    }

    private void showNameHelp() {
        String title = "Procedure Naming Help";
        String msg = "In DbWrench procedure names are parsed from the 'Source Code' of the procedure.\nThis is done to prevent one name being specified in the name field\nand a different name being specified in the 'Source Code'.\n\nWhen a name is successfully parsed it is displayed in the 'Procedure Name' field,\na generic name is displayed until then. A parse is attempted each time\n'Save' is clicked.\n\nPostgreSQL Parsing:\nParses between the end of 'create function' and the end of the next ')'.\n\nMicrosoft SQL Server Parsing:\nParses between the end of 'create proc' or 'create procedure' and the end of the next word.\n\nMySQL Parsing:\nUses a combination of both the above methods. Uses the PostgreSQL method for functions \nand the SQL Server method for procedures.";
        GuiMessageHelper.showOptionPaneMsg(null, title, msg, 1);
    }

    private void buildNamePanel(JPanel panel) {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        panel.setLayout(gbl);
        int row = 0;
        GuiHelper.addGridbagPair(this.lblName_, this.getNameSubPanel(), gbc, panel, row++);
        GuiHelper.addGridbagPair(this.lblComment_, this.txtComment_, gbc, panel, row++);
    }

    private JPanel getNameSubPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(this.txtName_);
        panel.add(Box.createHorizontalStrut(25));
        panel.add(this.btnHelp_);
        return panel;
    }

    private void buildTextPanel(JPanel textPanel) {
        textPanel.setLayout(new BorderLayout());
        textPanel.add((Component)this.lblSrc_, "North");
        textPanel.add((Component)this.editor, "Center");
    }

    private void setNames() {
        this.setName("ProcEditPanel");
        this.lblName_.setName("lblName");
        this.txtName_.setName("txtName");
        this.txtComment_.setName("txtComment");
        this.lblSrc_.setName("lblSqlText");
        this.editor.setName("srcTextPanel");
    }

    private void setCosmetics() {
        this.txtName_.setEditable(false);
        this.txtName_.setToolTipText("Procedure names are not editable. They are parsed from the source code.");
        this.themeCtrl_.process(this);
        this.themeCtrl_.process(this.lblName_);
        this.themeCtrl_.process(this.txtName_);
        this.themeCtrl_.process(this.lblComment_);
        this.themeCtrl_.process(this.txtComment_);
        this.themeCtrl_.process(this.lblSrc_);
        this.btnHelp_.setMinimumSize(this.txtName_.getMinimumSize());
    }

    private void addListeners() {
        this.addListenersGetFocus();
        this.txtComment_.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                ProcEditPanel.this.updateDirty();
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.btnHelp_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProcEditPanel.this.showNameHelp();
            }
        });
    }

    private void addListenersGetFocus() {
    }

    private void updateTxtName() {
        String name = this.lastProc_ != null ? this.lastProc_.getName() : this.getDefaultName();
        this.txtName_.setText(name);
    }

    private String getDefaultName() {
        ArrayList currentNames = new ArrayList(this.schema_.getKeys(this.className_));
        String nextName = this.namer_.getNextName(currentNames);
        return nextName;
    }

    public Proc getProc() {
        return (Proc)this.getDataObject();
    }

    @Override
    public Identifiable getDataObject() {
        this.validateData();
        return this.proc_;
    }

    public Identifiable getObjectAsIs() {
        return this.lastProc_;
    }

    @Override
    public Identifiable getIdfAsIs() {
        return this.getObjectAsIs();
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(basicSizeStorable__.getSize());
    }

    @Override
    public ITestResult validateData() {
        Proc newProc;
        String src = this.editor.getText();
        String comment = this.txtComment_.getText();
        String defaultName = this.txtName_.getText();
        ITestResult result = new DataEntryResult(true);
        Proc proc = newProc = src.length() > 0 ? new Proc(src, comment, defaultName) : null;
        if (newProc == null) {
            result = new DataEntryResult(false, "Invalid Text", "The source code for a procedure can not be empty");
            return result;
        }
        result = BasicCollector.verifyNoDupsNoException(this.schema_, this.lastProc_, newProc);
        if (!result.getPassed()) {
            return result;
        }
        newProc.setSchema(this.schema_);
        this.proc_ = newProc;
        return result;
    }

    private void checkMySqlCmmUpdated() {
        if (this.proc_ != null) {
            this.txtComment_.setText(this.proc_.getComment());
        }
    }

    @Override
    public void update(UpdateChain chain) {
        if (chain.hasClassName(Boolean.class.getName())) {
            this.updateDirty();
        }
        if (!this.startedUpdate_ && chain.hasClassName(this.className_) && this.lastProc_ != null) {
            this.lastProc_ = this.schema_.getKeys(this.className_).contains(this.lastProc_.getName()) ? (Proc)this.schema_.get(this.className_, this.lastProc_.getName()) : null;
            this.loadData();
        }
        if (chain.hasClassName(NbEditPanel.class.getName())) {
            this.updateDirty();
        }
    }

    @Override
    public String getTitle() {
        StringBuilder sb = new StringBuilder(this.getBasicTitle());
        if (this.isDirty()) {
            sb.append("*");
        }
        return sb.toString();
    }

    private String getBasicTitle() {
        String raw = this.getProc() != null ? this.getProc().getName() : "Add Proc";
        String title = StrHelper.getTruncated(raw, 35);
        return title;
    }

    private void updateDirty() {
        if (this.panelContainer_ != null) {
            this.panelContainer_.setTitle(this.getTitle());
        }
    }

    @Override
    public boolean allowClose() {
        String procName = this.lastProc_ != null ? this.lastProc_.getName() : "";
        CloseChecker checker = new CloseChecker(this.isDirty(), procName);
        checker.doCheck();
        if (checker.getDoSave()) {
            this.save();
        }
        return checker.getAllowClose();
    }

    @Override
    public boolean isDirty() {
        String nm = this.txtName_.getText();
        String cmm = this.txtComment_.getText();
        String src = this.editor.getText();
        if (this.lastProc_ != null) {
            if (!this.lastProc_.getName().equals(nm)) {
                return true;
            }
            if (!this.lastProc_.getComment().equals(cmm)) {
                return true;
            }
            String lastSrc = this.lastProc_.getSrc();
            if (!lastSrc.equals(src)) {
                return true;
            }
        } else {
            if (Validator.isStringValid(cmm)) {
                return true;
            }
            if (Validator.isStringValid(src)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Collector getCollector() {
        return this.schema_;
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.PROC;
    }

    @Override
    public String getToolTip() {
        return "Edit Procedure";
    }

    @Override
    public ITestResult save() {
        if (this.startedUpdate_) {
            return new DataEntryResult();
        }
        ITestResult result = this.validateData();
        if (result.getPassed()) {
            this.startedUpdate_ = true;
            if (this.lastProc_ == null) {
                AddToCollector addCmd = new AddToCollector(this.schema_, this.proc_);
                addCmd.setCommandChain(App.getCommandChain());
                addCmd.actionPerformed(null);
            } else {
                boolean autoSave = false;
                UpdateInCollector.doUpdate(this.schema_, this.lastProc_, this.proc_, App.getCommandChain(), null, autoSave);
            }
            this.lastProc_ = this.proc_;
            this.updateTxtName();
            this.checkMySqlCmmUpdated();
            this.updateDirty();
            this.startedUpdate_ = false;
        }
        return result;
    }

    @Override
    public void setPanelContainer(IPanelContainer panelContainer) {
        this.panelContainer_ = panelContainer;
    }

    @Override
    public Dimension getSize() {
        return basicSizeStorable__.getSize();
    }

    @Override
    public void setSize(Dimension size) {
        basicSizeStorable__.setSize(size);
    }

    @Override
    public boolean getConserveSpace() {
        return this.conserveSpace_;
    }

    @Override
    public void setConserveSpace(boolean conserveSpace) {
        this.conserveSpace_ = conserveSpace;
        boolean editable = !conserveSpace;
        this.editor.setEditable(editable);
        this.txtComment_.setEditable(editable);
        this.refreshDisplay();
    }
}

