/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.panel;

import com.harrand.coreclasses.list.IConfigList;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.script.IConnectionConfig;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.list.IconListCellRenderer;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.util.FileHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class JdbcConfigListPanel
extends JPanel
implements IConfigList,
IObserver {
    private DbUser user_;
    private JComboBox configCombo_;
    private JLabel lblConfig_;
    private IObservable observable_ = new BasicObservable();
    private SwingThemeCtrl themeCtrl_;
    private boolean includeGenericConfig_;
    private List genericConfigs_;
    private Database filterDb_ = null;
    private ActionListener lisCombo_;

    public JdbcConfigListPanel(DbUser user) {
        this.user_ = user;
        this.user_.addObserver(this);
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.buildControls();
        this.buildPanel();
        this.addListeners();
        this.setCosmetics();
        this.setNames();
    }

    public void setIncludeGenericConfigs(boolean include) {
        this.includeGenericConfig_ = include;
        this.loadConnectionConfigs();
    }

    public boolean getIncludeGenericConfigs() {
        return this.includeGenericConfig_;
    }

    public void setConfig(JdbcConfig config) {
        this.configCombo_.setSelectedItem(config);
    }

    public void setConfig(int dbmsId, String serverNm, String dbNm) {
        int itemCount = this.configCombo_.getItemCount();
        boolean itemFound = false;
        int foundIdx = -1;
        for (int i = 0; i < itemCount && !itemFound; ++i) {
            JdbcConfig config = (JdbcConfig)this.configCombo_.getItemAt(i);
            if (config.getDbmsId() != dbmsId || !config.getServer().equalsIgnoreCase(serverNm) || !config.getObjectInstanceName().equalsIgnoreCase(dbNm)) continue;
            itemFound = true;
            foundIdx = i;
        }
        if (foundIdx >= 0) {
            this.configCombo_.setSelectedIndex(foundIdx);
        }
    }

    public void setFilterDatabase(Database db) {
        this.filterDb_ = db;
        this.loadConnectionConfigs();
    }

    public Database getFilterDatabase() {
        return this.filterDb_;
    }

    @Override
    public String toString() {
        return "JdbcConfigListPanel: " + this.user_.getUserName();
    }

    public int getConfigCount() {
        return this.configCombo_.getItemCount();
    }

    private void buildControls() {
        this.configCombo_ = new JComboBox();
        this.configCombo_.setRenderer(new IconListCellRenderer());
        this.loadConnectionConfigs();
        this.lblConfig_ = new JLabel(FileHelper.getResource("connection.label"));
    }

    private void buildPanel() {
        this.setLayout(new BorderLayout(4, 0));
        this.add((Component)this.lblConfig_, "West");
        this.add((Component)this.configCombo_, "Center");
    }

    private void setCosmetics() {
        this.setBorder(GuiHelper.getEmptyBorder());
        this.themeCtrl_.process(this);
        this.themeCtrl_.process(this.configCombo_);
        this.themeCtrl_.process(this.lblConfig_);
    }

    private void setNames() {
        this.setName("JdbcConfigListPanel");
        this.configCombo_.setName("configCombo");
        this.lblConfig_.setName("lblConfig");
    }

    private void addListeners() {
        this.lisCombo_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JdbcConfigListPanel.this.notifyObservers(new UpdateChain(this));
            }
        };
        this.configCombo_.addActionListener(this.lisCombo_);
    }

    private void loadConnectionConfigs() {
        List configs = this.user_.values(JdbcConfig.clazz());
        if (this.filterDb_ != null) {
            ArrayList<JdbcConfig> keepConfigs = new ArrayList<JdbcConfig>();
            for (JdbcConfig config : configs) {
                String dbName = config.getObjectInstanceName();
                if (dbName.equalsIgnoreCase(this.filterDb_.getName())) {
                    keepConfigs.add(config);
                    continue;
                }
                if (config.getDbmsId() != 2) continue;
                keepConfigs.add(config);
            }
            configs.retainAll(keepConfigs);
        }
        if (this.includeGenericConfig_) {
            configs.addAll(JdbcConfig.getGenericConfigs());
        }
        this.configCombo_.removeActionListener(this.lisCombo_);
        GuiHelper.loadComboBox(this.configCombo_, configs.toArray());
        this.configCombo_.addActionListener(this.lisCombo_);
        if (configs.isEmpty()) {
            this.configCombo_.setPrototypeDisplayValue("--------------");
        } else {
            this.configCombo_.setPrototypeDisplayValue(null);
        }
    }

    private boolean checkConfigSelected() {
        if (this.configCombo_.getSelectedIndex() > -1) {
            return true;
        }
        GuiMessageHelper.showInputErrMsg(null, FileHelper.getResource("err.title.invalid.selection"), App.getResouceStringApp("err.connection.not.selected"));
        return false;
    }

    @Override
    public IConnectionConfig getSelectedConfig() {
        if (this.checkConfigSelected()) {
            return (IConnectionConfig)this.configCombo_.getSelectedItem();
        }
        return null;
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void update(UpdateChain chain) {
        if (chain.hasInteface(IConnectionConfig.class.getName())) {
            this.loadConnectionConfigs();
        }
    }
}

