/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.panel;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestCtrl;
import com.harrand.coreclasses.interfaces.ITestCtrlSource;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.Icons;
import com.harrand.coregui.display.BasicSizeStorable;
import com.harrand.coregui.display.ISizeStorable;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.list.IconListCellRenderer;
import com.harrand.coregui.list.MultikeyComboSelectionManager;
import com.harrand.coregui.panel.HeaderPanel;
import com.harrand.coregui.panel.TestPanel;
import com.harrand.coregui.text.IntegerOnlyDoc;
import com.harrand.dbwrench.element.schema.SchemaIgnoreCtrl;
import com.harrand.dbwrench.jdbc.Dbms;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.jdbc.JdbcConfigTestCtrl;
import com.harrand.dbwrench.jdbc.validators.JdbcConfigValidator;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrenchgui.option.SchemaIgnorePanel;
import com.harrand.util.FileHelper;
import com.harrand.util.ResMgr;
import com.harrand.util.Validator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public final class JdbcConfigEditPanel
extends JPanel
implements DataEditor,
IObserver,
ISizeStorable,
ITestCtrlSource,
ITitled {
    private JdbcConfig config_;
    private JTabbedPane tabPane;
    private SchemaIgnorePanel ignorePanel;
    private JLabel lblDbms_;
    private JComboBox cboDbms_ = new JComboBox();
    private JLabel lblServer_;
    private JTextField txtServer_ = new JTextField();
    private JLabel lblDatabaseName_;
    private JTextField txtDatabaseName_ = new JTextField();
    private JLabel lblUserName_;
    private JTextField txtUserName_ = new JTextField();
    private JLabel lblPassword_;
    private JPasswordField txpPassWord_ = new JPasswordField();
    private JLabel lblDriverClassName_;
    private JTextField txtDriverClassName_ = new JTextField();
    private JLabel lblPort_;
    private JTextField txtPort_ = new JTextField(6);
    private JLabel lblSsl_;
    private JCheckBox chkSsl_ = new JCheckBox();
    private JLabel lblOptional_;
    private JTextField txtOptional_ = new JTextField();
    private JLabel lblDsn_;
    private JTextField txtDsn_ = new JTextField();
    private JLabel lblWarning = new JLabel();
    private SwingThemeCtrl themeCtrl_;
    private static ISizeStorable basicSizeStorable__ = new BasicSizeStorable(new Dimension(475, 580));
    private static final String DIV = "";

    public JdbcConfigEditPanel(JdbcConfig config) {
        this.config_ = config;
        this.themeCtrl_ = App.getThemeCtrl();
        this.buildControls();
        this.addListeners();
        this.buildPanel();
        this.setCosmetics();
        this.setNames();
        this.enableWidgets();
    }

    private void buildPanel() {
        this.layoutMainPanel();
    }

    public void layoutMainPanel() {
        this.loadValues();
        this.buildIgnorePanel();
        this.buildTabPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabPane, "North");
        this.add((Component)new TestPanel(this), "South");
    }

    private void buildControls() {
        this.lblDbms_ = new JLabel(App.getResource("dbms.label") + DIV);
        this.lblServer_ = new JLabel(FileHelper.getResource("server.label") + DIV);
        this.lblDatabaseName_ = new JLabel(this.getDbNameText());
        this.lblUserName_ = new JLabel(FileHelper.getResource("user.name.label") + DIV);
        this.lblPassword_ = new JLabel(FileHelper.getResource("password.label") + DIV);
        this.lblDriverClassName_ = new JLabel(App.getResource("jdbc.driver.label") + DIV);
        this.lblPort_ = new JLabel(FileHelper.getResource("server.port.label") + DIV);
        this.lblSsl_ = new JLabel("SSL");
        this.lblOptional_ = new JLabel("Optional Parameters");
        this.lblDsn_ = new JLabel(App.getResource("odbc.dsn.label") + DIV);
        this.txtPort_.setDocument(new IntegerOnlyDoc());
    }

    private String getDbNameText() {
        Dbms selectedDbms = this.getSelectedDbms();
        String baseText = selectedDbms != null && selectedDbms.isOracle() ? "SID or Service" : App.getResource("database.name.label");
        return baseText + DIV;
    }

    private void buildIgnorePanel() {
        SchemaIgnoreCtrl schemaIgnoreCtrl = this.config_ != null ? this.config_.getSchemaIgnoreCtrl() : null;
        this.ignorePanel = new SchemaIgnorePanel(schemaIgnoreCtrl);
    }

    private void buildTabPane() {
        this.tabPane = new JTabbedPane(3);
        this.tabPane.add((Component)this.getParameterPanel(), 0);
        this.tabPane.add((Component)this.ignorePanel, 1);
        this.tabPane.setTitleAt(0, "Connection Parameters");
        this.tabPane.setTitleAt(1, "Ignore Schemas");
    }

    private JPanel getParameterPanel() {
        JPanel panel = new JPanel(new BorderLayout(4, 4));
        panel.add(this.getHeaderPanel(), "North");
        panel.add((Component)this.getFieldsNorthPanel(), "Center");
        panel.add((Component)this.getWarningPanel(), "South");
        GuiHelper.addEmptyBorder(panel);
        return panel;
    }

    private JPanel getFieldsNorthPanel() {
        JPanel panel = GuiHelper.getBorderLayoutPanel();
        panel.add((Component)this.getFieldsPanel(), "North");
        panel.add((Component)new JLabel(), "Center");
        return panel;
    }

    private JPanel getFieldsPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        int row = 0;
        this.addGridbagPair(this.lblDbms_, this.cboDbms_, gbc, panel, row++);
        this.addGridbagPair(this.lblServer_, this.txtServer_, gbc, panel, row++);
        this.addGridbagPair(this.lblDatabaseName_, this.txtDatabaseName_, gbc, panel, row++);
        this.addGridbagPair(this.lblUserName_, this.txtUserName_, gbc, panel, row++);
        this.addGridbagPair(this.lblPassword_, this.txpPassWord_, gbc, panel, row++);
        this.addGridbagPair(this.lblPort_, this.txtPort_, gbc, panel, row++);
        this.addGridbagPair(this.lblSsl_, this.chkSsl_, gbc, panel, row++);
        this.addGridbagPair(this.lblOptional_, this.txtOptional_, gbc, panel, row++);
        this.addGridbagPair(this.lblDsn_, this.txtDsn_, gbc, panel, row++);
        return panel;
    }

    private JPanel getWarningPanel() {
        JPanel panel = new JPanel();
        panel.add(this.lblWarning);
        return panel;
    }

    private void addGridbagPair(JComponent firstItem, JComponent secondItem, GridBagConstraints gbc, JPanel panel, int row) {
        GuiHelper.buildGridBagConstraints(gbc, 0, row, 1, 1, 10.0, 0.0);
        gbc.fill = 0;
        gbc.anchor = 13;
        panel.add((Component)firstItem, gbc);
        GuiHelper.buildGridBagConstraints(gbc, 1, row, 1, 1, 90.0, 0.0);
        gbc.fill = 2;
        panel.add((Component)secondItem, gbc);
    }

    private void setCosmetics() {
        this.cboDbms_.setRenderer(new IconListCellRenderer());
        this.cboDbms_.setKeySelectionManager(new MultikeyComboSelectionManager());
        this.txpPassWord_.setEchoChar('\u25cf');
        this.lblWarning.setForeground(Color.RED);
        this.themeCtrl_.process(this);
        this.themeCtrl_.process(this.cboDbms_);
        this.themeCtrl_.process(this.txtServer_);
        this.themeCtrl_.process(this.txtDatabaseName_);
        this.themeCtrl_.process(this.txtUserName_);
        this.themeCtrl_.process(this.txpPassWord_);
        this.themeCtrl_.process(this.txtPort_);
        this.themeCtrl_.process(this.txtDriverClassName_);
        this.themeCtrl_.process(this.txtDsn_);
        this.themeCtrl_.process(this.lblDbms_);
        this.themeCtrl_.process(this.lblServer_);
        this.themeCtrl_.process(this.lblDatabaseName_);
        this.themeCtrl_.process(this.lblUserName_);
        this.themeCtrl_.process(this.lblPassword_);
        this.themeCtrl_.process(this.lblPort_);
        this.themeCtrl_.process(this.lblDriverClassName_);
        this.themeCtrl_.process(this.lblDsn_);
        this.themeCtrl_.process(this.lblOptional_);
    }

    private void loadValues() {
        this.loadDbmsCombo();
        if (this.config_ != null) {
            this.cboDbms_.setSelectedItem(this.config_.getDbms());
            this.txtServer_.setText(this.config_.getServer());
            this.txtDatabaseName_.setText(this.config_.getObjectInstanceName());
            this.txtUserName_.setText(this.config_.getUserName());
            this.txpPassWord_.setText(this.config_.getPassword());
            String portStr = Integer.toString(this.config_.getPort());
            this.txtPort_.setText(portStr);
            String portOut = this.txtPort_.getText();
            this.chkSsl_.setSelected(this.config_.getSSL());
            this.txtDsn_.setText(this.config_.getDsn());
            this.txtOptional_.setText(this.config_.getOptionalParams());
        }
    }

    private void loadDbmsCombo() {
        Object oldSelection = this.cboDbms_.getSelectedItem();
        this.cboDbms_.setModel(new DefaultComboBoxModel<Object>(Dbms.getDbmsList().toArray()));
        if (oldSelection != null) {
            this.cboDbms_.setSelectedItem(oldSelection);
        }
    }

    private void addListeners() {
        this.addComboListeners();
    }

    private void addComboListeners() {
        this.cboDbms_.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (JdbcConfigEditPanel.this.cboDbms_.getSelectedIndex() > -1) {
                    Dbms dbms = JdbcConfigEditPanel.this.getSelectedDbms();
                    JdbcConfigEditPanel.this.enableWidgets();
                    JdbcConfigEditPanel.this.refreshLabelTexts();
                }
            }
        });
    }

    private Dbms getSelectedDbms() {
        return (Dbms)this.cboDbms_.getSelectedItem();
    }

    private void refreshLabelTexts() {
        this.lblDatabaseName_.setText(this.getDbNameText());
    }

    private void enableWidgets() {
        boolean isJdbc = !this.getSelectedDbms().isMsAccess();
        this.toggelWidgetDisplay(isJdbc);
    }

    private void toggelWidgetDisplay(boolean isJdbcConn) {
        this.displayWidgetPair(this.txtServer_, this.lblServer_, isJdbcConn);
        this.displayWidgetPair(this.txtDatabaseName_, this.lblDatabaseName_, isJdbcConn);
        this.displayWidgetPair(this.txtUserName_, this.lblUserName_, isJdbcConn);
        this.displayWidgetPair(this.txpPassWord_, this.lblPassword_, isJdbcConn);
        this.displayWidgetPair(this.txtPort_, this.lblPort_, isJdbcConn);
        this.displayWidgetPair(this.chkSsl_, this.lblSsl_, isJdbcConn);
        this.displayWidgetPair(this.txtOptional_, this.lblOptional_, isJdbcConn);
        this.displayWidgetPair(this.txtDsn_, this.lblDsn_, !isJdbcConn);
    }

    private void displayWidgetPair(JComponent labelComp, JComponent inputComp, boolean display) {
        labelComp.setEnabled(display);
        labelComp.setVisible(display);
        inputComp.setEnabled(display);
        inputComp.setVisible(display);
    }

    private void setNames() {
        this.setName("JdbcConfigEditPanel");
        this.cboDbms_.setName("cboDbms");
        this.txtServer_.setName("txtServer");
        this.txtDatabaseName_.setName("txtDatabaseName");
        this.txtUserName_.setName("txtUserName");
        this.txpPassWord_.setName("txpPassWord");
        this.txtDriverClassName_.setName("txtDriverClassName");
        this.txtPort_.setName("txtPort");
        this.chkSsl_.setName("chkSsl");
        this.txtOptional_.setName("txtOptional");
        this.txtDsn_.setName("txtDsn");
    }

    @Override
    public ITestResult validateData() {
        DataEntryResult result;
        try {
            this.syncData();
            result = new DataEntryResult(true);
        }
        catch (Exception e) {
            result = new DataEntryResult(false, e.getMessage());
            this.config_ = null;
        }
        return result;
    }

    private void syncData() throws Exception {
        Dbms dbms = this.getDbms();
        String dbmsName = dbms.getName();
        String server = this.txtServer_.getText();
        String dbName = this.txtDatabaseName_.getText();
        String userName = this.txtUserName_.getText();
        String pwd = new String(this.txpPassWord_.getPassword());
        String driver = dbms.getDefaultDriverName();
        String dsn = this.txtDsn_.getText();
        String optional = this.txtOptional_.getText();
        int port = this.syncPort();
        boolean ssl = this.chkSsl_.isSelected();
        this.config_ = new JdbcConfig(dbmsName, server, dbName, dsn, userName, pwd, port, driver);
        this.config_.setSSL(ssl);
        this.config_.setOptionalParams(optional);
        this.syncIgnoreCtrl();
        this.checkInputs();
    }

    public void syncIgnoreCtrl() {
        this.ignorePanel.syncData();
        this.config_.setSchemaIgnoreCtrl(this.ignorePanel.getSchemaIgnoreCtrl());
    }

    private void checkInputs() {
        JdbcConfigValidator validator = new JdbcConfigValidator();
        ITestResult result = validator.validate(this.config_);
        String warnText = DIV;
        ImageIcon icon = null;
        if (!result.getPassed()) {
            warnText = result.getDetail();
            icon = Icons.WARNING;
        }
        this.lblWarning.setIcon(icon);
        this.lblWarning.setText(warnText);
    }

    private Dbms getDbms() throws Exception {
        if (this.cboDbms_.getSelectedIndex() > -1) {
            return this.getSelectedDbms();
        }
        throw new IllegalArgumentException(App.getResource("err.dbms.not.specified"));
    }

    private int syncPort() {
        String portTextA = this.txtPort_.getText();
        if (!Validator.isStringValid(portTextA)) {
            this.txtPort_.setText("0");
        }
        String portTextB = this.txtPort_.getText();
        int intValue = Integer.parseInt(portTextB);
        return intValue;
    }

    @Override
    public ITestCtrl getTestCtrl() {
        this.validateData();
        return new JdbcConfigTestCtrl(this.config_);
    }

    @Override
    public String getTestTitle() {
        return new JdbcConfigTestCtrl(this.config_).getTitle();
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(basicSizeStorable__.getSize());
    }

    @Override
    public Identifiable getDataObject() {
        this.validateData();
        return this.config_;
    }

    @Override
    public void update(UpdateChain chain) {
        if (chain.hasClassName(Dbms.clazz())) {
            this.loadDbmsCombo();
        }
    }

    @Override
    public String getTitle() {
        StringBuffer sb = this.config_ == null ? new StringBuffer(ResMgr.getRes("add.label")) : new StringBuffer(ResMgr.getRes("edit.label"));
        sb.append(" " + App.getRes("display.name.JdbcConfig"));
        return sb.toString();
    }

    @Override
    public String getToolTip() {
        return this.getTitle();
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.CONNECT;
    }

    @Override
    public void setSyncOnEdit(boolean sync) {
    }

    @Override
    public Collector getCollector() {
        return null;
    }

    @Override
    public Dimension getSize() {
        return basicSizeStorable__.getSize();
    }

    @Override
    public void setSize(Dimension size) {
        basicSizeStorable__.setSize(size);
    }

    private Component getHeaderPanel() {
        return new HeaderPanel("Connection Parameters", 5, true);
    }
}

