/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.panel;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.Icons;
import com.harrand.coregui.command.CommandChainMgr;
import com.harrand.coregui.command.idf.UpdateInCollector;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.listener.DataEditorVerifier;
import com.harrand.dbwrench.jdbc.CustomTypeIdCtrl;
import com.harrand.dbwrench.object.CustomType;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Schema;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class CustomTypePanel
extends JPanel
implements DataEditor,
ITitled,
IObserver {
    private Schema schema_;
    private CustomType type_;
    private JLabel lblName_ = new JLabel("Name");
    private JTextField txtName_ = new JTextField("");
    private JLabel lblNotes_ = new JLabel("Notes");
    private JTextArea txtNotes_ = new JTextArea();
    private JButton btnUpdate_ = GuiHelper.getUpdateBtn();
    private boolean syncOnEdit_ = false;
    private boolean startedUpdate_ = false;
    private InputVerifier verifier_;
    private ActionListener lisUpdate_;
    private boolean showBtnPanel_ = false;

    public CustomTypePanel(CustomType type, boolean showBtnPanel) {
        this.set(type, type.getSchema(), showBtnPanel);
    }

    public CustomTypePanel(Schema schema) {
        this.set(null, schema, false);
    }

    private void set(CustomType type, Schema schema, boolean showBtnPanel) {
        this.schema_ = schema;
        this.type_ = type;
        this.showBtnPanel_ = showBtnPanel;
        this.init();
    }

    private void init() {
        this.schema_.addObserver(this);
        this.setupGui();
        this.loadData();
        this.buildListeners();
    }

    @Override
    public void setSyncOnEdit(boolean sync) {
        this.syncOnEdit_ = sync;
        if (this.syncOnEdit_) {
            this.txtNotes_.setInputVerifier(this.verifier_);
            this.btnUpdate_.setVisible(true);
        } else {
            this.txtNotes_.setInputVerifier(null);
            this.btnUpdate_.setVisible(false);
        }
    }

    private void buildListeners() {
        this.verifier_ = new DataEditorVerifier(this);
        this.lisUpdate_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomTypePanel.this.syncData();
                CustomTypePanel.this.txtName_.requestFocus();
            }
        };
        this.addListeners();
    }

    private void addListeners() {
        this.btnUpdate_.addActionListener(this.lisUpdate_);
    }

    private void setupGui() {
        this.layoutComponents();
        this.setCosmetics();
        this.addListeners();
    }

    private void setCosmetics() {
        this.txtNotes_.setRows(5);
        this.txtNotes_.setFont(this.lblNotes_.getFont());
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout(0, 4));
        this.add((Component)this.getTextPanel(), "North");
        if (this.showBtnPanel_) {
            this.add((Component)this.getButtonPanel(), "South");
        }
    }

    private JPanel getTextPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        panel.setLayout(gbl);
        int row = 0;
        GuiHelper.addGridbagPair(this.lblName_, this.txtName_, gbc, panel, row++);
        GuiHelper.buildGridBagConstraints(gbc, 0, row, 1, 1, 10.0, 0.0);
        gbc.fill = 0;
        gbc.anchor = 18;
        panel.add((Component)this.lblNotes_, gbc);
        GuiHelper.buildGridBagConstraints(gbc, 1, row++, 1, 1, 90.0, 0.0);
        gbc.fill = 1;
        gbc.anchor = 18;
        panel.add((Component)new JScrollPane(this.txtNotes_), gbc);
        return panel;
    }

    private JPanel getButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createGlue());
        panel.add(this.btnUpdate_);
        return panel;
    }

    @Override
    public ITestResult validateData() {
        ITestResult result = this.syncData();
        if (!result.getPassed()) {
            this.loadData();
        }
        return result;
    }

    private void loadData() {
        if (this.type_ != null) {
            this.txtName_.setText(this.type_.getName());
            this.txtNotes_.setText(this.type_.getNotes());
        } else {
            this.txtName_.setText("");
            this.txtNotes_.setText("");
        }
    }

    private ITestResult syncData() {
        DataEntryResult result = new DataEntryResult(true);
        String newNm = this.txtName_.getText();
        String newText = this.txtNotes_.getText();
        Database db = this.schema_.getDb();
        CustomType newType = CustomTypeIdCtrl.instance().createCustomType(db, newNm, newText);
        if (this.syncOnEdit_) {
            if (this.type_ != null) {
                this.startedUpdate_ = true;
                if (!newType.equals(this.type_)) {
                    CustomType oldType = this.type_;
                    this.type_ = newType;
                    UpdateInCollector.doUpdate(this.schema_, oldType, this.type_, CommandChainMgr.getCmdChain(), null);
                }
            }
        } else {
            this.type_ = newType;
        }
        this.startedUpdate_ = false;
        return result;
    }

    public CustomType getCustomType() {
        this.validateData();
        return this.type_;
    }

    @Override
    public Identifiable getDataObject() {
        return this.getCustomType();
    }

    @Override
    public Collector getCollector() {
        return this.schema_;
    }

    @Override
    public String getTitle() {
        return StrHelper.getAddOrEditText(this.type_) + "CustomType";
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(500, 50, 375, 275);
    }

    @Override
    public String getToolTip() {
        return this.getTitle();
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.CUSTOM_TYPE;
    }

    @Override
    public void update(UpdateChain chain) {
    }
}

