/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.naming;

import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.naming.INameProps;
import com.harrand.coreclasses.naming.NameProps;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.naming.SuffixPrefixPanel;
import com.harrand.coregui.text.PreviewPanel;
import com.harrand.dbwrench.naming.DbwNameBldrSvr;
import com.harrand.dbwrench.naming.FkNameBldr;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.testData.NamingTestData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public final class FkNamingPanel
extends JPanel
implements IObserver,
ISized {
    private DbwNameBldrSvr nameBldrSvr_ = DbwNameBldrSvr.instance();
    private FkNameBldr nameBldr_;
    private BasicObservable observable_ = new BasicObservable();
    private NamingTestData nd_ = new NamingTestData();
    private SuffixPrefixPanel suffixPrefixPanel_;
    private PreviewPanel previewPanel_ = new PreviewPanel();
    private JCheckBox chkChildItemsFirst_ = new JCheckBox("Child Items First");
    private JCheckBox chkUseChildTableName_ = new JCheckBox("Use Child Table Name");
    private JCheckBox chkUseParentTableName_ = new JCheckBox("Use Parent Table Name");
    private JCheckBox chkUseChildColumnNames_ = new JCheckBox("Use Child Column Names");
    private JCheckBox chkUseParentColumnNames_ = new JCheckBox("Use Parent Column Names");
    private SwingThemeCtrl themeCtrl_;

    public FkNamingPanel() {
        this.nameBldr_ = (FkNameBldr)this.nameBldrSvr_.getNameBldr("FkNameBldr");
        NameProps props = new NameProps(this.nameBldr_.getPrefix(), this.nameBldr_.getSeparator(), this.nameBldr_.getSuffix());
        this.suffixPrefixPanel_ = new SuffixPrefixPanel(props);
        this.suffixPrefixPanel_.addObserver(this);
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.setupGui();
        this.refreshPreview();
    }

    private void setupGui() {
        this.buildControls();
        this.layoutComponents();
        this.setCosmetics();
        this.setNames();
        this.loadData();
        this.addListeners();
    }

    private void buildControls() {
    }

    private void setCosmetics() {
    }

    private void loadData() {
        this.chkChildItemsFirst_.setSelected(this.nameBldr_.getChildItemsFirst());
        this.chkUseChildTableName_.setSelected(this.nameBldr_.getUseChildTableName());
        this.chkUseChildColumnNames_.setSelected(this.nameBldr_.getUseChildColumnNames());
        this.chkUseParentTableName_.setSelected(this.nameBldr_.getUseParentTableName());
        this.chkUseParentColumnNames_.setSelected(this.nameBldr_.getUseParentColumnNames());
    }

    private void layoutComponents() {
        this.setBorder(GuiHelper.getEmptyBorder());
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.getNorthPanel(), "North");
        this.add((Component)this.previewPanel_, "South");
    }

    private JPanel getNorthPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        panel.setLayout(gbl);
        int row = 0;
        GuiHelper.buildGridBagConstraints(gbc, 0, row, 1, 1, 10.0, 0.0);
        gbc.fill = 0;
        gbc.anchor = 18;
        panel.add((Component)this.suffixPrefixPanel_, gbc);
        GuiHelper.buildGridBagConstraints(gbc, 1, row, 1, 1, 10.0, 0.0);
        gbc.fill = 0;
        gbc.anchor = 18;
        panel.add((Component)this.getEastPanel(), gbc);
        GuiHelper.buildGridBagConstraints(gbc, 1, row, 1, 1, 90.0, 0.0);
        gbc.fill = 2;
        gbc.anchor = 17;
        panel.add((Component)new JPanel(), gbc);
        return panel;
    }

    private JPanel getEastPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        panel.add(this.chkChildItemsFirst_);
        panel.add(Box.createVerticalStrut(5));
        panel.add(this.chkUseChildTableName_);
        panel.add(Box.createVerticalStrut(5));
        panel.add(this.chkUseParentTableName_);
        panel.add(Box.createVerticalStrut(5));
        panel.add(this.chkUseChildColumnNames_);
        panel.add(Box.createVerticalStrut(5));
        panel.add(this.chkUseParentColumnNames_);
        panel.add(Box.createHorizontalGlue());
        panel.setBorder(new EmptyBorder(0, 0, 0, 30));
        return panel;
    }

    private void setNames() {
        this.setName("FkNamingPanel");
        this.chkChildItemsFirst_.setName("chkChildItemsFirst");
        this.chkUseChildTableName_.setName("chkUseChildTableName");
        this.chkUseParentTableName_.setName("chkUseParentTableName");
        this.chkUseChildColumnNames_.setName("chkUseChildColumnNames");
        this.chkUseParentColumnNames_.setName("chkUseParentColumnNames");
    }

    private void addListeners() {
        this.addActionListeners();
    }

    private void addActionListeners() {
        ActionListener lisHit = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FkNamingPanel.this.syncData();
            }
        };
        this.chkChildItemsFirst_.addActionListener(lisHit);
        this.chkUseChildTableName_.addActionListener(lisHit);
        this.chkUseParentTableName_.addActionListener(lisHit);
        this.chkUseChildColumnNames_.addActionListener(lisHit);
        this.chkUseParentColumnNames_.addActionListener(lisHit);
    }

    private void refreshPreview() {
        FkNamingPanel fkNamingPanel = this;
        Database testDb = fkNamingPanel.nd_.getTestDb();
        Table tblChd = testDb.getSchema("schemaA").getTable("ChildTable");
        ForeignKey testFk = tblChd.getForeignKey("TestFk");
        String formedName = this.nameBldr_.getFormedName(testFk);
        this.previewPanel_.setPreviewText(formedName);
    }

    public FkNameBldr getNameBldr() {
        this.syncData();
        return this.nameBldr_;
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(500, 50, 390, 250);
    }

    private void syncData() {
        INameProps props = this.suffixPrefixPanel_.getNameProps();
        FkNameBldr newBldr = new FkNameBldr(props.getPrefix(), props.getSeparator(), props.getSuffix());
        newBldr.setChildItemsFirst(this.chkChildItemsFirst_.isSelected());
        newBldr.setUseChildTableName(this.chkUseChildTableName_.isSelected());
        newBldr.setUseParentTableName(this.chkUseParentTableName_.isSelected());
        newBldr.setUseChildColumnNames(this.chkUseChildColumnNames_.isSelected());
        newBldr.setUseParentColumnNames(this.chkUseParentColumnNames_.isSelected());
        this.nameBldr_ = newBldr;
        this.refreshPreview();
        this.nameBldrSvr_.addNameBldr(this.nameBldr_);
    }

    @Override
    public void update(UpdateChain chain) {
        this.syncData();
    }
}

