/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.diagram.svg.util;

import com.harrand.coreclasses.help.DateHelper;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrenchgui.diagram.svg.elmBldr.SvgFrameBldr;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.xml.svg.bldr.basic.SvgTextBldr;
import com.harrand.sketch.xml.svg.common.SvgSizeCalculator;
import com.harrand.util.XmlHelper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SvgAnnotationBldr {
    private Document doc;
    private Database db;
    private SvgTextBldr textBldr;
    private Diagram diagram;
    private SvgSizeCalculator szCalculator;
    private Point diagramNmPt;
    private Point timeStampPt;
    private Point designNmPt;
    private Point diagramLblPt;
    private Point timeStampLblPt;
    private Point designLblPt;
    private Element gElm;
    private final SvgFrameBldr frameBldr;
    private Dimension paddedDiagramSize;
    public static final int LBL_LEFT_MARGIN = 10;
    public static final int NM_LEFT_MARGIN = 25;
    public static final int LBL_Y_MARGIN = 12;
    public static final int NM_Y_MARGIN = 24;
    public static final int TIMESTAMP_X = 200;
    public static final int DB_NM_X = 400;
    public static final int ANNOTATION_HEIGHT = 26;

    public SvgAnnotationBldr(Document doc) {
        this.doc = doc;
        this.textBldr = new SvgTextBldr(doc);
        this.frameBldr = new SvgFrameBldr(doc);
        this.szCalculator = new SvgSizeCalculator();
        this.db = LookupUtil.getLookupDb();
    }

    public Element buildElm(Diagram diagram) {
        this.diagram = diagram;
        this.calcDimensions();
        this.calcTextLocations();
        this.gElm = XmlHelper.createElementSimple(this.doc, "g", "");
        this.gElm.setAttribute("class", "annotation");
        this.gElm.appendChild(this.getFrameElm());
        this.addLabelElms();
        this.addValueElms();
        return this.gElm;
    }

    private void calcDimensions() {
        this.paddedDiagramSize = this.szCalculator.getPaddedDiagramSz(this.diagram.getBounds2D());
    }

    private void addLabelElms() {
        this.textBldr.setColor(Color.GRAY);
        this.addTextElm("Diagram:", this.diagramLblPt);
        this.addTextElm("Created:", this.timeStampLblPt);
        this.addTextElm("DbWrench Design:", this.designLblPt);
    }

    private void addValueElms() {
        this.textBldr.setColor(Color.DARK_GRAY);
        this.addTextElm(this.diagram.getName(), this.diagramNmPt);
        this.addTextElm(DateHelper.getTimeStamp(), this.timeStampPt);
        this.addTextElm(this.db.getName(), this.designNmPt);
    }

    private void addTextElm(String text, Point pt) {
        this.gElm.appendChild(this.textBldr.buildElm(text, pt, false));
    }

    private void calcTextLocations() {
        Rectangle2D diagramBounds = this.diagram.getBounds2D();
        int lblY = this.paddedDiagramSize.height + 12;
        int nmY = this.paddedDiagramSize.height + 24;
        this.diagramNmPt = new Point(25, nmY);
        this.timeStampPt = new Point(225, nmY);
        this.designNmPt = new Point(425, nmY);
        this.diagramLblPt = new Point(10, lblY);
        this.timeStampLblPt = new Point(210, lblY);
        this.designLblPt = new Point(410, lblY);
    }

    private Element getFrameElm() {
        return this.frameBldr.buildElm(this.paddedDiagramSize);
    }
}

