/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.diagram.svg;

import com.harrand.dbwrench.diagram.DbDrawableOrderer;
import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.diagram.ForeignKeyGlyph;
import com.harrand.dbwrench.diagram.fk.FkGlyphExtractor;
import com.harrand.dbwrench.diagram.table.DbTableGlyphExtractor;
import com.harrand.dbwrenchgui.diagram.svg.elmBldr.SvgDbIconBldr;
import com.harrand.dbwrenchgui.diagram.svg.elmBldr.SvgFrameBldr;
import com.harrand.dbwrenchgui.diagram.svg.util.SvgAnnotationBldr;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.j2d.draw.IDrawable;
import com.harrand.sketch.object.DiagramCollector;
import com.harrand.sketch.xml.svg.common.ISvgGradientable;
import com.harrand.sketch.xml.svg.common.ISvgShape;
import com.harrand.util.XmlHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DiagramSvgBldr {
    private Document doc;
    private Diagram diagram;
    private DbDrawableOrderer orderer = new DbDrawableOrderer();

    public DiagramSvgBldr(Document doc, Diagram diagram) {
        this.doc = doc;
        this.diagram = diagram;
        this.orderer.setDiagram(this.diagram);
    }

    public Element getDefsElm() {
        Element elmDefs = XmlHelper.createElementSimple(this.doc, "defs", "");
        TreeMap<String, Element> gradientElmsMap = new TreeMap<String, Element>();
        for (Glyph glyph : this.getDiagramGlyphs()) {
            List<? extends IDrawable> shapes = glyph.getDrawables();
            for (IDrawable iDrawable : shapes) {
                ISvgGradientable gradientable;
                Element gradientElm;
                if (!(iDrawable instanceof ISvgGradientable) || (gradientElm = (gradientable = (ISvgGradientable)((Object)iDrawable)).getGradientElm(this.doc)) == null) continue;
                String gradientIdStr = gradientable.getGradientIdStr();
                gradientElmsMap.put(gradientIdStr, gradientElm);
            }
        }
        for (Element gradientElm : gradientElmsMap.values()) {
            elmDefs.appendChild(gradientElm);
        }
        elmDefs.appendChild(this.getAnnotationGradient());
        this.addIconElms(elmDefs);
        return elmDefs;
    }

    public List<Element> getDiagramElms() {
        return this.getDiagramElmsB();
    }

    public List<Element> getDiagramElmsB() {
        ArrayList<Element> elms = new ArrayList<Element>();
        DiagramCollector diagramColl = this.diagram.getCollector();
        this.queryGlyphsDisp(diagramColl.getZoneGlyphs(), elms);
        this.checkAddSvgShapes(this.orderer.getShadowSvgShapes(), elms);
        this.queryGlyphsDisp(this.getFkGlyphs(), elms);
        this.queryGlyphsDisp(diagramColl.getNoteGlyphs(), elms);
        this.queryGlyphsDisp(this.getTableGlyphs(), elms);
        elms.add(this.getAnnotationElm());
        return elms;
    }

    private List<DbTableGlyph> getTableGlyphs() {
        List<DbTableGlyph> glyphs = new DbTableGlyphExtractor().getDbTableGlyphs(this.diagram);
        for (DbTableGlyph glyph : glyphs) {
            glyph.update(null);
        }
        return glyphs;
    }

    private List<ForeignKeyGlyph> getFkGlyphs() {
        return new FkGlyphExtractor().getFkGlyphs(this.diagram);
    }

    private void queryGlyphsDisp(List<? extends Glyph> glyphs, List<Element> elms) {
        for (Glyph glyph : glyphs) {
            this.queryGlyphs(glyph, elms);
        }
    }

    private void queryGlyphs(Glyph glyph, List<Element> elms) {
        List<? extends IDrawable> shapes = glyph.getDrawables();
        for (IDrawable iDrawable : shapes) {
            if (iDrawable instanceof ISvgShape) {
                this.checkAddSvgShape((ISvgShape)((Object)iDrawable), elms);
            }
            if (!(iDrawable instanceof Glyph) || glyph.hashCode() == iDrawable.hashCode()) continue;
            this.queryGlyphs((Glyph)((Object)iDrawable), elms);
        }
    }

    private void checkAddSvgShape(ISvgShape svgShape, List<Element> elms) {
        Element elm;
        if (svgShape != null && (elm = svgShape.getSvgElm(this.doc)) != null) {
            elms.add(elm);
        }
    }

    private void checkAddSvgShapes(List<ISvgShape> svgShapes, List<Element> elms) {
        for (ISvgShape svgShape : svgShapes) {
            this.checkAddSvgShape(svgShape, elms);
        }
    }

    private List<Glyph> getDiagramGlyphs() {
        DiagramCollector diagramColl = this.diagram.getCollector();
        ArrayList<Glyph> glyphs = new ArrayList<Glyph>();
        glyphs.addAll(diagramColl.getZoneGlyphs());
        glyphs.addAll(this.getFkGlyphs());
        glyphs.addAll(diagramColl.getNoteGlyphs());
        glyphs.addAll(this.getTableGlyphs());
        return glyphs;
    }

    private Element getAnnotationElm() {
        SvgAnnotationBldr bldr = new SvgAnnotationBldr(this.doc);
        return bldr.buildElm(this.diagram);
    }

    private void addIconElms(Element elmParent) {
        SvgDbIconBldr iconBldr = new SvgDbIconBldr(this.doc, this.diagram);
        elmParent.appendChild(iconBldr.buildElm());
    }

    private Element getAnnotationGradient() {
        return SvgFrameBldr.getGradientElm(this.doc);
    }
}

