/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.diagram.props;

import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.dbwrench.diagram.KeyToKeyStrategy;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.sketch.linkStrategies.LinkStrategy;
import com.harrand.sketch.linkStrategies.OffsetDirect;
import com.harrand.sketch.linkStrategies.right_angle.RightAngleStrategy;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class LinkStrategyPanel
extends JPanel {
    private JComboBox cboStrategy;
    private JTextArea txtStrategyDesc = new JTextArea();
    private final Database db;
    private LinkStrategy strategy;

    public LinkStrategyPanel(Database db, LinkStrategy strategy) {
        this.db = db;
        this.strategy = strategy;
        this.setupGui();
    }

    public void setSelectedLinkStrategy(LinkStrategy linkStrategy) {
        this.strategy = linkStrategy;
        this.loadData();
    }

    private void setupGui() {
        this.buildComponents();
        this.loadData();
        this.layoutComponents();
        this.setCosmetics();
        this.addListeners();
    }

    private void loadOptMgrSettings() {
        DbUser user = App.getUser();
        IOptionMgr optMgr = user.getOptionMgr("diagram.option.mgr");
        int strategyId = optMgr.getIntValue("diagram.default.strategy");
        String strategyStr = "Table Direct";
        if (strategyId == 2) {
            strategyStr = "Primary Key to Foreign Key Column";
        }
        if (strategyId == 3) {
            strategyStr = "Right Angle Connecting Lines";
        }
        if (strategyId == 0) {
            strategyStr = "Single Line";
        }
        this.cboStrategy.setSelectedItem(strategyStr);
    }

    private void buildComponents() {
        Object[] objs = new Object[]{"Right Angle Connecting Lines", "Table Direct", "Primary Key to Foreign Key Column"};
        this.cboStrategy = new JComboBox<Object>(objs);
    }

    private void loadData() {
        if (this.strategy != null) {
            String strategyDisplay = "Table Direct";
            String strategyName = this.strategy.getName();
            if (strategyName.equals("RightAngleStrategy")) {
                strategyDisplay = "Right Angle Connecting Lines";
            }
            if (strategyName.equals("KeyToKeyStrategy")) {
                strategyDisplay = "Primary Key to Foreign Key Column";
            }
            this.cboStrategy.setSelectedItem(strategyDisplay);
        } else {
            this.loadOptMgrSettings();
        }
        this.updateStrategyDesc();
    }

    private void layoutComponents() {
        this.setLayout(new BoxLayout(this, 3));
        this.add(GuiHelper.getLeftAlignedPanel(this.cboStrategy));
        this.add(Box.createVerticalStrut(4));
        this.add(this.txtStrategyDesc);
    }

    private void addListeners() {
        this.cboStrategy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinkStrategyPanel.this.updateStrategyDesc();
            }
        });
    }

    private void setCosmetics() {
        this.cboStrategy.setPrototypeDisplayValue("Primary Key to Foreign Key Column");
        this.txtStrategyDesc.setBackground(this.getBackground());
        this.txtStrategyDesc.setRows(3);
        this.txtStrategyDesc.setLineWrap(true);
        this.txtStrategyDesc.setWrapStyleWord(true);
        GuiHelper.setTitledBorderBuffered(this, "Link Strategy");
    }

    public LinkStrategy getStrategy() {
        String strategyDisplay = (String)this.cboStrategy.getSelectedItem();
        LinkStrategy strategySelected = null;
        strategySelected = strategyDisplay.equals("Primary Key to Foreign Key Column") ? new KeyToKeyStrategy(this.db) : (strategyDisplay.equals("Right Angle Connecting Lines") ? new RightAngleStrategy() : new OffsetDirect());
        return strategySelected;
    }

    private void updateStrategyDesc() {
        String desc = "";
        String display = (String)this.cboStrategy.getSelectedItem();
        desc = display.equals("Primary Key to Foreign Key Column") ? "Uses right angle lines to connect from the primary key of one table to the foreign key of the other." : "Uses a single straight or angled line to connect directly from one table to another table.";
        this.txtStrategyDesc.setText(desc);
    }
}

