/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.diagram.layout;

import com.harrand.coreclasses.zoom.Zoomer;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.CommandChainMgr;
import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.diagram.autoLayout.DbLayoutCtrl;
import com.harrand.dbwrench.diagram.table.DbTableGlyphLinkBoxesBldr;
import com.harrand.dbwrench.diagram.table.ITableGlyph;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.diagram.DbwDiagramPanelMouseHelper;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.layout.ILayoutCtrl;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.LinkAutoPositionInitializer;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.box.LinkBoxPair;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class LayoutGlyphsDisp {
    private DbwDiagramPanelMouseHelper diagramPanelMouseHelper = new DbwDiagramPanelMouseHelper();

    public void layoutGlyphs(Diagram diagram, List<? extends Glyph> glyphs, Point origin) {
        Map map = this.getLayoutCtrl().getTablePositions(diagram, glyphs, origin);
        for (Glyph glyph : glyphs) {
            if (!(glyph instanceof ITableGlyph)) continue;
            Table table = ((ITableGlyph)((Object)glyph)).getTable();
            Point newPoint = (Point)map.get(table);
            glyph.move(newPoint);
            diagram.addGlyph(glyph);
        }
        if (diagram.getRenderConfig().isRightAngleLinkStrategy()) {
            this.layoutRightAngleLinks(diagram, glyphs);
        }
    }

    public void layoutRightAngleLinks(Diagram diagram, List<? extends Glyph> glyphs) {
        if (diagram.getRenderConfig().isRightAngleLinkStrategy()) {
            ArrayList<DbTableGlyph> dbTableGlyphs = new ArrayList<DbTableGlyph>();
            for (Glyph glyph : glyphs) {
                if (!(glyph instanceof DbTableGlyph)) continue;
                dbTableGlyphs.add((DbTableGlyph)glyph);
            }
            List<LinkBoxPair> linkBoxPairs = new DbTableGlyphLinkBoxesBldr().getLinkBoxes(diagram, dbTableGlyphs);
            new LinkAutoPositionInitializer().initializeLinkPositions(linkBoxPairs);
        }
    }

    public void layoutGlyphsGrid(Diagram diagram, List<Glyph> glyphs, Point p) {
        ILayoutCtrl layoutCtrl = this.getLayoutCtrl();
        List<Glyph> previousGlyphs = diagram.getOnlyGlyphs();
        this.diagramPanelMouseHelper.setDiagram(diagram);
        Command cmd = this.diagramPanelMouseHelper.getAddGlyphsCmd(glyphs, p);
        if (cmd != null) {
            cmd.setCommandChain(CommandChainMgr.getInstance().getCommandChain());
            cmd.actionPerformed(null);
            List<Glyph> newGlyphs = diagram.getOnlyGlyphs();
            newGlyphs.removeAll(previousGlyphs);
            if (newGlyphs.size() > 1) {
                this.autoLayoutGlyphsGrid(diagram, layoutCtrl, newGlyphs, p);
            }
            diagram.refresh();
            diagram.notifyObservers(null);
        }
    }

    private void autoLayoutGlyphsGrid(Diagram diagram, ILayoutCtrl layoutCtrl, List glyphs, Point p) {
        double zoomLevel = diagram.getZoom().getLevel();
        Point unzoomed = Zoomer.zoom(p, 1.0 / zoomLevel);
        Map map = layoutCtrl.getTablePositions(diagram, glyphs, p);
        int STEPS = glyphs.size() > 1 ? 1 : 1;
        for (int i = 1; i <= STEPS; ++i) {
            for (Glyph glyph : glyphs) {
                Point newPoint = (Point)map.get(glyph.getName());
                double factor = (double)i / (double)STEPS;
                double xIncr = factor * (newPoint.getX() - unzoomed.getX());
                double yIncr = factor * (newPoint.getY() - unzoomed.getY());
                Point partial = new Point((int)(unzoomed.getX() + xIncr), (int)(unzoomed.getY() + yIncr));
                glyph.move(partial);
            }
        }
    }

    private ILayoutCtrl getLayoutCtrl() {
        Database db = LookupUtil.findDb();
        return new DbLayoutCtrl(db);
    }
}

