/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.diagram.clickAction.bldr;

import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.coregui.mouse.tracker.ClickActionMouseTracker;
import com.harrand.coregui.mouse.tracker.IMouseTracker;
import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.command.clickAction.column.AddColumnClickAction;
import com.harrand.dbwrenchgui.command.clickAction.column.DeleteColumnClickAction;
import com.harrand.dbwrenchgui.command.clickAction.column.SetFkClickAction;
import com.harrand.dbwrenchgui.command.clickAction.column.SetIndexClickAction;
import com.harrand.dbwrenchgui.command.clickAction.column.SetNullClickAction;
import com.harrand.dbwrenchgui.command.clickAction.column.SetPkClickAction;
import com.harrand.dbwrenchgui.command.clickAction.table.DeleteTableClickAction;
import com.harrand.dbwrenchgui.command.clickAction.table.SetTableDetailsClickAction;
import com.harrand.dbwrenchgui.command.clickAction.table.SetTablePropsClickAction;
import com.harrand.dbwrenchgui.command.clickAction.table.ShowDataClickAction;
import com.harrand.dbwrenchgui.diagram.clickAction.bldr.DbTableGlyphClickActionBldr;
import com.harrand.sketch.command.clickAction.action.ClickActionSizeCalc;
import com.harrand.sketch.command.clickAction.action.IClickAction;
import com.harrand.sketch.command.clickAction.action.IClickActionProvider;
import com.harrand.sketch.command.clickAction.ctrl.DiagramClickActionEnabler;
import com.harrand.sketch.command.clickAction.ctrl.IClickActionCtrl;
import com.harrand.sketch.command.clickAction.mouse.ClickActionMouseCalc;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.RenderConfig;
import com.harrand.sketch.j2d.draw.IDrawable;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class DbTableGlyphClickActionCtrl
implements IMouseTracker,
IClickActionCtrl,
IObserver {
    private DbTableGlyph tableGlyph;
    private Map<String, IClickAction> clickActionsMap = new HashMap<String, IClickAction>();
    private DbTableGlyphClickActionBldr clickActionBldr;
    private DiagramClickActionEnabler clickActionEnabler = new DiagramClickActionEnabler();
    private ClickActionMouseTracker mouseTracker;
    private ClickActionSizeCalc sizeCalc;
    private ClickActionMouseCalc mouseCalc;
    private Table table;
    private boolean isActive;
    private double lastZmLevel = 1.0;
    private double lastFontSz = 9.0;

    public DbTableGlyphClickActionCtrl(DbTableGlyph tableGlyph) {
        this.tableGlyph = tableGlyph;
        this.mouseTracker = new ClickActionMouseTracker(this);
        this.refresh();
    }

    @Override
    public Collection<IDrawable> getDrawables() {
        ArrayList<IDrawable> drawables = new ArrayList<IDrawable>();
        for (IClickAction clickAction : this.getClickActions()) {
            drawables.addAll(clickAction.getDrawables());
        }
        return drawables;
    }

    public boolean getIsEnabled() {
        boolean isEnabled = this.clickActionEnabler.getAreClickActionsEnabled(this.getRenderConfig(), this.isActive);
        return isEnabled;
    }

    public IClickAction getNewClickAction(IClickActionProvider provider, Identifiable idf) {
        String keyNm = provider.getClickActionNm(idf);
        if (this.getHasClickAction(keyNm)) {
            return this.getClickAction(keyNm);
        }
        IClickAction clickAction = provider.getClickAction(this.sizeCalc, this.mouseCalc);
        this.putClickAction(keyNm, clickAction);
        return clickAction;
    }

    private void putClickAction(String keyNm, IClickAction clickAction) {
        this.clickActionsMap.put(keyNm, clickAction);
    }

    public IClickAction getSetPkClickAction(Column column) {
        String keyNm = SetPkClickAction.createName(column);
        if (this.getHasClickAction(keyNm)) {
            return this.getClickAction(keyNm);
        }
        IClickAction clickAction = this.clickActionBldr.buildSetPkClickAction(column);
        this.putClickAction(keyNm, clickAction);
        return clickAction;
    }

    public IClickAction getSetNullClickAction(Column column) {
        String keyNm = SetNullClickAction.createName(column);
        if (this.getHasClickAction(keyNm)) {
            return this.getClickAction(keyNm);
        }
        IClickAction clickAction = this.clickActionBldr.buildNullClickAction(column);
        this.putClickAction(keyNm, clickAction);
        return clickAction;
    }

    public IClickAction getSetFkClickAction(Column column) {
        String keyNm = SetFkClickAction.createName(column);
        if (this.getHasClickAction(keyNm)) {
            return this.getClickAction(keyNm);
        }
        Diagram diagram = this.tableGlyph.getDiagram();
        IClickAction clickAction = this.clickActionBldr.buildSetFkClickAction(diagram, column);
        this.putClickAction(keyNm, clickAction);
        return clickAction;
    }

    public IClickAction getSetIndexClickAction(Column column) {
        String keyNm = SetIndexClickAction.createName(column);
        if (this.getHasClickAction(keyNm)) {
            return this.getClickAction(keyNm);
        }
        IClickAction clickAction = this.clickActionBldr.buildSetIndexClickAction(column);
        this.putClickAction(keyNm, clickAction);
        return clickAction;
    }

    public IClickAction getDeleteColumnClickAction(Column column) {
        String keyNm = DeleteColumnClickAction.createName(column);
        if (this.getHasClickAction(keyNm)) {
            return this.getClickAction(keyNm);
        }
        IClickAction clickAction = this.clickActionBldr.buildDeleteColumnClickAction(column);
        this.putClickAction(keyNm, clickAction);
        return clickAction;
    }

    public IClickAction getAddColumnClickAction(int colInsertPos) {
        String keyNm = AddColumnClickAction.createName(colInsertPos);
        if (this.getHasClickAction(keyNm)) {
            return this.getClickAction(keyNm);
        }
        IClickAction clickAction = this.clickActionBldr.buildAddColumnClickAction(colInsertPos);
        this.putClickAction(keyNm, clickAction);
        return clickAction;
    }

    public IClickAction getShowDataClickAction() {
        String keyNm = ShowDataClickAction.createName(this.table);
        if (this.getHasClickAction(keyNm)) {
            return this.getClickAction(keyNm);
        }
        IClickAction clickAction = this.clickActionBldr.buildShowDataClickAction();
        this.putClickAction(keyNm, clickAction);
        return clickAction;
    }

    public IClickAction getTableDetailsClickAction() {
        String keyNm = SetTableDetailsClickAction.createName(this.table);
        if (this.getHasClickAction(keyNm)) {
            return this.getClickAction(keyNm);
        }
        IClickAction clickAction = this.clickActionBldr.buildSetTableDetailsClickAction();
        this.putClickAction(keyNm, clickAction);
        return clickAction;
    }

    public IClickAction getTablePropsClickAction() {
        String keyNm = SetTablePropsClickAction.createName(this.table);
        if (this.getHasClickAction(keyNm)) {
            return this.getClickAction(keyNm);
        }
        IClickAction clickAction = this.clickActionBldr.buildSetTablePropsClickAction();
        this.putClickAction(keyNm, clickAction);
        return clickAction;
    }

    public IClickAction getDeleteTableClickAction() {
        String keyNm = DeleteTableClickAction.createName(this.table);
        if (this.getHasClickAction(keyNm)) {
            return this.getClickAction(keyNm);
        }
        IClickAction clickAction = this.clickActionBldr.buildDeleteTableClickAction();
        this.putClickAction(keyNm, clickAction);
        return clickAction;
    }

    @Override
    public void update(UpdateChain chain) {
        this.refresh();
        this.checkClearClickActions();
    }

    public IClickAction getClickAction(String keyNm) {
        return this.clickActionsMap.get(keyNm);
    }

    @Override
    public void checkClearClickActions() {
        if (!this.clickActionsMap.isEmpty()) {
            this.clear();
            this.tableGlyph.refresh();
        }
    }

    @Override
    public void refresh() {
        this.clear();
        this.table = this.tableGlyph.getTable();
        this.initSizeCalc();
        this.initMouseCalc();
        this.clickActionBldr = new DbTableGlyphClickActionBldr(this.sizeCalc, this.mouseCalc, this.table);
        this.updateLastSettings();
    }

    private void clear() {
        this.clickActionsMap = new HashMap<String, IClickAction>();
    }

    private void initSizeCalc() {
        this.sizeCalc = new ClickActionSizeCalc(this.getRenderConfig().getFont());
    }

    public RenderConfig getRenderConfig() {
        return this.tableGlyph.getRenderConfig();
    }

    private Zoom getZoom() {
        return this.getRenderConfig().getZoom();
    }

    private void initMouseCalc() {
        Point start = this.tableGlyph.getStart();
        Point2D.Double glyphOrigin = new Point2D.Double(start.getX(), start.getY());
        this.mouseCalc = new ClickActionMouseCalc(glyphOrigin, this.getRenderConfig().getZoom());
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseTracker.mouseMoved(e);
    }

    @Override
    public boolean mouseDown(MouseEvent e) {
        boolean processed = this.mouseTracker.mouseDown(e);
        return processed;
    }

    @Override
    public void mouseUp(MouseEvent e) {
        this.mouseTracker.mouseUp(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseTracker.mouseExited(e);
    }

    @Override
    public Collection<IClickAction> getClickActions() {
        return this.clickActionsMap.values();
    }

    @Override
    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }

    public ClickActionSizeCalc getSizeCalc() {
        return this.sizeCalc;
    }

    public ClickActionMouseCalc getMouseCalc() {
        return this.mouseCalc;
    }

    public boolean getHasClickAction(String clickActionNm) {
        return this.clickActionsMap.containsKey(clickActionNm);
    }

    public void checkRebuildRequired() {
        double currentZoomLevel = this.getZoomLevel();
        if (this.lastZmLevel != currentZoomLevel) {
            this.refresh();
            return;
        }
        int currentFontSz = this.getFontSize();
        if (this.lastFontSz != (double)currentFontSz) {
            this.refresh();
        }
        if (this.clickActionsMap.isEmpty()) {
            this.refresh();
        }
    }

    private void updateLastSettings() {
        this.lastZmLevel = this.getZoomLevel();
        this.lastFontSz = this.getFontSize();
    }

    private int getFontSize() {
        return this.getRenderConfig().getFont().getSize();
    }

    private double getZoomLevel() {
        return this.getRenderConfig().getZoomLevel();
    }
}

