/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.diagram;

import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.sketch.xml.DiagramProps;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class DisplayColumnsPanel
extends JPanel {
    private DiagramProps diagramProps_;
    private ButtonGroup columnGrp_ = new ButtonGroup();
    private JRadioButton radAllColumns_ = new JRadioButton("Display All Columns");
    private JRadioButton radOnlyColumns_ = new JRadioButton("Display Only the Following:");
    private JCheckBox chkPkCols_ = new JCheckBox("Primary Key Columns");
    private JCheckBox chkFkCols_ = new JCheckBox("Foreign Key Columns");
    private ActionListener radioLis_;
    private ActionListener checkLis_;

    public DisplayColumnsPanel(DiagramProps diagramProps) {
        this.diagramProps_ = diagramProps;
        this.setupGui();
    }

    public DiagramProps getDiagramProps() {
        DiagramProps diagramProps = new DiagramProps();
        diagramProps.setShowAllColumns(this.radAllColumns_.isSelected());
        diagramProps.setShowPkColumns(this.chkPkCols_.isSelected());
        diagramProps.setShowFkColumns(this.chkFkCols_.isSelected());
        return diagramProps;
    }

    public void loadOptMgrSettings() {
        DbUser user = App.getUser();
        IOptionMgr optMgr = user.getOptionMgr("diagram.option.mgr");
        this.radAllColumns_.setSelected(optMgr.getBoolValue("diagram.show.all.cols"));
        this.radOnlyColumns_.setSelected(!optMgr.getBoolValue("diagram.show.all.cols"));
        this.chkPkCols_.setSelected(optMgr.getBoolValue("diagram.show.pk.cols"));
        this.chkFkCols_.setSelected(optMgr.getBoolValue("diagram.show.fk.cols"));
        this.checkEnabled();
    }

    private void buildBtnGrp() {
        this.columnGrp_.add(this.radAllColumns_);
        this.columnGrp_.add(this.radOnlyColumns_);
    }

    private void loadData() {
        this.chkPkCols_.setSelected(this.diagramProps_.getShowPkColumns());
        this.chkFkCols_.setSelected(this.diagramProps_.getShowFkColumns());
        this.radAllColumns_.setSelected(this.diagramProps_.getShowAllColumns());
        this.radOnlyColumns_.setSelected(!this.diagramProps_.getShowAllColumns());
    }

    private void setCosmetics() {
        this.setBorder(BorderFactory.createTitledBorder("Display Columns"));
    }

    private void setMnemonics() {
        this.radAllColumns_.setMnemonic('a');
        this.radOnlyColumns_.setMnemonic('w');
        this.chkFkCols_.setMnemonic('f');
        this.chkPkCols_.setMnemonic('p');
    }

    private void setupGui() {
        this.buildBtnGrp();
        this.layoutComponents();
        this.setCosmetics();
        this.addListeners();
        this.loadData();
        this.checkEnabled();
        this.setMnemonics();
    }

    private void addListeners() {
        this.radioLis_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisplayColumnsPanel.this.checkEnabled();
            }
        };
        this.radAllColumns_.addActionListener(this.radioLis_);
        this.radOnlyColumns_.addActionListener(this.radioLis_);
    }

    private void checkEnabled() {
        boolean enableChkBoxes = this.radOnlyColumns_.isSelected();
        this.chkFkCols_.setEnabled(enableChkBoxes);
        this.chkPkCols_.setEnabled(enableChkBoxes);
    }

    private void layoutComponents() {
        this.setLayout(new BoxLayout(this, 3));
        this.add(GuiHelper.getLeftAlignedPanel(this.radAllColumns_));
        this.add(Box.createVerticalStrut(4));
        this.add(GuiHelper.getLeftAlignedPanel(this.radOnlyColumns_));
        this.add(Box.createVerticalStrut(4));
        this.add(this.getCheckBoxPanel());
        this.add(Box.createVerticalGlue());
    }

    private JPanel getCheckBoxPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.add(Box.createHorizontalStrut(25));
        panel.add(this.chkPkCols_);
        panel.add(Box.createHorizontalStrut(4));
        panel.add(this.chkFkCols_);
        panel.add(Box.createHorizontalGlue());
        return panel;
    }
}

