/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.diagram;

import com.harrand.coreclasses.display.ColorGrouping;
import com.harrand.coreclasses.display.IColorable;
import com.harrand.coreclasses.system.OsUtil;
import com.harrand.coreclasses.zoom.Zoomer;
import com.harrand.coregui.Icons;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.CommandChain;
import com.harrand.coregui.command.DbwCommandFactory;
import com.harrand.coregui.command.prompt.PromptCollectionAdd;
import com.harrand.coregui.command.prompt.PromptDataEditDlg;
import com.harrand.coregui.command.prompt.PromptSetColor;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.dbwrench.command.provider.Nb8ActionBuilderProvider;
import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.diagram.ForeignKeyGlyph;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.ColumnSortPanelCtrl;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.dbwrench.sql.show.EShowSqlType;
import com.harrand.dbwrench.sql.show.IShowTableSqlActionBuilder;
import com.harrand.dbwrenchgui.command.AddNewTableGlyph;
import com.harrand.dbwrenchgui.command.PromptQuickFk;
import com.harrand.dbwrenchgui.command.ViewTableDataCmd;
import com.harrand.dbwrenchgui.command.glyph.AddDiagramIdfCmd;
import com.harrand.dbwrenchgui.command.props.UpdateDiagramSettings;
import com.harrand.dbwrenchgui.command.query.mni.CreateQueryMniBldr;
import com.harrand.dbwrenchgui.command.table.PromptCloneTable;
import com.harrand.dbwrenchgui.command.table.PromptTableDetails;
import com.harrand.dbwrenchgui.command.table.ShowTableDataTC;
import com.harrand.dbwrenchgui.panel.ColumnEditPanel;
import com.harrand.dbwrenchgui.panel.ColumnSortPanel;
import com.harrand.dbwrenchgui.panel.ForeignKeyPanel;
import com.harrand.sketch.command.IDiagramCmdBldr;
import com.harrand.sketch.command.RemoveGlyphFromDiagram;
import com.harrand.sketch.command.RemoveGlyphs;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.glyph.NoteGlyph;
import com.harrand.sketch.glyph.ZoneGlyph;
import com.harrand.sketch.object.Note;
import com.harrand.sketch.object.Zone;
import com.harrand.sketch.support.clipboard.CopyGlyphs;
import com.harrand.sketch.support.clipboard.CutGlyphs;
import com.harrand.sketch.support.clipboard.PasteGlyphs;
import com.harrand.util.ResMgr;
import java.awt.Color;
import java.awt.Point;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

public final class DiagramCmdBldr
implements IDiagramCmdBldr {
    private Diagram diagram_;
    private CommandChain cmdChain_;
    private DbUser user_ = null;
    private long previousTime_;
    private ForeignKeyPanel fkPanel_;
    private Database db;

    public DiagramCmdBldr(Diagram diagram) {
        this.setDiagram(diagram);
        this.cmdChain_ = App.getCommandChain();
        this.user_ = App.getUser();
    }

    @Override
    public void setDiagram(Diagram diagram) {
        this.diagram_ = diagram;
    }

    private List getBasicGlyphCmds(Point pntUnZoomed) {
        ArrayList<JComponent> cmds = new ArrayList<JComponent>();
        List colorCmds = this.getColorCmds();
        cmds.addAll(colorCmds);
        cmds.add(this.getRemoveCmd());
        cmds.add(new JSeparator());
        cmds.addAll(this.getCutCopyPasteItems(pntUnZoomed));
        return cmds;
    }

    private List getFkCmds(Point pntUnZoomed) {
        ArrayList<Command> cmds = new ArrayList<Command>();
        ForeignKeyGlyph fkGlyph = this.diagram_.getSelectedForeignKeyGlyph();
        if (fkGlyph != null) {
            ForeignKey fk = fkGlyph.getFk();
            cmds.add(DbwCommandFactory.getEditFkCmd(this.getDb(), fk.getParTbl(), fk));
            cmds.add(DbwCommandFactory.getRemoveFkCmd(fk.getChdTbl(), fk, true));
        }
        cmds.addAll(this.getColorCmds());
        return cmds;
    }

    private List getDbTableGlyphCmds(Glyph clickedGlyph, Point pntUnZoomed) {
        ArrayList<Object> cmds = new ArrayList<Object>();
        Table table = this.getTableFromGlyph(clickedGlyph);
        cmds.add(this.getTableDetailsCmd(table));
        cmds.add(this.getTableDataCmd(table));
        cmds.add(this.getColumnSortCmd(this.db, clickedGlyph));
        cmds.add(this.getQuickFkCmd(this.db, clickedGlyph));
        cmds.add(this.getCloneTableCmd(clickedGlyph));
        cmds.add(this.getRemoveCmd());
        cmds.add(new JSeparator());
        cmds.add(this.getAddColumnCmd(this.db, clickedGlyph, this.cmdChain_));
        cmds.add(this.getAddFkCmd(clickedGlyph));
        cmds.addAll(this.getColorCmds());
        cmds.add(new JSeparator());
        cmds.addAll(this.getSQLCmds(table));
        cmds.add(new JSeparator());
        cmds.addAll(this.getCutCopyPasteItems(pntUnZoomed));
        return cmds;
    }

    private List getDiagramSpecificCmds(Point pt, Point pntUnZoomed) {
        ArrayList<Serializable> cmds = new ArrayList<Serializable>();
        cmds.add(this.getAddTableGlyphCmd(this.db, pt));
        cmds.add(this.getAddDiagramIdfCmd(pntUnZoomed, Note.getClassName(), 78, DiagramCmdBldr.getAltMask()));
        cmds.add(this.getAddDiagramIdfCmd(pntUnZoomed, Zone.getClassName(), 90, DiagramCmdBldr.getAltMask()));
        cmds.add(new JSeparator());
        cmds.addAll(this.getCutCopyPasteItems(pntUnZoomed));
        cmds.add(new JSeparator());
        UpdateDiagramSettings diaCmd = new UpdateDiagramSettings(this.diagram_);
        cmds.add(diaCmd);
        return cmds;
    }

    private Database getDb() {
        return LookupUtil.findDb();
    }

    private Table getTableFromGlyph(Glyph clickedGlyph) {
        DbTableGlyph childTableGlyph = (DbTableGlyph)clickedGlyph;
        Table chdTbl = childTableGlyph.getTable();
        return chdTbl;
    }

    private boolean isClickedGlyphDbTableGlyph(Glyph glyph) {
        return glyph != null && glyph instanceof DbTableGlyph;
    }

    private boolean isClickedGlyphFkGlyph(Glyph glyph) {
        return glyph != null && glyph instanceof ForeignKeyGlyph;
    }

    private void logElapse(String msg) {
        long current = System.currentTimeMillis();
        long elapsed = current - this.previousTime_;
        this.previousTime_ = current;
    }

    @Override
    public List getCommands(Point pt) {
        this.previousTime_ = System.currentTimeMillis();
        List cmds = new ArrayList();
        Glyph clickedGlyph = this.diagram_.getGlyphContainingPoint(pt);
        boolean isClickedGlyphDbTableGlyph = this.isClickedGlyphDbTableGlyph(clickedGlyph);
        boolean isFkGlyph = this.isClickedGlyphFkGlyph(clickedGlyph);
        boolean isOtherGlyph = clickedGlyph != null;
        double level = this.diagram_.getRenderConfig().getZoomLevel();
        Point pntUnZoomed = Zoomer.zoom(pt, 1.0 / level);
        this.db = this.getDb();
        cmds = isClickedGlyphDbTableGlyph ? this.getDbTableGlyphCmds(clickedGlyph, pntUnZoomed) : (isFkGlyph ? this.getFkCmds(pntUnZoomed) : (isOtherGlyph ? this.getBasicGlyphCmds(pntUnZoomed) : this.getDiagramSpecificCmds(pt, pntUnZoomed)));
        return cmds;
    }

    public List getColorCmds() {
        List colorables = this.diagram_.getSelectedGlyphs(true);
        ArrayList<JMenuItem> cmds = new ArrayList<JMenuItem>();
        List currentColors = this.getColorGroupings(this.getDb());
        CommandChain cmdChain = App.getCommandChain();
        PromptSetColor cmd = new PromptSetColor(colorables, "MainBox", currentColors, cmdChain);
        cmd.putValue("MnemonicKey", new Integer(66));
        cmd.setObserver(this.diagram_);
        JMenuItem mni = GuiHelper.getMenuItemFromCmd(cmd);
        cmds.add(mni);
        return cmds;
    }

    private JMenuItem getAddTableGlyphCmd(Database db, Point pt) {
        AddNewTableGlyph cmd = new AddNewTableGlyph(db, null, this.user_, this.diagram_, pt);
        cmd.putValue("SmallIcon", Icons.TABLE_ADD);
        JMenuItem mni = GuiHelper.getMenuItemFromCmd(cmd);
        mni.setAccelerator(KeyStroke.getKeyStroke(84, DiagramCmdBldr.getAltMask()));
        return mni;
    }

    public static int getAltMask() {
        return OsUtil.getAltMask();
    }

    private JMenuItem getAddDiagramIdfCmd(Point pt, String mapNm, int keyCode, int modifiers) {
        AddDiagramIdfCmd cmd = new AddDiagramIdfCmd(this.diagram_, mapNm);
        cmd.setOrigin(pt);
        JMenuItem mni = GuiHelper.getMenuItemFromCmd(cmd);
        mni.setAccelerator(KeyStroke.getKeyStroke(keyCode, modifiers));
        return mni;
    }

    public JMenuItem getAddColumnCmd(Database db, Glyph clickedGlyph, CommandChain cmdChain) {
        JMenuItem mni = new JMenuItem(ResMgr.getRes("add.label") + " " + App.getRes("column.label"));
        mni.setToolTipText(App.getRes("enabled.if.table.selected.msg"));
        mni.setEnabled(false);
        if (this.isClickedGlyphDbTableGlyph(clickedGlyph)) {
            Table table = ((DbTableGlyph)clickedGlyph).getTable();
            ColumnEditPanel colPanel_ = new ColumnEditPanel(null, table);
            PromptCollectionAdd cmd = new PromptCollectionAdd(table, Column.getClassName(), colPanel_);
            cmd.putValue("SmallIcon", Icons.COLUMN_ADD);
            cmd.putValue("MnemonicKey", new Integer(67));
            mni = GuiHelper.getMenuItemFromCmd(cmd);
        }
        mni.setAccelerator(KeyStroke.getKeyStroke(67, DiagramCmdBldr.getAltMask()));
        return mni;
    }

    public JMenuItem getAddFkCmd(Glyph clickedGlyph) {
        JMenuItem mni = new JMenuItem("Add Foreign Key");
        mni.setMnemonic(70);
        mni.setEnabled(false);
        if (this.isClickedGlyphDbTableGlyph(clickedGlyph)) {
            Table table = this.getTableFromGlyph(clickedGlyph);
            if (this.fkPanel_ == null) {
                this.fkPanel_ = new ForeignKeyPanel(null, this.getDb());
            } else {
                this.fkPanel_.setDatabase(this.getDb());
                this.fkPanel_.setForeground(null);
                this.fkPanel_.refresh();
            }
            this.fkPanel_.setChildTable(table);
            PromptCollectionAdd cmd = new PromptCollectionAdd(this.getDb(), ForeignKey.getClassName(), this.fkPanel_);
            cmd.setCommandChain(this.cmdChain_);
            cmd.putValue("SmallIcon", Icons.FK_ADD);
            mni = GuiHelper.getMenuItemFromCmd(cmd);
            mni.setMnemonic(70);
        } else {
            mni.setToolTipText(App.getRes("enabled.if.table.selected.msg"));
        }
        mni.setAccelerator(KeyStroke.getKeyStroke(75, DiagramCmdBldr.getAltMask()));
        return mni;
    }

    private JMenuItem getQuickFkCmd(Database db, Glyph clickedGlyph) {
        JMenuItem mni = new JMenuItem("Add Quick Foreign Key");
        mni.setEnabled(false);
        if (this.isClickedGlyphDbTableGlyph(clickedGlyph)) {
            Table chdTbl = this.getTableFromGlyph(clickedGlyph);
            PromptQuickFk cmd = new PromptQuickFk(this.user_, db, this.diagram_, chdTbl);
            mni = GuiHelper.getMenuItemFromCmd(cmd);
        }
        mni.setMnemonic(81);
        mni.setAccelerator(KeyStroke.getKeyStroke(81, DiagramCmdBldr.getAltMask()));
        return mni;
    }

    private JMenuItem getCloneTableCmd(Glyph clickedGlyph) {
        JMenuItem mni = new JMenuItem("Clone Table");
        mni.setEnabled(false);
        if (this.isClickedGlyphDbTableGlyph(clickedGlyph)) {
            Table table = this.getTableFromGlyph(clickedGlyph);
            PromptCloneTable cmd = new PromptCloneTable(table, this.diagram_);
            mni = GuiHelper.getMenuItemFromCmd(cmd);
        }
        mni.setMnemonic(76);
        return mni;
    }

    public JMenuItem getRemoveCmd() {
        List selectedGlyphs = this.diagram_.getSelectedGlyphs(false);
        JMenuItem mni = new JMenuItem("Remove Glyph");
        mni.setMnemonic(82);
        mni.setEnabled(false);
        mni.setToolTipText("No Glyphs Selected");
        Command cmd = null;
        int selectedSize = selectedGlyphs.size();
        if (selectedSize == 1) {
            Glyph glyph = (Glyph)selectedGlyphs.get(0);
            cmd = new RemoveGlyphFromDiagram(this.diagram_, glyph, Command.getStateDo());
            mni = GuiHelper.getMenuItemFromCmd(cmd);
        } else if (selectedSize > 1) {
            cmd = new RemoveGlyphs(this.diagram_, selectedGlyphs, Command.getStateDo());
            mni = GuiHelper.getMenuItemFromCmd(cmd);
        }
        if (cmd != null) {
            cmd.setCommandChain(App.getCommandChain());
            cmd.putValue("SmallIcon", Icons.REMOVE_GLYPH);
        }
        mni.setAccelerator(KeyStroke.getKeyStroke(127, 2));
        return mni;
    }

    public List<JMenuItem> getCutCopyPasteItems(Point pt) {
        ArrayList<JMenuItem> cmds = new ArrayList<JMenuItem>();
        cmds.add(GuiHelper.getMenuItemFromCmd(new CutGlyphs()));
        cmds.add(GuiHelper.getMenuItemFromCmd(new CopyGlyphs()));
        cmds.add(GuiHelper.getMenuItemFromCmd(new PasteGlyphs(pt)));
        return cmds;
    }

    public JMenuItem getViewDataCmd(Glyph clickedGlyph) {
        String text = ResMgr.getRes("table.data.view");
        JMenuItem mni = new JMenuItem(text);
        mni.setMnemonic(86);
        mni.setEnabled(false);
        if (this.isClickedGlyphDbTableGlyph(clickedGlyph)) {
            Table table = this.getTableFromGlyph(clickedGlyph);
            ViewTableDataCmd cmd = new ViewTableDataCmd(table);
            cmd.putValue("SmallIcon", Icons.TABLE_DATA_VIEWER);
            mni = GuiHelper.getMenuItemFromCmd(cmd);
        } else {
            mni.setToolTipText(App.getRes("enabled.if.table.selected.msg"));
        }
        mni.setAccelerator(KeyStroke.getKeyStroke(65, 576));
        return mni;
    }

    public JMenuItem getColumnSortCmd(Database db, Glyph clickedGlyph) {
        String text = App.getRes("sort.columns");
        JMenuItem mni = new JMenuItem(text);
        mni.setMnemonic(83);
        mni.setEnabled(false);
        if (this.isClickedGlyphDbTableGlyph(clickedGlyph)) {
            Table table = this.getTableFromGlyph(clickedGlyph);
            ColumnSortPanelCtrl ctrl = new ColumnSortPanelCtrl(db, table);
            ColumnSortPanel panel = new ColumnSortPanel(ctrl);
            PromptDataEditDlg cmd = new PromptDataEditDlg(panel);
            mni = GuiHelper.getMenuItemFromCmd(cmd);
            mni.setMnemonic(83);
            mni.setText(text);
        } else {
            mni.setToolTipText(App.getRes("enabled.if.table.selected.msg"));
        }
        return mni;
    }

    private List getColorGroupings(Database db) {
        HashSet<Color> linkColors = new HashSet<Color>();
        HashSet<Color> tableColors = new HashSet<Color>();
        HashSet noteColors = new HashSet();
        HashSet zoneColors = new HashSet();
        for (Diagram diagram : db.values(Diagram.getClassName())) {
            for (Object obj : diagram.getAllGlyphs()) {
                Color color;
                if (obj instanceof DbTableGlyph) {
                    DbTableGlyph tableGlyph = (DbTableGlyph)obj;
                    color = tableGlyph.getColor("MainBox");
                    tableColors.add(color);
                }
                if (obj instanceof ForeignKeyGlyph) {
                    ForeignKeyGlyph fkGlyph = (ForeignKeyGlyph)obj;
                    color = fkGlyph.getColor("MainBox");
                    linkColors.add(color);
                }
                if (obj instanceof NoteGlyph) {
                    this.addColorUsed(noteColors, obj);
                }
                if (!(obj instanceof ZoneGlyph)) continue;
                this.addColorUsed(zoneColors, obj);
            }
        }
        ArrayList<ColorGrouping> groupings = new ArrayList<ColorGrouping>();
        groupings.add(new ColorGrouping(new ArrayList(tableColors), "Table Colors", "The following colors have been used for table glyph colors: "));
        groupings.add(new ColorGrouping(new ArrayList(linkColors), "Relation Colors", "The following colors have been used for relation colors: "));
        groupings.add(this.getColorGrouping(noteColors, "Note", "note"));
        groupings.add(this.getColorGrouping(zoneColors, "Zone", "zone"));
        return groupings;
    }

    private void addColorUsed(Set colorSet, Object colorableObj) {
        IColorable colorable = (IColorable)colorableObj;
        Color color = colorable.getColor("MainBox");
        colorSet.add(color);
    }

    private ColorGrouping getColorGrouping(Set colors, String titlePart, String descPart) {
        String title = titlePart + " Colors";
        String desc = "The following colors have been used for " + descPart + " glyphs.";
        ColorGrouping grouping = new ColorGrouping(new ArrayList(colors), title, desc);
        return grouping;
    }

    private JMenuItem getCreateQueryCmd() {
        JMenuItem mni = new CreateQueryMniBldr().getCreateQueryMni(this.diagram_, this.db);
        return mni;
    }

    private Action getTableDetailsCmd(Table table) {
        PromptTableDetails cmdL = new PromptTableDetails(table);
        return cmdL;
    }

    public Action getTableDataCmd(Table table) {
        ShowTableDataTC cmdL = new ShowTableDataTC(table);
        return cmdL;
    }

    private List<JMenuItem> getSQLCmds(Table table) {
        ArrayList<JMenuItem> menuItems = new ArrayList<JMenuItem>();
        menuItems.add(this.getShowSqlMenuItem(table, EShowSqlType.CREATE));
        menuItems.add(this.getShowSqlMenuItem(table, EShowSqlType.INSERT));
        menuItems.add(this.getShowSqlMenuItem(table, EShowSqlType.UPDATE));
        menuItems.add(this.getShowSqlMenuItem(table, EShowSqlType.DELETE));
        return menuItems;
    }

    private JMenuItem getShowSqlMenuItem(Table table, EShowSqlType showSqlType) {
        IShowTableSqlActionBuilder actionBuilder = Nb8ActionBuilderProvider.getInstance().getBuilder();
        return new JMenuItem(actionBuilder.buildAction(table, showSqlType));
    }
}

