/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.diagram;

import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.dbwrench.diagram.autoLayout.DbLayoutCtrl;
import com.harrand.dbwrench.diagram.bldr.DbTableLayoutDisp;
import com.harrand.dbwrench.diagram.bldr.layout.ITableLayouter;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrench.object.Table;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.j2d.DiagramPanel;
import com.harrand.sketch.layout.ILayoutCtrl;
import com.harrand.util.LogUtil;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;

public class DbwDiagramDropListener
implements DropTargetListener {
    private DiagramPanel diagramPanel_;
    private ITableLayouter tableLayouter = new DbTableLayoutDisp();

    public DbwDiagramDropListener(DiagramPanel diagramPanel) {
        this.diagramPanel_ = diagramPanel;
    }

    public void setTableLayouter(ITableLayouter tableLayouter) {
        this.tableLayouter = tableLayouter;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        Transferable transferable = dtde.getTransferable();
        DataFlavor[] flavors = transferable.getTransferDataFlavors();
        if (dtde.isDataFlavorSupported(Table.DATA_FLAVOR)) {
            this.transferSingleTable(dtde, transferable);
        } else if (flavors.length > 0) {
            try {
                MultiTransferObject multiObj = (MultiTransferObject)transferable.getTransferData(ExTransferable.multiFlavor);
                this.transferMuliltpleObjs(dtde, multiObj);
            }
            catch (UnsupportedFlavorException ufe) {
                this.catchUnsupportedFlavor(ufe, dtde);
            }
            catch (IOException ioe) {
                this.catchIOException(ioe, dtde);
            }
        } else {
            this.rejectDrop(dtde);
        }
    }

    private void catchIOException(IOException ioe, DropTargetDropEvent dtde) {
        LogUtil.printStackTrace(ioe);
        this.rejectDrop(dtde);
    }

    private void catchUnsupportedFlavor(UnsupportedFlavorException ufe, DropTargetDropEvent dtde) {
        LogUtil.printStackTrace(ufe);
        dtde.rejectDrop();
        dtde.dropComplete(true);
    }

    private void rejectDrop(DropTargetDropEvent dtde) {
        dtde.rejectDrop();
        dtde.dropComplete(false);
    }

    private void transferMuliltpleObjs(DropTargetDropEvent dtde, MultiTransferObject multiObj) {
        ArrayList<Table> tables = new ArrayList<Table>();
        for (int i = 0; i < multiObj.getCount(); ++i) {
            Transferable transferable = multiObj.getTransferableAt(i);
            this.addTransferableTable(dtde, transferable, tables);
        }
        this.addTablesToDiagram(dtde, tables);
    }

    private void addTransferableTable(DropTargetDropEvent dtde, Transferable transferable, List<Table> tables) {
        if (transferable.isDataFlavorSupported(Table.DATA_FLAVOR)) {
            try {
                Object transData = transferable.getTransferData(Table.DATA_FLAVOR);
                tables.add((Table)transData);
            }
            catch (UnsupportedFlavorException ufe) {
                this.catchUnsupportedFlavor(ufe, dtde);
            }
            catch (IOException ioe) {
                this.catchIOException(ioe, dtde);
            }
        }
    }

    private void transferSingleTable(DropTargetDropEvent dtde, Transferable transferable) {
        ArrayList<Table> tables = new ArrayList<Table>();
        this.addTransferableTable(dtde, transferable, tables);
        this.addTablesToDiagram(dtde, tables);
    }

    private void addTablesToDiagram(DropTargetDropEvent dtde, List<Table> tables) {
        Diagram diagram = this.diagramPanel_.getDiagram();
        try {
            Point p = dtde.getLocation();
            int dragObjCount = tables.size();
            ILayoutCtrl layoutCtrl = this.getLayoutCtrl();
            ITestResult result = layoutCtrl.checkTooManyGlyphs(dragObjCount);
            if (!result.getPassed()) {
                GuiMessageHelper.showInputErrMsg(null, result);
                dtde.dropComplete(true);
                return;
            }
            this.tableLayouter.layoutTables(diagram, tables, p);
            this.diagramPanel_.paintComponent(this.diagramPanel_.getGraphics());
            dtde.dropComplete(true);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
            dtde.rejectDrop();
        }
    }

    private ILayoutCtrl getLayoutCtrl() {
        Database db = LookupUtil.findDb();
        return new DbLayoutCtrl(db);
    }
}

