/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db.worker.helper;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coregui.display.status.IStatusDisplayer;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.dbwrench.db.JdbcHelper;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrenchnb.server.conn.ConnChecker;
import com.harrand.util.LogUtil;
import javax.swing.JButton;
import javax.swing.JLabel;

public class DbWorkerUpdateHelper {
    private JButton disabledBtn;
    private IStatusDisplayer statusDisplayer;
    private JLabel statusLbl;

    public void displayLocatingSvr() {
        this.setStatusMsg("Locating Server...");
        this.startAnimation();
        this.disabledBtn.setEnabled(false);
    }

    public void startAnimation() {
        if (this.statusDisplayer != null) {
            this.statusDisplayer.startAnimation();
        }
    }

    public void displayAnalysingSvr() {
        this.setStatusMsg("Analyzing Server Database...");
    }

    public void displayConnecting() {
        this.setStatusMsg("Connecting to Server...");
        this.disabledBtn.setEnabled(false);
    }

    public void displayProcessing() {
        this.setStatusMsg(StrHelper.PROCESSING_STR);
        this.startAnimation();
        this.disabledBtn.setEnabled(false);
    }

    public void displayReady() {
        this.stopAnimation();
        this.setStatusMsg(StrHelper.READY_STR);
        this.disabledBtn.setEnabled(true);
    }

    public void stopAnimation() {
        if (this.statusDisplayer != null) {
            this.statusDisplayer.stopAnimation();
        }
    }

    public void setStatusMsg(String msg) {
        if (this.statusDisplayer != null) {
            this.statusDisplayer.setStatusMsg(msg);
        }
        if (this.statusLbl != null) {
            this.statusLbl.setText(msg);
        }
    }

    public boolean isConfigValid(JdbcConfig config) {
        this.displayLocatingSvr();
        ConnChecker checker = new ConnChecker();
        return ConnChecker.isConfigValid(config);
    }

    public void showSqlException(Exception e) {
        String cleanMsg_ = JdbcHelper.cleanMySqlConnErrMsg(e.getMessage());
        GuiMessageHelper.showGeneralAppErrMsg(null, cleanMsg_);
    }

    public void handleExecuteException(Exception ex, String workerNm) {
        String errMsg = workerNm + " threw an exception: \n" + ex.getMessage();
        GuiMessageHelper.showGeneralAppErrMsg(null, errMsg);
        LogUtil.logErr(errMsg);
    }

    public void setDisabledBtn(JButton disabledBtn) {
        this.disabledBtn = disabledBtn;
    }

    public void setSvrStatusDisplayer(IStatusDisplayer statusDisplayer) {
        this.statusDisplayer = statusDisplayer;
    }

    public void setStatusLabel(JLabel statusLbl) {
        this.statusLbl = statusLbl;
    }
}

