/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db.worker.edit;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.IRefreshable;
import com.harrand.coregui.Icons;
import com.harrand.coregui.display.Animator;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.jdesktop.swingworker.SwingWorker;
import com.harrand.coregui.label.StatusLabel;
import com.harrand.dbwrench.jdbc.ConnMgr;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.db.DbRowEditPanel;
import com.harrand.dbwrenchgui.db.TableDataPanel;
import com.harrand.dbwrenchgui.db.worker.helper.DbWorkerUpdateHelper;
import com.harrand.util.ResMgr;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.openide.util.Exceptions;

public class RowEditDlgDisplayWorker
extends SwingWorker<DbRowEditPanel, Void> {
    private Table table;
    private Map currentRowValues;
    private ConnMgr connMgr = ConnMgr.getInstance();
    private DbWorkerUpdateHelper updateHelper = new DbWorkerUpdateHelper();
    private StatusLabel readyStatus;
    private Animator animator;
    private IRefreshable refreshable;
    private int selectedGridCol;

    public RowEditDlgDisplayWorker(Table table, StatusLabel readyStatus, Animator animator, IRefreshable refreshable) {
        this.table = table;
        this.readyStatus = readyStatus;
        this.animator = animator;
        this.refreshable = refreshable;
    }

    @Override
    protected DbRowEditPanel doInBackground() throws Exception {
        this.readyStatus.setText(TableDataPanel.OPENING_EDITOR);
        this.animator.start();
        DbRowEditPanel editPanel = new DbRowEditPanel(this.getDatabase(), this.table, this.currentRowValues, this.getConfig(), this.selectedGridCol);
        return editPanel;
    }

    @Override
    protected void done() {
        super.done();
        this.animator.stop();
        this.readyStatus.setText(StrHelper.READY_STR);
        this.createDialog();
    }

    public void displayDialog(Map rowValues, int selectedGridCol) {
        this.currentRowValues = rowValues;
        this.selectedGridCol = selectedGridCol;
        try {
            this.execute();
        }
        catch (Exception ex) {
            this.updateHelper.handleExecuteException(ex, this.getClass().getName());
        }
    }

    private void createDialog() {
        DbRowEditPanel editPanel = this.getEditDlg();
        JDialog dlg = GuiHelper.createDialog(this.getDlgTitle(), true, editPanel);
        editPanel.setParentDialog(dlg);
        GuiHelper.locateDialog(dlg, editPanel.getPreferredBounds());
        Frame f = JOptionPane.getFrameForComponent(dlg);
        Image oldIconImage = f.getIconImage();
        f.setIconImage(Icons.TABLE_DATA.getImage());
        this.addWindowAdapter(dlg, editPanel);
        dlg.setVisible(true);
        if (f != null && oldIconImage != null) {
            f.setIconImage(oldIconImage);
        }
        if (editPanel.getDataChanged()) {
            this.refreshable.refresh();
        }
    }

    private String getDlgTitle() {
        String title = this.currentRowValues != null ? ResMgr.getRes("update.record.label") : ResMgr.getRes("insert.record.label");
        return title;
    }

    private DbRowEditPanel getEditDlg() {
        DbRowEditPanel editPanel = null;
        try {
            editPanel = (DbRowEditPanel)this.get();
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return editPanel;
    }

    private void addWindowAdapter(JDialog dlg, final DbRowEditPanel editPanel) {
        WindowAdapter adapter = new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                editPanel.setWidgetFocus();
            }
        };
        dlg.addWindowListener(adapter);
    }

    private JdbcConfig getConfig() {
        return this.connMgr.getCurrentCfg();
    }

    private Database getDatabase() {
        return LookupUtil.findDb();
    }

    public boolean isConfigSet() {
        return this.getConfig() != null;
    }
}

