/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db.worker.edit;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.IRefreshable;
import com.harrand.coregui.dataEntry.ScrollableErrorPanel;
import com.harrand.coregui.dialog.CloseDialog;
import com.harrand.coregui.display.Animator;
import com.harrand.coregui.jdesktop.swingworker.SwingWorker;
import com.harrand.coregui.label.StatusLabel;
import com.harrand.dbwrench.db.BasicSqlGenerator;
import com.harrand.dbwrench.jdbc.ConnMgr;
import com.harrand.dbwrench.jdbc.ConnectionFactory;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.db.worker.helper.DbWorkerUpdateHelper;
import com.harrand.util.ResMgr;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MultiDeleteWorker
extends SwingWorker<Void, Void> {
    private final Table table;
    private final DbWorkerUpdateHelper updateHelper = new DbWorkerUpdateHelper();
    private final StatusLabel readyStatus;
    private final Animator animator;
    private final IRefreshable refreshable;
    private List<Map> rowValuesList;
    private final BasicSqlGenerator sqlGenerator;

    public MultiDeleteWorker(Table table, StatusLabel readyStatus, Animator animator, IRefreshable refreshable) {
        this.table = table;
        this.readyStatus = readyStatus;
        this.animator = animator;
        this.refreshable = refreshable;
        this.sqlGenerator = new BasicSqlGenerator(this.getConfig().getDbms());
    }

    @Override
    protected Void doInBackground() throws Exception {
        int delCount = 0;
        ArrayList<String> errMsgs = new ArrayList<String>();
        this.readyStatus.setText(StrHelper.DELETING_DATA_STR);
        this.animator.start();
        try {
            Connection conn = ConnectionFactory.getConnection(this.getConfig());
            for (Map rowValues : this.rowValuesList) {
                String sql = this.sqlGenerator.getDeleteSql(this.table, rowValues);
                try {
                    PreparedStatement stmt = conn.prepareStatement(sql);
                    stmt.execute();
                    ++delCount;
                }
                catch (Exception e) {
                    errMsgs.add(e.getMessage());
                }
            }
            this.closeConnection(conn);
        }
        catch (Exception e) {
            this.updateHelper.handleExecuteException(e, this.getClass().getName());
        }
        this.processMsgs(errMsgs, delCount);
        return null;
    }

    @Override
    protected void done() {
        super.done();
        this.animator.stop();
        this.readyStatus.setText(StrHelper.READY_STR);
    }

    public void deleteMany(List<Map> rowValuesList) {
        this.rowValuesList = rowValuesList;
        try {
            this.execute();
        }
        catch (Exception ex) {
            this.updateHelper.handleExecuteException(ex, this.getClass().getName());
        }
    }

    private JdbcConfig getConfig() {
        return ConnMgr.getInstance().getCurrentCfg();
    }

    private void closeConnection(Connection conn) {
        if (conn != null) {
            ConnectionFactory.close(conn);
            conn = null;
        }
    }

    private void processMsgs(List<String> errMsgs, int delCount) {
        StringBuilder msgBuf = new StringBuilder();
        if (delCount > 1) {
            msgBuf.append(Integer.toString(delCount));
            msgBuf.append(ResMgr.getRes("deleted.x.records.success") + "\n");
        }
        if (delCount == 1) {
            msgBuf.append(ResMgr.getRes("deleted.record.success"));
        }
        if (!errMsgs.isEmpty()) {
            if (msgBuf.length() > 0) {
                msgBuf.append("\n");
            }
            msgBuf.append(ResMgr.getRes("errors.label"));
            for (String msg : errMsgs) {
                msgBuf.append("\n" + msg);
            }
            ScrollableErrorPanel panel = new ScrollableErrorPanel("Delete Operation Error", "The following error(s) occurred during the delete operation:", msgBuf.toString());
            CloseDialog dlg = new CloseDialog(null, true, panel);
            dlg.setVisible(true);
        }
        if (delCount > 0) {
            this.refreshable.refresh();
        }
    }
}

