/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db.query.xml.objects;

import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.db.query.objects.query.DbQuery;
import com.harrand.dbwrenchgui.db.query.objects.query.QueryTable;
import com.harrand.util.XmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class QueryTableXmlCtrl {
    public static final String SCH_NM = "Sch";
    public static final String TBL_NM = "Tbl";
    public static final String QUERY_TBL_NM = "QryTbl";
    public static final String ALIAS_NM = "Alias";
    public static final String X_NM = "X";
    public static final String Y_NM = "Y";

    public Element asXmlElement(Document doc, QueryTable queryTbl) {
        Element elmQueryTbl = XmlHelper.createElementSimple(doc, QUERY_TBL_NM, "");
        Table tbl = queryTbl.getTable();
        Schema sch = tbl.getSchema();
        String tblNm = tbl.getName();
        String schNm = sch.getName();
        elmQueryTbl.setAttribute(TBL_NM, tblNm);
        elmQueryTbl.setAttribute(SCH_NM, schNm);
        elmQueryTbl.setAttribute(ALIAS_NM, queryTbl.getAlias());
        XmlHelper.setAttr(elmQueryTbl, X_NM, queryTbl.getX());
        XmlHelper.setAttr(elmQueryTbl, Y_NM, queryTbl.getY());
        return elmQueryTbl;
    }

    public static QueryTable fromXml(Element elmQueryTbl, DbQuery query) {
        String alias = elmQueryTbl.getAttribute(ALIAS_NM);
        int x = XmlHelper.getAttrInt(elmQueryTbl, X_NM);
        int y = XmlHelper.getAttrInt(elmQueryTbl, Y_NM);
        QueryTable queryTable = QueryTableXmlCtrl.getQueryTable(query, elmQueryTbl);
        queryTable.setAlias(alias);
        queryTable.setX(x);
        queryTable.setY(y);
        return queryTable;
    }

    private static QueryTable getQueryTable(DbQuery query, Element elmQueryCol) {
        Database db = query.getDatabase();
        String schNm = elmQueryCol.getAttribute(SCH_NM);
        String tblNm = elmQueryCol.getAttribute(TBL_NM);
        Schema sch = db.getSchema(schNm);
        Table tbl = sch.getTable(tblNm);
        QueryTable qryTbl = new QueryTable(query, tbl);
        return qryTbl;
    }
}

