/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db.query.xml.objects;

import com.harrand.coreclasses.xml.IXmlCtrl;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.db.query.objects.query.DbQuery;
import com.harrand.dbwrenchgui.db.query.objects.query.QueryColumn;
import com.harrand.dbwrenchgui.db.query.objects.query.QueryTable;
import com.harrand.util.XmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class QueryColumnXmlCtrl
implements IXmlCtrl {
    public static final String COL_NM = "Col";
    public static final String SCH_NM = "Sch";
    public static final String TBL_NM = "Tbl";
    public static final String QUERY_COL_NM = "QryCol";
    public static final String ALIAS_NM = "Alias";
    public static final String FUNCTION_STR_NM = "Fn";

    public Element asXmlElement(Document doc, QueryColumn queryColumn) {
        Element elmQueryCol = XmlHelper.createElementSimple(doc, QUERY_COL_NM, "");
        Table tbl = queryColumn.getQueryTable().getTable();
        Schema sch = tbl.getSchema();
        String tblNm = tbl.getName();
        String schNm = sch.getName();
        elmQueryCol.setAttribute(COL_NM, queryColumn.getColumnNm());
        elmQueryCol.setAttribute(TBL_NM, tblNm);
        elmQueryCol.setAttribute(SCH_NM, schNm);
        elmQueryCol.setAttribute(ALIAS_NM, queryColumn.getAlias());
        elmQueryCol.setAttribute(FUNCTION_STR_NM, queryColumn.getFunctionStr());
        return elmQueryCol;
    }

    public static QueryColumn fromXml(Element elmQueryCol, DbQuery query) {
        String colNm = elmQueryCol.getAttribute(COL_NM);
        String alias = elmQueryCol.getAttribute(ALIAS_NM);
        String functionStr = elmQueryCol.getAttribute(FUNCTION_STR_NM);
        QueryTable queryTable = QueryColumnXmlCtrl.getQueryTable(query, elmQueryCol);
        Column column = QueryColumnXmlCtrl.getColumn(queryTable, colNm);
        QueryColumn queryCol = new QueryColumn(queryTable, column);
        queryCol.setAlias(alias);
        queryCol.setFunctionStr(functionStr);
        return queryCol;
    }

    private static Column getColumn(QueryTable queryTable, String colNm) {
        Table table = queryTable.getTable();
        return table.getColumn(colNm);
    }

    private static QueryTable getQueryTable(DbQuery query, Element elmQueryCol) {
        Database db = query.getDatabase();
        String schNm = elmQueryCol.getAttribute(SCH_NM);
        String tblNm = elmQueryCol.getAttribute(TBL_NM);
        Schema sch = db.getSchema(schNm);
        Table tbl = sch.getTable(tblNm);
        QueryTable qryTbl = query.getQueryTable(tbl);
        return qryTbl;
    }
}

