/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db.query.xml.objects;

import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrenchgui.db.query.diagram.glyph.table.QueryTableGlyphAdder;
import com.harrand.dbwrenchgui.db.query.objects.query.DbQuery;
import com.harrand.dbwrenchgui.db.query.objects.query.QueryTable;
import com.harrand.dbwrenchgui.db.query.objects.select.SelectLineObjsMgr;
import com.harrand.dbwrenchgui.db.query.xml.diagram.QueryDiagramXmlCtrl;
import com.harrand.dbwrenchgui.db.query.xml.objects.QueryTablesXmlCtrl;
import com.harrand.dbwrenchgui.db.query.xml.objects.SelectLineObjsMgrXmlCtrl;
import com.harrand.sketch.core.Diagram;
import com.harrand.util.XmlHelper;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DbQueryXmlCtrl {
    public static final String DB_QUERY_NM = "Qry";
    public static final String NAME_NM = "Nm";

    public Element asXmlElement(Document doc, DbQuery query) {
        Element elmQuery = XmlHelper.createElementSimple(doc, DB_QUERY_NM, "");
        elmQuery.setAttribute(NAME_NM, query.getName());
        elmQuery.appendChild(this.getQueryTablesElm(doc, query));
        elmQuery.appendChild(this.getSelectLineObjsElm(doc, query));
        elmQuery.appendChild(this.getDiagramElm(doc, query));
        return elmQuery;
    }

    public static DbQuery fromXml(Element elmQuery, Database db) {
        String nm = elmQuery.getAttribute(NAME_NM);
        DbQuery query = new DbQuery(nm);
        query.setDatabase(db);
        List<QueryTable> queryTables = DbQueryXmlCtrl.getQueryTables(elmQuery, query);
        query.setQueryTables(queryTables);
        SelectLineObjsMgr selectLineObjsMgr = DbQueryXmlCtrl.getSelectLinesObjMgr(elmQuery, query);
        query.setSelectLinesObjsMgr(selectLineObjsMgr);
        DbQueryXmlCtrl.loadQueryDiagram(query, elmQuery, query.getName());
        return query;
    }

    private Node getQueryTablesElm(Document doc, DbQuery query) {
        QueryTablesXmlCtrl xmlCtrl = new QueryTablesXmlCtrl();
        return xmlCtrl.asXmlElement(doc, query.getQueryTables());
    }

    private Node getSelectLineObjsElm(Document doc, DbQuery query) {
        SelectLineObjsMgrXmlCtrl xmlCtrl = new SelectLineObjsMgrXmlCtrl();
        return xmlCtrl.asXmlElement(doc, query.getSelectLinesObjsMgr());
    }

    private static SelectLineObjsMgr getSelectLinesObjMgr(Element elmQuery, DbQuery query) {
        Element elmSelectLineObjsMgr = XmlHelper.getFirstElementByTagName(elmQuery, "SelectLineObjs");
        return SelectLineObjsMgrXmlCtrl.fromXml(elmSelectLineObjsMgr, query);
    }

    private static List<QueryTable> getQueryTables(Element elmQuery, DbQuery query) {
        Element elmQueryTables = XmlHelper.getFirstElementByTagName(elmQuery, "QryTbls");
        return QueryTablesXmlCtrl.fromXml(elmQueryTables, query);
    }

    private static void loadQueryDiagram(DbQuery query, Element elmQuery, String nm) {
        Element elmDiagram = XmlHelper.getFirstElementByTagName(elmQuery, "QryDiagram");
        Diagram diagram = QueryDiagramXmlCtrl.fromXml(elmDiagram, nm);
        query.setDiagram(diagram);
        new QueryTableGlyphAdder().positionDiagramGlyphs(query);
    }

    private Element getDiagramElm(Document doc, DbQuery query) {
        QueryDiagramXmlCtrl xmlCtrl = new QueryDiagramXmlCtrl();
        return xmlCtrl.asXmlElement(doc, query.getDiagram());
    }
}

