/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db.query.objects.query;

import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrenchgui.db.query.bldr.select.lineBldr.QueryColumnSelectLineBldr;
import com.harrand.dbwrenchgui.db.query.objects.query.DbQuery;
import com.harrand.dbwrenchgui.db.query.objects.query.QueryTable;
import com.harrand.dbwrenchgui.db.query.objects.select.ISelectLineObj;
import com.harrand.util.Validator;

public final class QueryColumn
implements ISelectLineObj {
    private final Column column;
    private final QueryTable queryTable;
    private final QueryColumnSelectLineBldr selectLineBldr;
    private String functionStr;
    private String alias;

    public QueryColumn(QueryTable queryTable, Column column) {
        this.column = column;
        this.queryTable = queryTable;
        this.selectLineBldr = new QueryColumnSelectLineBldr();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryColumn)) {
            return false;
        }
        QueryColumn other = (QueryColumn)o;
        if (other.getQueryTable().getName() != this.getQueryTable().getName()) {
            return false;
        }
        return other.getColumnNm() == this.getColumnNm();
    }

    public Column getColumn() {
        return this.column;
    }

    public QueryTable getQueryTable() {
        return this.queryTable;
    }

    public DbQuery getQuery() {
        return this.getQueryTable().getQuery();
    }

    public String getFunctionStr() {
        return this.functionStr;
    }

    public void setFunctionStr(String functionStr) {
        this.functionStr = functionStr;
    }

    public String getColumnNm() {
        return this.column.getName();
    }

    public boolean isFunctionSet() {
        return Validator.isStringValid(this.functionStr);
    }

    public boolean isAliasSet() {
        return Validator.isStringValid(this.alias);
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String toString() {
        return this.column.getName();
    }

    @Override
    public String getSelectLine() {
        return this.selectLineBldr.buildSelectLine(this);
    }

    @Override
    public String getName() {
        return this.getColumnNm();
    }

    public String getItemType() {
        return "Table Column";
    }

    @Override
    public String getId() {
        return this.getName();
    }

    @Override
    public String getMapName() {
        return "QueryColumn";
    }

    @Override
    public String getDisplayClzNm() {
        return "Query Column";
    }

    @Override
    public String getDisplayClzPlural() {
        return "Query Columns";
    }

    @Override
    public void setName(String newName) {
    }
}

