/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db.query.diagram.nav;

import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.panel.viewport.ViewportMoveCtrl;
import com.harrand.dbwrenchgui.db.query.panel.general.DbQueryPanel;
import com.harrand.dbwrenchgui.diagram.panel.scroll.DiagramScrollBarInitCtrl;
import com.harrand.dbwrenchnb.diagram.GlyphLocateMgr;
import com.harrand.dbwrenchnb.diagram.NavTCTopComponent;
import com.harrand.sketch.core.GeometryHelper;
import com.harrand.sketch.interfaces.INavigator;
import com.harrand.sketch.j2d.DiagramPanel;
import com.harrand.util.MathUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.windows.WindowManager;

public final class QueryNavPanelCtrl
implements IObserver,
ChangeListener {
    private INavigator navigator_;
    private final DiagramPanel diagramPanel_;
    private GlyphLocateMgr glyphLocateMgr_ = GlyphLocateMgr.getInstance();
    private final DbQueryPanel queryPanel;
    private ViewportMoveCtrl viewportMoveCtrl_;
    private JScrollBar vbar_;
    private JScrollBar hbar_;
    private boolean updateNvFlag_;

    public QueryNavPanelCtrl(DbQueryPanel queryPanel) {
        this.queryPanel = queryPanel;
        this.diagramPanel_ = this.queryPanel.getDiagramPanel();
        this.hbar_ = this.getScrollPane().getHorizontalScrollBar();
        this.vbar_ = this.getScrollPane().getVerticalScrollBar();
        this.initNavTC();
        this.addScrollBarListeners();
        this.initScrollBars();
    }

    public void initNavTC() {
        NavTCTopComponent navTc = NavTCTopComponent.getDefault();
        this.navigator_ = navTc.getNvPanel();
        this.navigator_.setNavigatorSrc(this.queryPanel);
        this.navigator_.setDiagram(this.diagramPanel_.getDiagram());
        this.navigator_.clearObserversOfClass(this.getClass().getName());
        this.navigator_.addObserver(this);
        this.glyphLocateMgr_.setDiagramScroller(this.queryPanel);
        this.viewportMoveCtrl_ = new ViewportMoveCtrl(this.getViewport());
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                QueryNavPanelCtrl.this.updateNvPosition();
            }
        });
    }

    private JViewport getViewport() {
        return this.getScrollPane().getViewport();
    }

    private void updateNvPosition() {
        if (this.isNavigatorSet()) {
            this.navigator_.setPortalInDiaCoords(this.getPortal());
        }
    }

    private boolean isNavigatorSet() {
        return this.navigator_ != null;
    }

    public Rectangle2D getPortal() {
        Rectangle vpRect = this.getScrollPane().getViewport().getViewRect();
        return GeometryHelper.getRect2D(vpRect);
    }

    public void clearNvSrc() {
        this.navigator_.setNavigatorSrc(null);
    }

    @Override
    public void update(UpdateChain chain) {
        this.scrollToNavPos();
    }

    private JScrollPane getScrollPane() {
        return this.queryPanel.getScrollPane();
    }

    private void scrollToNavPos() {
        Dimension size;
        this.updateNvFlag_ = false;
        Rectangle2D portal = this.navigator_.getPortalInDiaCoords();
        Point pt = new Point(MathUtil.round(portal.getX()), MathUtil.round(portal.getY()));
        ITestResult result = this.viewportMoveCtrl_.checkMoveOk(pt, size = this.diagramPanel_.getPreferredSize());
        if (result.getPassed()) {
            this.viewportMoveCtrl_.moveViewDirectly(pt);
        }
        this.updateNvFlag_ = true;
    }

    private void addScrollBarListeners() {
        this.hbar_.getModel().addChangeListener(this);
        this.vbar_.getModel().addChangeListener(this);
    }

    private void initScrollBars() {
        DiagramScrollBarInitCtrl initCtrl = new DiagramScrollBarInitCtrl(this.vbar_, this.hbar_);
        initCtrl.initScrollBars();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateNvPosition();
    }
}

