/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db.query.diagram.glyph.table;

import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.display.Colors;
import com.harrand.coreclasses.interfaces.IRefreshable;
import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.mouse.tracker.IMouseTracker;
import com.harrand.dbwrench.diagram.hilight.color.IColorScheme;
import com.harrand.dbwrench.diagram.table.ITableGlyph;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.db.query.command.click.table.QueryTableClickActionBldr;
import com.harrand.dbwrenchgui.db.query.diagram.glyph.column.QueryColumnGlyph;
import com.harrand.dbwrenchgui.db.query.diagram.glyph.table.TableGlyphWidthCalc;
import com.harrand.dbwrenchgui.db.query.objects.query.QueryColumn;
import com.harrand.dbwrenchgui.db.query.objects.query.QueryTable;
import com.harrand.sketch.command.clickAction.ctrl.BasicClickActionCtrl;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.GeometryHelper;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.core.GlyphBox;
import com.harrand.sketch.core.RenderConfig;
import com.harrand.sketch.core.config.rc.IRenderConfigSrc;
import com.harrand.sketch.glyph.HeaderGlyph;
import com.harrand.sketch.glyph.footer.FooterGlyph;
import com.harrand.sketch.glyph.header.HeaderTextXCalc;
import com.harrand.sketch.glyph.mouse.BasicGlyphMouseTracker;
import com.harrand.sketch.interfaces.IHilightableGlyph;
import com.harrand.sketch.interfaces.IPreImagedGlyph;
import com.harrand.sketch.j2d.draw.IDrawable;
import com.harrand.sketch.j2d.highLight.RoundRectHighLighter;
import com.harrand.sketch.support.DrawableUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class QueryTableGlyph
implements IDrawable,
IPreImagedGlyph,
IRefreshable,
ITableGlyph,
Glyph,
ISized,
IMouseTracker,
IHilightableGlyph,
IRenderConfigSrc {
    private final QueryTable queryTable;
    private List<QueryColumnGlyph> columnGlyphs = new ArrayList<QueryColumnGlyph>();
    private final GlyphBox glyphBox;
    private HeaderGlyph headerGlyph;
    private final RoundRectHighLighter highLighter = new RoundRectHighLighter();
    private FooterGlyph footer;
    private boolean isSelected;
    private final QueryTableClickActionBldr clickActionBldr;
    private final BasicClickActionCtrl clickActionCtrl;
    private final BasicGlyphMouseTracker mouseTracker;
    private final Diagram diagram;
    private final Color color = Colors.getBlueGreenMild();
    public static final int TOP_SPACE = 5;
    public static final int BOTTOM_SPACE = 8;
    public static final int LEFT_MARGIN = 5;
    public static final int HEADER_VERT_SPACE = 20;
    public static final int SHADING_WIDTH_LOCAL = 2;
    public static final int CORNER_RADIUS = 8;

    public QueryTableGlyph(Diagram diagram, QueryTable queryTable) {
        this.diagram = diagram;
        this.queryTable = queryTable;
        this.glyphBox = new GlyphBox(new Point(this.getX(), this.getY()), true);
        this.clickActionBldr = new QueryTableClickActionBldr(this);
        this.clickActionCtrl = new BasicClickActionCtrl(this.clickActionBldr, this);
        this.mouseTracker = new BasicGlyphMouseTracker(this.clickActionCtrl, this, this, diagram, this.getTable());
        this.initGlyphBox();
        this.initHeader();
        this.refresh();
    }

    private void initGlyphBox() {
        this.glyphBox.setShadingFlag(false);
        this.glyphBox.setShadingWidth(2);
        this.glyphBox.setColor("MainBox", Color.WHITE);
        this.glyphBox.setUseGradient(false);
        this.glyphBox.setCornerRadius(8);
        this.footer = this.glyphBox.getFooterGlyph();
    }

    private void refreshShapes() {
        this.refreshColumnGlyphs();
        this.resizeGlyphBox();
        this.refreshHeader();
        Collection<IDrawable> clickActionDrawables = this.clickActionCtrl.getDrawables();
        ArrayList<IDrawable> allShapes = new ArrayList<IDrawable>();
        allShapes.addAll(this.headerGlyph.getDrawables());
        allShapes.addAll(clickActionDrawables);
        allShapes.addAll(this.columnGlyphs);
        this.glyphBox.setAddedShapes(allShapes);
        this.footer.setBgColor(this.color);
    }

    private void refreshColumnGlyphs() {
        this.columnGlyphs = new ArrayList<QueryColumnGlyph>();
        int lineHeight = this.getLineHeight();
        int y = 2 * lineHeight + 2 + 5;
        for (QueryColumn queryColumn : this.queryTable.getQueryColumns()) {
            Point lineOrigin = new Point(0, y);
            QueryColumnGlyph colGlyph = new QueryColumnGlyph(this.diagram, queryColumn, lineOrigin);
            colGlyph.refresh();
            this.columnGlyphs.add(colGlyph);
            y += lineHeight;
        }
    }

    private void initHeader() {
        this.headerGlyph = new HeaderGlyph(new RenderConfig(1.0), this.getWidth(), this.getHeaderText());
        this.headerGlyph.setContainingRectRadius(8);
        this.headerGlyph.setBgColor(this.getColor());
        this.headerGlyph.setOrigin(new Point(1, 1));
        this.headerGlyph.setUseGradient(false);
        this.headerGlyph.setHeaderTextXCalc(HeaderTextXCalc.CENTERED);
    }

    public QueryTable getQueryTable() {
        return this.queryTable;
    }

    @Override
    public String getName() {
        return this.queryTable.getName();
    }

    @Override
    public void setName(String newName) {
    }

    public List<QueryColumnGlyph> getColumnGlyphs() {
        return this.columnGlyphs;
    }

    private String getHeaderText() {
        return this.queryTable.getTable().getName();
    }

    private Color getColor() {
        return this.color;
    }

    private void resizeGlyphBox() {
        int linesCnt = this.getColumns().size() + 1;
        int footerHeight = FooterGlyph.getHeight(this.getRenderConfig());
        int boxHeight = this.getLineHeight() * linesCnt + footerHeight + 5 + 8;
        int boxWidth = new TableGlyphWidthCalc().getGlyphWidth(this);
        this.glyphBox.setBoxRect(this.getX(), this.getY(), boxWidth, boxHeight);
    }

    private void refreshHeader() {
        this.headerGlyph.setText(this.getHeaderText());
        this.headerGlyph.setWidth(this.getWidth() - 2);
    }

    int getHeaderWidth() {
        return GuiHelper.getSwingStringLength(this.getDisplayText(), this.getFont());
    }

    private int getLineHeight() {
        return GuiHelper.getSwingStringHeight(this.getFont());
    }

    private int getWidth() {
        return (int)this.glyphBox.getBounds().getWidth();
    }

    private Font getFont() {
        return this.getRenderConfig().getFont();
    }

    private int getY() {
        return this.queryTable.getY();
    }

    private int getX() {
        return this.queryTable.getX();
    }

    private List<Column> getColumns() {
        return this.getTable().getColumns();
    }

    @Override
    public void draw(Graphics2D g2, Zoom zoom) {
        DrawableUtil.drawPreImaged(this, g2, zoom);
    }

    @Override
    public void refresh() {
        this.refreshShapes();
        this.glyphBox.refresh();
    }

    @Override
    public Rectangle getPreferredBounds() {
        return this.glyphBox.getBounds();
    }

    @Override
    public BufferedImage getImage() {
        return this.glyphBox.getImage();
    }

    private String getDisplayText() {
        return this.queryTable.getName();
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.glyphBox.getBounds2D();
    }

    @Override
    public boolean contains(Point2D p) {
        return this.getBounds2D().contains(p);
    }

    @Override
    public boolean contains(double x, double y) {
        return this.getBounds2D().contains(x, y);
    }

    @Override
    public void setAngle(double angle) {
    }

    @Override
    public void move(Point p) {
        this.queryTable.setX(p.x);
        this.queryTable.setY(p.y);
        this.glyphBox.move(new Point(this.getX(), this.getY()));
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }

    @Override
    public boolean getSelected() {
        return this.isSelected;
    }

    @Override
    public void setScaleFactor(double scaleFactor) {
    }

    public List getDrawables() {
        return null;
    }

    @Override
    public Table getTable() {
        return this.queryTable.getTable();
    }

    @Override
    public int getColumnPos(String colNm) {
        int pos = -1;
        int i = 0;
        for (Column column : this.getColumns()) {
            if (column.getName().equals(colNm)) {
                pos = i;
                return pos;
            }
            ++i;
        }
        return pos;
    }

    @Override
    public Rectangle2D getColumnBounds(String colNm) {
        Rectangle2D.Double rawRect = null;
        int lineHeight = this.getLineHeight();
        int pos = this.getColumnPos(colNm);
        Rectangle2D box = this.getBounds2D();
        double x = box.getX() + 1.0;
        double y = box.getY() + ((double)pos + 1.3) * (double)lineHeight + 5.0;
        rawRect = new Rectangle2D.Double(x, y, box.getWidth() - 5.0, lineHeight);
        return rawRect;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseTracker.mouseMoved(e);
    }

    @Override
    public boolean mouseDown(MouseEvent e) {
        return this.mouseTracker.mouseDown(e);
    }

    @Override
    public void mouseUp(MouseEvent e) {
        this.mouseTracker.mouseUp(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseTracker.mouseExited(e);
    }

    @Override
    public RenderConfig getRenderConfig() {
        return this.diagram.getRenderConfig();
    }

    @Override
    public List<IDrawable> getHilightDrawables(Diagram diagram) {
        RoundRectangle2D rect = GeometryHelper.getRoundRect(this.getBounds2D(), 8.0);
        return this.highLighter.getHilightShapes(rect, diagram.getZoom());
    }

    @Override
    public void setColorScheme(IColorScheme colorScheme) {
        this.highLighter.setColorScheme(colorScheme);
    }
}

