/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db.query.diagram.glyph.column;

import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.interfaces.IRefreshable;
import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrenchgui.db.query.diagram.glyph.column.ColumnSelectIconDrawable;
import com.harrand.dbwrenchgui.db.query.diagram.glyph.column.QueryColumnNameGlyph;
import com.harrand.dbwrenchgui.db.query.objects.query.DbQuery;
import com.harrand.dbwrenchgui.db.query.objects.query.QueryColumn;
import com.harrand.sketch.core.config.rc.IRenderConfigSrc;
import com.harrand.sketch.j2d.draw.IDrawable;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public final class QueryColumnGlyph
implements IDrawable,
ISized,
IRefreshable {
    private final DbQuery query;
    private QueryColumn queryColumn;
    private QueryColumnNameGlyph nameGlyph;
    private ColumnSelectIconDrawable selectIconDrawable;
    private Point origin;
    private final IRenderConfigSrc rcSrc;
    private BufferedImage img;
    private Rectangle imgRect;
    private Point2D lastSelectIconOrigin;
    public static final int LEFT_MARGIN = 16;
    public static final int ICON_COLUMNS = 3;

    public QueryColumnGlyph(IRenderConfigSrc rcSrc, QueryColumn queryColumn, Point origin) {
        this.rcSrc = rcSrc;
        this.queryColumn = queryColumn;
        this.query = this.queryColumn.getQueryTable().getQuery();
        this.origin = origin;
        this.createSelectIconDrawable();
        this.createNmGlyph();
        this.refresh();
    }

    private void createSelectIconDrawable() {
        int y = this.origin.y - this.getLineHeight() + 2;
        Point topLeft = new Point(this.origin.x + 3, y);
        this.selectIconDrawable = new ColumnSelectIconDrawable(this.queryColumn, topLeft, this.rcSrc);
        this.lastSelectIconOrigin = topLeft;
    }

    private void createNmGlyph() {
        Point nmOrigin = new Point(this.origin.x + 16, this.origin.y);
        this.nameGlyph = new QueryColumnNameGlyph(this.getColumn(), this.rcSrc, nmOrigin);
    }

    private Zoom getZoom() {
        return this.rcSrc.getRenderConfig().getZoom();
    }

    private void createImage() {
        this.calcImageSize();
        this.img = GuiHelper.getBufferedImage(this.imgRect.width, this.imgRect.height, true);
    }

    private void calcImageSize() {
        this.imgRect = new Rectangle(this.getWidth(), this.getHeight());
    }

    private int getWidth() {
        int width = this.getTextWidth() + this.getIconsWidth();
        return width;
    }

    private int getTextWidth() {
        return (int)this.nameGlyph.getPreferredBounds().getWidth();
    }

    private int getHeight() {
        return (int)this.nameGlyph.getPreferredBounds().getHeight();
    }

    private int getLineHeight() {
        return GuiHelper.getSwingStringHeight(this.getFont());
    }

    private Font getFont() {
        return this.rcSrc.getRenderConfig().getFont();
    }

    public Column getColumn() {
        return this.queryColumn.getColumn();
    }

    public QueryColumn getQueryColumn() {
        return this.queryColumn;
    }

    public QueryColumnNameGlyph getNameGlyph() {
        return this.nameGlyph;
    }

    @Override
    public Rectangle getPreferredBounds() {
        return this.imgRect;
    }

    @Override
    public void draw(Graphics2D g2, Zoom zoom) {
        this.nameGlyph.draw(g2, zoom);
        this.selectIconDrawable.draw(g2, zoom);
    }

    @Override
    public String getName() {
        return this.queryColumn.getName();
    }

    @Override
    public void setName(String newName) {
    }

    public BufferedImage getImage() {
        if (this.img == null) {
            this.refresh();
        }
        return this.img;
    }

    private int getIconsWidth() {
        return 3 * this.getIconWidth();
    }

    private int getIconWidth() {
        return 16;
    }

    @Override
    public void refresh() {
        this.createImage();
        this.nameGlyph.refresh();
        this.draw((Graphics2D)this.img.getGraphics(), this.getZoom());
    }

    public Point2D getLastSelectIconOrigin() {
        return this.lastSelectIconOrigin;
    }
}

