/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db.query.diagram.cmd;

import com.harrand.coreclasses.zoom.Zoomer;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrenchgui.db.query.command.direct.Column.SelectAllQueryColumnsCmd;
import com.harrand.dbwrenchgui.db.query.command.direct.table.RemoveQueryTableCmd;
import com.harrand.dbwrenchgui.db.query.command.direct.table.RemoveQueryTablesCmd;
import com.harrand.dbwrenchgui.db.query.diagram.glyph.table.QueryTableGlyph;
import com.harrand.dbwrenchgui.db.query.objects.query.DbQuery;
import com.harrand.dbwrenchgui.db.query.objects.query.QueryTable;
import com.harrand.dbwrenchgui.db.query.objects.table.QueryTableFromGlyphExtractor;
import com.harrand.sketch.command.IDiagramCmdBldr;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;

public final class QueryDiagramCmdBldr
implements IDiagramCmdBldr {
    private Diagram diagram;
    private final DbQuery query;

    public QueryDiagramCmdBldr(DbQuery query, Diagram diagram) {
        this.setDiagram(diagram);
        this.query = query;
    }

    @Override
    public List<JMenuItem> getCommands(Point pt) {
        List<JMenuItem> cmds = new ArrayList<JMenuItem>();
        Glyph clickedGlyph = this.diagram.getGlyphContainingPoint(pt);
        if (clickedGlyph == null) {
            return cmds;
        }
        double level = this.diagram.getRenderConfig().getZoomLevel();
        Point pntUnZoomed = Zoomer.zoom(pt, 1.0 / level);
        boolean isClickedGlyphQueryGlyph = this.isClickedGlyphQueryGlyph(clickedGlyph);
        if (isClickedGlyphQueryGlyph) {
            cmds = this.getTableGlyphCmds(clickedGlyph, pntUnZoomed);
        }
        return cmds;
    }

    private List<QueryTable> extractQueryTablesFromGlyphs(List selectedGlyphs) {
        QueryTableFromGlyphExtractor extractor = new QueryTableFromGlyphExtractor();
        List<QueryTable> queryTables = extractor.getQueryTables(selectedGlyphs);
        return queryTables;
    }

    private boolean isClickedGlyphQueryGlyph(Glyph glyph) {
        return glyph instanceof QueryTableGlyph;
    }

    private List<JMenuItem> getTableGlyphCmds(Glyph clickedGlyph, Point pntUnZoomed) {
        ArrayList<JMenuItem> cmds = new ArrayList<JMenuItem>();
        cmds.add(this.getSelectAllCmd());
        cmds.add(this.getRemoveCmd());
        return cmds;
    }

    public JMenuItem getRemoveCmd() {
        List selectedGlyphs = this.diagram.getSelectedGlyphs(false);
        JMenuItem mni = new JMenuItem("Remove");
        mni.setMnemonic(82);
        mni.setEnabled(false);
        Command cmd = null;
        int selectedSize = selectedGlyphs.size();
        if (selectedSize == 1) {
            QueryTableGlyph glyph = (QueryTableGlyph)selectedGlyphs.get(0);
            cmd = new RemoveQueryTableCmd(glyph.getQueryTable());
            mni = GuiHelper.getMenuItemFromCmd(cmd);
        } else if (selectedSize > 1) {
            List<QueryTable> queryTables = this.extractQueryTablesFromGlyphs(selectedGlyphs);
            cmd = new RemoveQueryTablesCmd(queryTables);
            mni = GuiHelper.getMenuItemFromCmd(cmd);
        }
        if (cmd != null) {
            cmd.setCommandChain(App.getCommandChain());
        }
        return mni;
    }

    @Override
    public void setDiagram(Diagram diagram) {
        this.diagram = diagram;
    }

    private JMenuItem getSelectAllCmd() {
        List selectedGlyphs = this.diagram.getSelectedGlyphs(false);
        JMenuItem mni = new JMenuItem("SELECT All");
        mni.setMnemonic(65);
        mni.setEnabled(false);
        SelectAllQueryColumnsCmd cmd = null;
        int selectedSize = selectedGlyphs.size();
        List<QueryTable> queryTables = this.extractQueryTablesFromGlyphs(selectedGlyphs);
        cmd = new SelectAllQueryColumnsCmd(this.query, queryTables);
        mni = GuiHelper.getMenuItemFromCmd(cmd);
        if (cmd != null) {
            cmd.setCommandChain(App.getCommandChain());
        }
        return mni;
    }
}

