/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db.query.diagram.bldr;

import com.harrand.dbwrench.diagram.KeyToKeyStrategy;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrenchgui.db.query.diagram.bldr.QueryTableGlyphBldr;
import com.harrand.dbwrenchgui.db.query.diagram.glyph.table.QueryTableGlyph;
import com.harrand.dbwrenchgui.db.query.objects.query.DbQuery;
import com.harrand.dbwrenchgui.diagram.layout.LayoutGlyphsDisp;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.RenderConfig;
import java.awt.Point;
import java.util.List;

public final class QueryDiagramBldr {
    private Diagram diagram;
    private Point pt = new Point(100, 100);
    private DbQuery query;
    private List<QueryTableGlyph> queryTablesGlyphs;

    public Diagram createDiagram(DbQuery query) {
        this.diagram = new Diagram(query.getName(), new RenderConfig(1.0));
        this.query = query;
        this.buildGlyphs();
        this.layoutTables();
        query.getDatabase().initDiagramObjects(this.diagram);
        this.setLinkAlgorithm();
        this.disableFkNms();
        return this.diagram;
    }

    private void buildGlyphs() {
        QueryTableGlyphBldr glyphBldr = new QueryTableGlyphBldr();
        this.queryTablesGlyphs = glyphBldr.buildGlyphs(this.diagram, this.query.getQueryTables());
    }

    private Database getDb() {
        return this.query.getDatabase();
    }

    private void layoutTables() {
        new LayoutGlyphsDisp().layoutGlyphs(this.diagram, this.queryTablesGlyphs, this.pt);
    }

    private void setLinkAlgorithm() {
        this.diagram.getRenderConfig().setLinkStrategy(new KeyToKeyStrategy(this.getDb()));
    }

    private void disableFkNms() {
        this.diagram.getDiagramProps().setShowFkNames(false);
    }
}

