/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db.query.command.direct.table;

import com.harrand.coregui.command.Command;
import com.harrand.dbwrenchgui.db.query.diagram.glyph.table.QueryTableGlyph;
import com.harrand.dbwrenchgui.db.query.objects.query.DbQuery;
import com.harrand.dbwrenchgui.db.query.objects.query.QueryTable;
import com.harrand.sketch.core.Diagram;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class RemoveQueryTablesCmd
extends Command {
    private DbQuery query;
    private List<QueryTable> queryTables;
    private String cmdName;
    private Map<String, QueryTableGlyph> queryTableGlyphs = new HashMap<String, QueryTableGlyph>();
    private Diagram diagram;
    public static final String CMD_NM = "Remove Query Table";

    public RemoveQueryTablesCmd(List<QueryTable> queryTables) {
        this.init(queryTables, new HashMap<String, QueryTableGlyph>());
        this.buildObject();
    }

    public RemoveQueryTablesCmd(List<QueryTable> queryTables, Map<String, QueryTableGlyph> queryTableGlyphs) {
        this.init(queryTables, queryTableGlyphs);
        this.buildObject();
    }

    private void init(List<QueryTable> queryTables, Map<String, QueryTableGlyph> queryTableGlyphs) {
        this.queryTables = queryTables;
        this.query = this.queryTables.get(0).getQuery();
        this.diagram = this.query.getDiagram();
        this.queryTableGlyphs = queryTableGlyphs;
        this.buildObject();
    }

    private void buildObject() {
        this.cmdName = CMD_NM;
        this.setProps();
    }

    @Override
    protected void execute() {
        if (this.getState() == RemoveQueryTablesCmd.getStateDo()) {
            this.doForward();
        } else if (this.getState() == RemoveQueryTablesCmd.getStateRedo()) {
            this.doForward();
        }
    }

    public void doForward() {
        for (QueryTable queryTable : this.queryTables) {
            this.query.removeQueryTable(queryTable);
            String queryTblNm = queryTable.getName();
            QueryTableGlyph queryTableGlyph = (QueryTableGlyph)this.diagram.getGlyph(queryTblNm);
            this.diagram.removeGlyph(queryTblNm);
            this.queryTableGlyphs.put(queryTblNm, queryTableGlyph);
        }
        this.diagram.refresh();
    }

    @Override
    protected void undo() {
        for (QueryTable queryTable : this.queryTables) {
            this.query.addQueryTable(queryTable);
            String name = queryTable.getName();
            QueryTableGlyph queryTableGlyph = this.queryTableGlyphs.get(name);
            this.diagram.addGlyph(queryTableGlyph);
        }
        this.diagram.refresh();
    }

    @Override
    public Command duplicate() {
        RemoveQueryTablesCmd cmdNew = new RemoveQueryTablesCmd(this.queryTables, this.queryTableGlyphs);
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.cmdName;
        this.putValue("Name", CMD_NM);
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
    }
}

