/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db.query.command.direct.table;

import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.CommandChainMgr;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.db.query.factory.QueryTableFactory;
import com.harrand.dbwrenchgui.db.query.objects.query.DbQuery;
import com.harrand.dbwrenchgui.db.query.objects.query.QueryTable;

public class AddQueryTableCmd
extends Command {
    private Table table;
    private DbQuery query;
    private QueryTable newQueryTable;
    private String cmdName;
    public static final String CMD_NM = "Add Query Table";

    public AddQueryTableCmd(DbQuery query, Table table) {
        this.init(query, table, null);
        this.buildObject();
    }

    private AddQueryTableCmd(DbQuery query, Table table, QueryTable newQueryTable) {
        this.init(query, table, newQueryTable);
    }

    private void init(DbQuery query, Table table, QueryTable newQueryTable) {
        this.query = query;
        this.table = table;
        this.newQueryTable = newQueryTable;
        this.buildObject();
    }

    private void buildObject() {
        this.cmdName = "Add Query Table: " + this.table.getDotNote();
        this.setProps();
    }

    @Override
    protected void execute() {
        if (this.getState() == AddQueryTableCmd.getStateDo()) {
            this.createAddQueryTable();
        } else if (this.getState() == AddQueryTableCmd.getStateRedo()) {
            this.doForward();
        }
    }

    private void createAddQueryTable() {
        this.setCommandChain(CommandChainMgr.getInstance().getCommandChain());
        QueryTableFactory factory = new QueryTableFactory();
        this.newQueryTable = factory.createQueryTable(this.query, this.table);
        this.doForward();
    }

    public void doForward() {
        this.query.addQueryTable(this.newQueryTable);
    }

    @Override
    protected void undo() {
        this.query.removeQueryTable(this.newQueryTable);
    }

    @Override
    public Command duplicate() {
        AddQueryTableCmd cmdNew = new AddQueryTableCmd(this.query, this.table, this.newQueryTable);
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.cmdName;
        this.putValue("Name", CMD_NM);
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
    }
}

