/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db.query.command.direct.Column;

import com.harrand.coregui.command.Command;
import com.harrand.dbwrenchgui.db.query.diagram.glyph.table.QueryTableGlyph;
import com.harrand.dbwrenchgui.db.query.diagram.glyph.table.QueryTableGlyphExtractor;
import com.harrand.dbwrenchgui.db.query.diagram.refresh.RefreshTableGlyphs;
import com.harrand.dbwrenchgui.db.query.objects.query.DbQuery;
import com.harrand.dbwrenchgui.db.query.objects.query.QueryColumn;
import com.harrand.dbwrenchgui.db.query.objects.query.QueryTable;
import com.harrand.dbwrenchgui.db.query.objects.select.ISelectLineObj;
import com.harrand.sketch.core.Diagram;
import java.util.ArrayList;
import java.util.List;

public final class SelectAllQueryColumnsCmd
extends Command {
    private DbQuery query;
    private List<QueryTable> queryTables;
    private List<ISelectLineObj> previouslySelected = new ArrayList<ISelectLineObj>();
    private String cmdName;
    public static final String CMD_NM = "SELECT All Columns";
    private Diagram diagram;

    public SelectAllQueryColumnsCmd(QueryTable queryTable) {
        ArrayList<QueryTable> queryTablesL = new ArrayList<QueryTable>();
        queryTablesL.add(queryTable);
        this.init(queryTable.getQuery(), queryTablesL, new ArrayList<ISelectLineObj>());
    }

    public SelectAllQueryColumnsCmd(DbQuery query, List<QueryTable> queryTables) {
        this.init(query, queryTables, new ArrayList<ISelectLineObj>());
    }

    private SelectAllQueryColumnsCmd(DbQuery query, List<QueryTable> queryTables, List<ISelectLineObj> previouslySelected) {
        this.init(query, queryTables, previouslySelected);
    }

    private void init(DbQuery query, List<QueryTable> queryTables, List<ISelectLineObj> previouslySelected) {
        this.queryTables = queryTables;
        this.query = query;
        this.previouslySelected = previouslySelected;
        this.diagram = this.query.getDiagram();
        this.buildObject();
    }

    private void buildObject() {
        this.cmdName = CMD_NM;
        this.setProps();
    }

    @Override
    protected void execute() {
        if (this.getState() == SelectAllQueryColumnsCmd.getStateDo()) {
            this.doForward();
        } else if (this.getState() == SelectAllQueryColumnsCmd.getStateRedo()) {
            this.doForward();
        }
    }

    public void doForward() {
        for (QueryTable queryTable : this.queryTables) {
            for (QueryColumn queryCol : queryTable.getQueryColumns()) {
                if (this.isAlreadySelected(queryCol)) {
                    this.previouslySelected.add(queryCol);
                    continue;
                }
                this.query.addSelectObj(queryCol);
            }
        }
        this.refreshGlyphs();
        this.diagram.refresh();
    }

    private boolean isAlreadySelected(QueryColumn queryCol) {
        return this.query.getSelectLinesObjsMgr().getSelectLineObjs().contains(queryCol);
    }

    @Override
    protected void undo() {
        for (QueryTable queryTable : this.queryTables) {
            for (QueryColumn queryCol : queryTable.getQueryColumns()) {
                if (this.previouslySelected.contains(queryCol)) continue;
                this.query.removeSelectObj(queryCol);
            }
        }
        this.refreshGlyphs();
        this.diagram.refresh();
    }

    @Override
    public Command duplicate() {
        SelectAllQueryColumnsCmd cmdNew = new SelectAllQueryColumnsCmd(this.query, this.queryTables, this.previouslySelected);
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.cmdName;
        this.putValue("Name", CMD_NM);
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
    }

    private void refreshGlyphs() {
        List<QueryTableGlyph> glyphs = new QueryTableGlyphExtractor().getQueryTableGlyphs(this.diagram);
        new RefreshTableGlyphs().refresh(glyphs);
    }
}

