/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db.query.command.click.column;

import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coregui.Icons;
import com.harrand.coregui.command.Command;
import com.harrand.dbwrenchgui.db.query.calc.column.ColumnInSelectCalc;
import com.harrand.dbwrenchgui.db.query.command.direct.Column.AddSelectQueryColumnCmd;
import com.harrand.dbwrenchgui.db.query.command.direct.Column.RemoveSelectQueryColumnCmd;
import com.harrand.dbwrenchgui.db.query.objects.query.QueryColumn;
import com.harrand.sketch.command.clickAction.action.ClickActionSizeCalc;
import com.harrand.sketch.command.clickAction.action.IconClickAction;
import com.harrand.sketch.command.clickAction.mouse.ClickActionMouseCalc;

public final class QueryColumnIconClickAction
extends IconClickAction {
    private QueryColumn queryColumn;

    public QueryColumnIconClickAction(QueryColumn queryColumn, ClickActionSizeCalc sizeCalc, ClickActionMouseCalc mouseCalc) {
        super(sizeCalc, mouseCalc);
        this.queryColumn = queryColumn;
        this.setCommand();
        this.setImgs();
        super.setName(QueryColumnIconClickAction.createName(this.queryColumn.getColumn()));
    }

    private void setCommand() {
        Command cmdL = this.isInSelectAlready() ? this.getRemoveCmd() : this.getAddCmd();
        super.setCommand(cmdL);
    }

    private AddSelectQueryColumnCmd getAddCmd() {
        return new AddSelectQueryColumnCmd(this.queryColumn);
    }

    private RemoveSelectQueryColumnCmd getRemoveCmd() {
        return new RemoveSelectQueryColumnCmd(this.queryColumn);
    }

    private void setImgs() {
        super.setIconImg(Icons.getBufferedImage("CheckSmTrans"));
    }

    public static String createName(Identifiable idf) {
        return QueryColumnIconClickAction.class.getSimpleName() + "." + idf.getName();
    }

    private boolean isInSelectAlready() {
        return new ColumnInSelectCalc().isColumnInSelect(this.queryColumn);
    }
}

