/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db.query.command.click.column;

import com.harrand.dbwrenchgui.db.query.command.click.column.QueryColumnIconClickAction;
import com.harrand.dbwrenchgui.db.query.command.click.column.QueryColumnNameClickAction;
import com.harrand.dbwrenchgui.db.query.diagram.glyph.column.QueryColumnGlyph;
import com.harrand.dbwrenchgui.db.query.objects.query.QueryColumn;
import com.harrand.sketch.command.clickAction.action.ClickActionSizeCalc;
import com.harrand.sketch.command.clickAction.action.IClickAction;
import com.harrand.sketch.command.clickAction.bldr.IClickActionBldr;
import com.harrand.sketch.command.clickAction.draw.ClickActionPosCalc;
import com.harrand.sketch.command.clickAction.mouse.ClickActionMouseCalc;
import com.harrand.util.LogUtil;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;

public final class QueryColumnClickActionBldr
implements IClickActionBldr {
    private ClickActionSizeCalc sizeCalc;
    private ClickActionMouseCalc mouseCalc;
    private final QueryColumnGlyph queryColumnGlyph;
    private HashMap<String, IClickAction> CA_Map;
    private ClickActionPosCalc clickActionPosCalc = new ClickActionPosCalc();

    public QueryColumnClickActionBldr(QueryColumnGlyph queryColumnGlyph) {
        this.queryColumnGlyph = queryColumnGlyph;
    }

    @Override
    public void setSizeCalc(ClickActionSizeCalc sizeCalc) {
        this.sizeCalc = sizeCalc;
    }

    @Override
    public void setMouseCalc(ClickActionMouseCalc mouseCalc) {
        this.mouseCalc = mouseCalc;
    }

    @Override
    public Map<String, IClickAction> getClickActionsMap() {
        this.CA_Map = new HashMap();
        this.addQueryColumnIconClickAction();
        this.addQueryColumnNameClickAction();
        return this.CA_Map;
    }

    @Override
    public void clear() {
        LogUtil.logMsg("queryTableClickBldr .need to implement");
    }

    private void addQueryColumnIconClickAction() {
        QueryColumn queryColumn = this.getQueryColumn();
        QueryColumnIconClickAction clickAction = new QueryColumnIconClickAction(queryColumn, this.sizeCalc, this.mouseCalc);
        Point2D topLeft = this.getTopLeft();
        Point2D origin = this.clickActionPosCalc.getClickActionOriginFromGlyphImg(topLeft);
        clickAction.setOrigin(origin);
        this.putClickAction(clickAction);
    }

    private void addQueryColumnNameClickAction() {
        QueryColumnNameClickAction clickAction = new QueryColumnNameClickAction(this.getQueryColumn(), this.sizeCalc, this.mouseCalc);
        Point textOrigin = this.getNameOrigin();
        Point2D origin = this.clickActionPosCalc.getClickActionOriginFromCursor(textOrigin, this.getLineHeight());
        clickAction.setOrigin(origin);
        this.putClickAction(clickAction);
    }

    private QueryColumn getQueryColumn() {
        return this.queryColumnGlyph.getQueryColumn();
    }

    private Point getNameOrigin() {
        return this.queryColumnGlyph.getNameGlyph().getOrigin();
    }

    private void putClickAction(IClickAction clickAction) {
        this.CA_Map.put(clickAction.getName(), clickAction);
    }

    private Point2D getTopLeft() {
        return this.queryColumnGlyph.getLastSelectIconOrigin();
    }

    private double getLineHeight() {
        return this.queryColumnGlyph.getNameGlyph().getTextDrawable().getLineHeight();
    }
}

