/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db.query.bldr.from;

import com.harrand.dbwrenchgui.db.query.bldr.from.JoinOnPhraseBldr;
import com.harrand.dbwrenchgui.db.query.bldr.pair.JoinPairBldr;
import com.harrand.dbwrenchgui.db.query.objects.from.JoinPair;
import com.harrand.dbwrenchgui.db.query.objects.query.DbQuery;
import com.harrand.dbwrenchgui.db.query.objects.query.QueryTable;
import java.util.List;

public final class FromClauseBldr {
    public String buildFromClause(DbQuery query) {
        boolean isSingleTable;
        List<JoinPair> pairs = new JoinPairBldr().getJoinPairs(query);
        boolean isMultiTable = pairs.size() > 0;
        boolean bl = isSingleTable = query.getQueryTables().size() == 1;
        if (isMultiTable) {
            return this.buildMultiTable(pairs);
        }
        if (isSingleTable) {
            QueryTable queryTable = query.getQueryTables().get(0);
            return this.getFromLine(queryTable.getName());
        }
        return "";
    }

    private String buildMultiTable(List<JoinPair> pairs) {
        StringBuilder sb = new StringBuilder();
        for (JoinPair pair : pairs) {
            QueryTable rightQueryTable = pair.getRightQueryTable();
            QueryTable leftQueryTable = pair.getLeftQueryTable();
            String rightTableStr = rightQueryTable.getTableFromStr();
            String leftTableStr = leftQueryTable.getTableFromStr();
            if (sb.length() == 0) {
                sb.append(this.getFromLine(rightTableStr));
            }
            sb.append(this.getJoinLine(pair, leftTableStr));
        }
        return sb.toString();
    }

    private String getFromLine(String leftTableStr) {
        StringBuilder sb = new StringBuilder();
        sb.append("FROM ").append(leftTableStr).append("\n");
        return sb.toString();
    }

    private String getJoinLine(JoinPair joinPair, String leftTableStr) {
        StringBuilder sb = new StringBuilder("\tINNER JOIN ");
        sb.append(leftTableStr);
        sb.append(this.getOnStr(joinPair));
        return sb.toString();
    }

    private String getOnStr(JoinPair joinPair) {
        JoinOnPhraseBldr phraseBldr = new JoinOnPhraseBldr();
        return phraseBldr.getJoinOnPhrase(joinPair);
    }
}

