/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db.dataEdit;

import com.harrand.dbwrenchgui.db.DbValueWidgetGroup;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class WidgetFocusCtrl {
    private List<DbValueWidgetGroup> widgetGroups;

    public void setWidgetFocus(List<DbValueWidgetGroup> widgetGroups) {
        this.widgetGroups = widgetGroups;
        boolean requestedIsFocusable = this.isRequestedWidgetFocusable();
        if (requestedIsFocusable) {
            this.setFocusToRequested();
        } else {
            this.setFocusToFirstEnabled();
        }
    }

    private boolean isRequestedWidgetFocusable() {
        boolean focusable = true;
        for (DbValueWidgetGroup group : this.widgetGroups) {
            JComponent widget;
            if (!group.getWantsFocus() || !((widget = group.getEditWidget()) instanceof JTextField) || ((JTextField)widget).isEditable()) continue;
            focusable = false;
        }
        return focusable;
    }

    private void setFocusToRequested() {
        for (DbValueWidgetGroup group : this.widgetGroups) {
            if (!group.getWantsFocus()) continue;
            JComponent widget = group.getEditWidget();
            widget.grabFocus();
            if (!(widget instanceof JTextComponent)) continue;
            ((JTextComponent)widget).selectAll();
        }
    }

    private void setFocusToFirstEnabled() {
        for (DbValueWidgetGroup group : this.widgetGroups) {
            JComponent widget;
            if (!group.getWantsFocus() || !((widget = group.getEditWidget()) instanceof JTextField) || ((JTextField)widget).isEditable()) continue;
            widget.grabFocus();
        }
    }
}

