/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db;

import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.display.Colors;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coregui.helper.GuiHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class TransactionErrorPanel
extends JPanel
implements ISized,
ITitled {
    private JTextArea txtErr_;
    private JTextArea txtSql_;
    private JLabel lblTrans_ = new JLabel("An error was reported and the script's transaction will be rolled back.");
    private JLabel lblErr_ = new JLabel("The following error occured:");
    private JLabel lblSql_ = new JLabel("The error occured during execution of:");
    private String errMsg_;
    private String sql_;
    public static final int TXT_AREA_LINES = 6;

    public TransactionErrorPanel(String errMsg, String sql) {
        this.errMsg_ = errMsg;
        this.sql_ = sql;
        this.setupGui();
    }

    private void setupGui() {
        this.buildControls();
        this.buildPanel();
        this.setCosmetics();
        this.setNames();
    }

    private void buildControls() {
        this.txtErr_ = new JTextArea();
        this.setTextAreaProps(this.txtErr_);
        this.txtErr_.setText(this.errMsg_);
        this.txtSql_ = new JTextArea();
        this.setTextAreaProps(this.txtSql_);
        this.txtSql_.setText(this.sql_);
    }

    private void buildPanel() {
        JPanel iconPanel = GuiHelper.getIconSidePanel(UIManager.getIcon("OptionPane.warningIcon"));
        this.setLayout(new BorderLayout(4, 4));
        this.add((Component)iconPanel, "West");
        this.add((Component)this.getMainPanel(), "Center");
    }

    private JPanel getMainPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        panel.add(this.lblTrans_);
        panel.add(Box.createVerticalStrut(15));
        panel.add(this.lblErr_);
        panel.add(new JScrollPane(this.txtErr_));
        panel.add(Box.createVerticalStrut(15));
        panel.add(this.lblSql_);
        panel.add(new JScrollPane(this.txtSql_));
        return panel;
    }

    private void setTextAreaProps(JTextArea txtArea) {
        txtArea.setRows(6);
        txtArea.setLineWrap(true);
        txtArea.setWrapStyleWord(true);
        txtArea.setEditable(false);
        txtArea.setBackground(Colors.getGrayUltraLight());
    }

    private void setCosmetics() {
        GuiHelper.addBodyPanelBorder(this);
        GuiHelper.setBoldFont(this.lblTrans_);
        Font lblFont = this.lblSql_.getFont();
        this.txtErr_.setFont(lblFont);
        this.txtSql_.setFont(lblFont);
    }

    private void setNames() {
        this.txtErr_.setName("txtErr");
        this.txtSql_.setName("txtSql");
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(550, 400);
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getTitle() {
        return "Transaction Rollback";
    }

    @Override
    public String getToolTip() {
        return "Transaction Rollback";
    }
}

