/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db;

import com.harrand.coreclasses.db.DbDataResult;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.IRefreshable;
import com.harrand.coreclasses.list.AlphaNumericComparator;
import com.harrand.coreclasses.nb.CentralLookup;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coreclasses.text.QuickTimeFormat;
import com.harrand.coregui.Icons;
import com.harrand.coregui.display.Animator;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.image.IIconTabPane;
import com.harrand.coregui.jdesktop.swingworker.IThreadObserver;
import com.harrand.coregui.jdesktop.swingworker.SwingWorker;
import com.harrand.coregui.label.StatusLabel;
import com.harrand.coregui.panel.StatusPanel;
import com.harrand.coregui.table.TableModelBasic;
import com.harrand.coregui.table.TableSorter;
import com.harrand.dbwrench.db.BasicDbValue;
import com.harrand.dbwrench.db.JdbcDbTableCtrl;
import com.harrand.dbwrench.db.TableDataStore;
import com.harrand.dbwrench.jdbc.ConnMgr;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.db.DbRowEditPanel;
import com.harrand.dbwrenchgui.db.worker.edit.MultiDeleteWorker;
import com.harrand.dbwrenchgui.db.worker.edit.RowEditDlgDisplayWorker;
import com.harrand.dbwrenchgui.db.worker.sql.SqlWorker;
import com.harrand.util.MathUtil;
import com.harrand.util.ResMgr;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public final class TableDataPanel
extends JPanel
implements IObserver,
IThreadObserver,
IRefreshable {
    private Table table_;
    private JdbcConfig config_;
    private ConnMgr connMgr_ = ConnMgr.getInstance();
    private TableDataStore dataStore_ = TableDataStore.getInstance();
    private RowEditDlgDisplayWorker rowEditDlgDisplayWorker;
    private DbRowEditPanel editPanel_;
    private JdbcDbTableCtrl tableCtrl_ = null;
    private JTable dataGrid_;
    private JScrollPane scrTable_;
    private IOptionMgr resultGridOptMgr_ = null;
    private TableSorter sorter_ = new TableSorter();
    private int gridColWidthMax_ = 300;
    private boolean nullAsBlank_ = false;
    private Animator animatorRefresh_ = new Animator();
    private Animator animatorInsUpd_ = new Animator();
    private long start;
    private int lastSelectedRow;
    private DefaultTableModel blankTableModel_ = GuiHelper.getBlankTableModel();
    private StatusLabel readyStatus_;
    private StatusLabel rowsStatus_;
    private StatusLabel elapsedStatus_;
    private StatusPanel statusPanel_;
    private String invalidTitle_ = ResMgr.getRes("err.title.invalid.selection");
    private JButton btnRefresh_ = new JButton(ResMgr.getRes("refresh.label"));
    private JButton btnInsert_ = new JButton(ResMgr.getRes("insert.label"));
    private JButton btnUpdate_ = new JButton(ResMgr.getRes("update.label"));
    private JButton btnDelete_ = new JButton(ResMgr.getRes("delete.label"));
    private ActionListener lisInsert_;
    private ActionListener lisUpdate_;
    private ActionListener lisDelete_;
    private ActionListener lisRefresh_;
    private SwingThemeCtrl themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
    public static String OPENING_EDITOR = "Opening editor panel...";

    public TableDataPanel(Table table) {
        this.setupGui();
        this.setTable(table);
        this.connMgr_.addObserver(this);
        CentralLookup.getDefault().addObserver(this);
    }

    private void createRowEditDlgDisplayWorker() {
        this.rowEditDlgDisplayWorker = new RowEditDlgDisplayWorker(this.table_, this.readyStatus_, this.animatorInsUpd_, this);
    }

    public void clear() {
        this.dataStore_.clear();
        this.clearStatusBar();
        this.setEmptyTable();
    }

    private void loadConfig() {
        boolean hasChanged;
        boolean isFirstCfg = this.config_ == null;
        JdbcConfig config = this.getConfig();
        boolean bl = hasChanged = !MathUtil.isEquivalent(this.config_, config);
        if (this.isConfigSet()) {
            this.tableCtrl_ = new JdbcDbTableCtrl(this.getDatabase(), this.table_, this.config_);
            this.tableCtrl_.setThreadObserver(this);
        } else {
            this.tableCtrl_ = null;
        }
        this.setConfig(config);
        if (hasChanged) {
            this.enableButtons();
            if (!isFirstCfg) {
                this.refresh();
            }
        }
    }

    public void setConfig(JdbcConfig config) {
        this.config_ = config;
        if (this.tableCtrl_ != null) {
            this.tableCtrl_.setConfig(this.config_);
        }
    }

    public void setGridOptionMgr(IOptionMgr resultGridOptMgr) {
        this.resultGridOptMgr_ = resultGridOptMgr;
        if (this.resultGridOptMgr_ instanceof IObservable) {
            ((IObservable)((Object)this.resultGridOptMgr_)).addObserver(this);
        }
    }

    public void setIconTabPane(IIconTabPane iconTabPane, int tabPos) {
        this.animatorRefresh_.setIconTabPane(iconTabPane, tabPos);
    }

    public Table getTable() {
        return this.table_;
    }

    @Override
    public void refresh() {
        if (this.isConfigSet()) {
            this.refreshDataGrid();
        } else {
            this.setEmptyTable();
        }
    }

    public void ensureDataPresent() {
        if (!this.hasDataStored()) {
            this.refresh();
        }
    }

    private boolean hasDataStored() {
        Object[][] data = this.dataStore_.getData(this.table_);
        boolean stored = data != null;
        return stored;
    }

    private void loadDataIntoGrid() {
        if (this.hasDataStored()) {
            Object[][] data = this.dataStore_.getData(this.table_);
            if (this.sorter_ == null) {
                this.sorter_ = new TableSorter();
            }
            this.dataGrid_.setModel(this.sorter_);
            this.sorter_.setTableHeader(this.dataGrid_.getTableHeader());
            this.sorter_.setColumnComparator(String.class, new AlphaNumericComparator());
            this.sorter_.setDbWrColumnComparatorMap(this.tableCtrl_.getColumnComparators());
            TableModelBasic tableModel = GuiHelper.getTableModel(data, this.nullAsBlank_);
            tableModel.setEditable(false);
            this.sorter_.setTableModel(tableModel);
            GuiHelper.optimizeTableColumnWidths(this.dataGrid_, this.gridColWidthMax_);
            this.rowsStatus_.setText(this.getRowCountText());
        } else {
            this.setEmptyTable();
        }
        this.enableButtons();
    }

    private void refreshDataGrid() {
        this.lastSelectedRow = this.dataGrid_.getSelectedRow();
        this.start = System.currentTimeMillis();
        this.setEmptyTable();
        this.tableCtrl_.setDisabledBtn(this.btnRefresh_);
        this.tableCtrl_.setStatusLabel(this.readyStatus_);
        this.tableCtrl_.startGetTableData();
    }

    private void enableButtons() {
        boolean hasData;
        boolean configValid = this.isConfigSet();
        boolean bl = hasData = this.dataGrid_.getRowCount() > 0;
        if (configValid) {
            this.btnRefresh_.setToolTipText(ResMgr.getRes("refresh.data"));
            this.btnInsert_.setToolTipText(ResMgr.getRes("insert.db.record"));
        } else {
            String configReq = ResMgr.getRes("connection.db.required");
            this.btnRefresh_.setToolTipText(configReq);
            this.btnInsert_.setToolTipText(configReq);
        }
        this.btnRefresh_.setEnabled(configValid);
        this.btnInsert_.setEnabled(configValid);
        this.btnUpdate_.setEnabled(hasData);
        this.btnDelete_.setEnabled(hasData);
    }

    private void setEmptyTable() {
        this.dataGrid_.setModel(this.blankTableModel_);
    }

    private JdbcConfig getConfig() {
        return this.connMgr_.getCurrentCfg();
    }

    private Database getDatabase() {
        return LookupUtil.findDb();
    }

    public void setTable(Table table) {
        this.table_ = table;
        this.sorter_ = null;
        this.clearStatusBar();
        this.loadConfig();
        this.loadDataIntoGrid();
    }

    private void setupGui() {
        this.layoutComponents();
        this.setCosmetics();
        this.setNames();
        this.buildListeners();
        this.addListeners();
        this.enableButtons();
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout(4, 4));
        this.buildStatusPanel();
        this.add((Component)this.getGridPanel(), "Center");
        this.add((Component)this.getButtonPanel(), "East");
        this.add((Component)this.statusPanel_, "South");
    }

    private JPanel getGridPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.dataGrid_ = new JTable(this.blankTableModel_);
        this.dataGrid_.setAutoResizeMode(0);
        this.scrTable_ = new JScrollPane(this.dataGrid_);
        panel.add((Component)this.scrTable_, "Center");
        panel.setBorder(GuiHelper.getEmptyBorder());
        this.themeCtrl_.process(this.scrTable_);
        this.themeCtrl_.process(panel);
        return panel;
    }

    private void buildStatusPanel() {
        this.readyStatus_ = new StatusLabel(60, StrHelper.READY_STR, null);
        this.rowsStatus_ = new StatusLabel(20, this.getRowCountText(), null);
        this.elapsedStatus_ = new StatusLabel(20, StrHelper.getElapseTimeText(-1L), Icons.CLOCK);
        this.animatorRefresh_.setTimeLabel(this.elapsedStatus_);
        this.animatorInsUpd_.setIconLabel(this.readyStatus_);
        ArrayList<StatusLabel> labels = new ArrayList<StatusLabel>();
        labels.add(this.readyStatus_);
        labels.add(this.rowsStatus_);
        labels.add(this.elapsedStatus_);
        this.statusPanel_ = new StatusPanel(labels);
    }

    private void clearStatusBar() {
        this.readyStatus_.setText(StrHelper.READY_STR);
        this.elapsedStatus_.setText(StrHelper.getElapseTimeText(-1L));
        this.rowsStatus_.setText(GuiHelper.getRowCountText(null));
    }

    private JPanel getButtonPanel() {
        Dimension gap = new Dimension(0, 5);
        JPanel panButtons = new JPanel();
        panButtons.setLayout(new BoxLayout(panButtons, 3));
        panButtons.add(this.btnRefresh_);
        panButtons.add(Box.createRigidArea(gap));
        panButtons.add(this.btnInsert_);
        panButtons.add(Box.createRigidArea(gap));
        panButtons.add(this.btnUpdate_);
        panButtons.add(Box.createRigidArea(gap));
        panButtons.add(this.btnDelete_);
        panButtons.add(Box.createVerticalGlue());
        int EDGE = 4;
        panButtons.setBorder(GuiHelper.getEmptyBorder());
        this.themeCtrl_.process(panButtons);
        return panButtons;
    }

    private void buildListeners() {
        this.lisInsert_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableDataPanel.this.showInsert();
            }
        };
        this.lisUpdate_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableDataPanel.this.showUpdate();
            }
        };
        this.lisDelete_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableDataPanel.this.showDelete();
            }
        };
        this.lisRefresh_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableDataPanel.this.refresh();
            }
        };
    }

    private void addListeners() {
        this.btnInsert_.addActionListener(this.lisInsert_);
        this.btnUpdate_.addActionListener(this.lisUpdate_);
        this.btnDelete_.addActionListener(this.lisDelete_);
        this.btnRefresh_.addActionListener(this.lisRefresh_);
        this.dataGrid_.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TableDataPanel.this.showUpdate();
                }
            }
        });
    }

    private void setCosmetics() {
        this.themeCtrl_.process(this.scrTable_);
        this.themeCtrl_.process(this);
        this.btnInsert_.setMnemonic('I');
        this.btnUpdate_.setMnemonic('U');
        this.btnDelete_.setMnemonic('D');
        this.btnRefresh_.setMnemonic('R');
        this.btnUpdate_.setToolTipText(ResMgr.getRes("update.selected.record"));
        this.btnDelete_.setToolTipText(ResMgr.getRes("delete.selected.record"));
        this.sizeButtons();
    }

    private void sizeButtons() {
        Dimension commonSize = this.btnRefresh_.getMinimumSize();
        this.btnInsert_.setMaximumSize(commonSize);
        this.btnUpdate_.setMaximumSize(commonSize);
        this.btnDelete_.setMaximumSize(commonSize);
    }

    private void setNames() {
        this.dataGrid_.setName("dataGrid");
    }

    private void showInsert() {
        this.createRowEditDlgDisplayWorker();
        this.rowEditDlgDisplayWorker.displayDialog(null, 0);
    }

    private void showUpdate() {
        if (this.isConfigSet() && this.checkPkSet()) {
            int selectCount = this.dataGrid_.getSelectedRowCount();
            int selRow = this.dataGrid_.getSelectedRow();
            int selColumn = this.dataGrid_.getSelectedColumn();
            if (selectCount == 1 && selRow < this.dataGrid_.getRowCount()) {
                this.createRowEditDlgDisplayWorker();
                Map currentRowValues = this.getRowValues(selRow);
                this.rowEditDlgDisplayWorker.displayDialog(currentRowValues, selColumn);
            } else {
                String msg = ResMgr.getRes("err.table.row.only.one.selected");
                GuiMessageHelper.showInputErrMsg(null, this.invalidTitle_, msg);
            }
        }
    }

    private boolean checkPkSet() {
        boolean pkSet = true;
        if (this.table_.getPrimaryKey() == null) {
            pkSet = false;
            GuiMessageHelper.showInputErrMsg(null, "Primary Key Required", "Records can only be updated in tables that have primary keys defined.");
        }
        return pkSet;
    }

    private void addWindowAdapter(JDialog dlg) {
        WindowAdapter adapter = new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                TableDataPanel.this.editPanel_.setWidgetFocus();
            }
        };
        dlg.addWindowListener(adapter);
    }

    private void showDelete() {
        if (this.isConfigSet()) {
            if (this.dataGrid_.getSelectedRowCount() > 0) {
                String msg = ResMgr.getRes("delete.confirm.db.records.msg");
                boolean response = GuiMessageHelper.showYesNoMsg(null, "Confirm Remove", msg);
                if (response) {
                    this.doDeleteDisp();
                }
            } else {
                String msg = ResMgr.getRes("err.msg.table.row.not.selected");
                GuiMessageHelper.showInputErrMsg(null, this.invalidTitle_, msg);
            }
        }
    }

    private void doDeleteDisp() {
        ArrayList<Map> valuesMap = new ArrayList<Map>();
        int[] selRows = this.dataGrid_.getSelectedRows();
        for (int i = 0; i < selRows.length; ++i) {
            Map values = this.getRowValues(selRows[i]);
            valuesMap.add(values);
        }
        MultiDeleteWorker multiDeleteWorker = new MultiDeleteWorker(this.table_, this.readyStatus_, this.animatorInsUpd_, this);
        multiDeleteWorker.deleteMany(valuesMap);
    }

    private void updateOptions() {
        this.nullAsBlank_ = this.resultGridOptMgr_.getBoolValue("results.null.as.blank");
        this.gridColWidthMax_ = this.resultGridOptMgr_.getIntValue("results.grid.col.max.width");
    }

    private Map getRowValues(int row) {
        HashMap<String, BasicDbValue> valueMap = new HashMap<String, BasicDbValue>();
        JdbcConfig config = this.getConfig();
        for (Column column : this.table_.values(Column.getClassName())) {
            Object objOut;
            String columnName = config.getDbms().supportsMixedCase() ? column.getName() : column.getName().toLowerCase();
            int colIdx = GuiHelper.getColumnIndexInsensitive(this.dataGrid_, columnName);
            if (colIdx < 0 && (colIdx = GuiHelper.getColumnIndex(this.dataGrid_, columnName.toLowerCase())) < 0) {
                System.out.println("TableDataPanel no column match for: " + columnName);
            }
            Object obj = objOut = this.dataGrid_.getValueAt(row, colIdx);
            obj = this.checkMySqlBoolInt(column, objOut);
            BasicDbValue dbValue = obj.toString().equals(StrHelper.NULL_STR_UC) ? new BasicDbValue(column, null, false) : (obj instanceof String ? new BasicDbValue(column, obj.toString()) : new BasicDbValue(column, obj, false));
            valueMap.put(dbValue.getName(), dbValue);
        }
        return valueMap;
    }

    private Object checkMySqlBoolInt(Column column, Object dataValue) {
        Object retObj = dataValue;
        String str = dataValue.toString();
        if (column.getDataType().isBooleanLikeType() && StrHelper.isInteger(str)) {
            int intValue = Integer.parseInt(str);
            retObj = intValue == 0 ? new Boolean(false) : new Boolean(true);
        }
        return retObj;
    }

    private String getRowCountText() {
        return GuiHelper.getRowCountText(this.dataGrid_);
    }

    public boolean isConfigSet() {
        return this.getConfig() != null;
    }

    @Override
    public void update(UpdateChain chain) {
        if (chain.hasInteface(IOptionMgr.class.getName())) {
            this.updateOptions();
        }
        if (chain.hasClassName(ConnMgr.class.getName())) {
            this.clear();
            this.setConfig(this.getConfig());
        }
        if (chain.hasClassName(CentralLookup.class.getName()) && chain.hasClassName(Database.class.getName())) {
            this.clear();
        }
    }

    @Override
    public void threadDone(SwingWorker threadWorker) {
        SqlWorker sqlWorker = (SqlWorker)threadWorker;
        DbDataResult dataResult = (DbDataResult)sqlWorker.getResult();
        long elapsed = System.currentTimeMillis() - this.start;
        if (dataResult.getPassed()) {
            Object[][] data = dataResult.getData();
            this.dataStore_.setData(this.table_, data);
            this.loadDataIntoGrid();
        } else {
            this.sorter_ = null;
            this.setEmptyTable();
            GuiMessageHelper.showWarningMsg(null, dataResult.getSummary(), dataResult.getDetail());
        }
        if (this.lastSelectedRow > 0 && this.lastSelectedRow <= this.dataGrid_.getRowCount()) {
            this.dataGrid_.getSelectionModel().setSelectionInterval(this.lastSelectedRow, this.lastSelectedRow);
        }
        this.rowsStatus_.setText(this.getRowCountText());
        this.elapsedStatus_.setText(QuickTimeFormat.msToSecs(elapsed));
    }
}

