/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.db.SqlKeywords;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.dbwrench.script.converter.MsAccessDataTypeConverter;
import com.harrand.dbwrench.script.converter.MsSqlServerDataTypeConverter;
import com.harrand.dbwrench.script.converter.MySqlDataTypeConverter;
import com.harrand.dbwrench.script.converter.PostgreSqlDataTypeConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

@Deprecated
public class SqlReservedWordGui {
    private static SqlReservedWordGui ref__ = null;
    private List reservedWords_ = null;
    private final List<String> reservedWordsLowerCase = new ArrayList<String>();
    private String lastWordChecked = "";

    private SqlReservedWordGui() {
        HashSet<String> wordsSet = new HashSet<String>(Arrays.asList(SqlKeywords.KEYWORDS));
        wordsSet.addAll(Arrays.asList(MySqlDataTypeConverter.RESERVED_WORDS));
        wordsSet.addAll(Arrays.asList(MsAccessDataTypeConverter.RESERVED_WORDS));
        wordsSet.addAll(Arrays.asList(MsSqlServerDataTypeConverter.RESERVED_WORDS));
        wordsSet.addAll(Arrays.asList(PostgreSqlDataTypeConverter.RESERVED_WORDS));
        this.reservedWords_ = new ArrayList<String>(wordsSet);
        Collections.sort(this.reservedWords_);
        this.buildLowerCaseList();
    }

    public static SqlReservedWordGui instance() {
        if (ref__ == null) {
            ref__ = new SqlReservedWordGui();
        }
        return ref__;
    }

    public List<String> getReservedWordsLowerCase() {
        return this.reservedWordsLowerCase;
    }

    public boolean isReserved(String word) {
        return this.reservedWordsLowerCase.contains(word.toLowerCase());
    }

    public ITestResult warnIfReserved(String word) {
        DataEntryResult result = new DataEntryResult(true);
        if (this.lastWordChecked.equalsIgnoreCase(word)) {
            return result;
        }
        if (this.isReserved(word)) {
            String msg = "'" + word + "' may be a reserved word in some " + "database systems.\nUsing reserved words " + "as entity names can be problematic.";
            String title = "Warning - Reserved Word";
            result = new DataEntryResult(false, title, msg);
            GuiMessageHelper.showOptionPaneMsg(null, title, msg, 2);
        }
        this.lastWordChecked = word;
        return result;
    }

    private void buildLowerCaseList() {
        for (Object wordObj : this.reservedWords_) {
            this.reservedWordsLowerCase.add(wordObj.toString().toLowerCase());
        }
    }
}

