/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coregui.jdesktop.swingworker.IThreadObserver;
import com.harrand.coregui.jdesktop.swingworker.SwingWorker;
import com.harrand.dbwrench.db.BasicDbValue;
import com.harrand.dbwrench.db.IDbValue;
import com.harrand.dbwrench.db.JdbcDbTableCtrl;
import com.harrand.dbwrench.db.JdbcRowCtrl;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.db.DbValueWidgetGroup;
import com.harrand.util.LogUtil;
import com.harrand.util.MathUtil;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;

public final class DbRowEditPanelCtrl
implements IThreadObserver {
    private Database db_;
    private Table table_;
    private JdbcConfig config_;
    private JdbcRowCtrl rowCtrl_;
    private JdbcDbTableCtrl tableCtrl_ = null;
    private List widgetGroups_;
    private JButton disabledBtn;
    private JLabel statusLbl;
    private ITestResult sqlCmdResult;
    private IThreadObserver externalThreadObserver;
    private int selectedGridCol;
    public static final int PREFERRED_WIDTH = 350;

    public DbRowEditPanelCtrl(Database db, Table table, JdbcConfig config) {
        this.db_ = db;
        this.table_ = table;
        this.setConfig(config);
        this.buildWidgetGroups();
    }

    public void setConfig(JdbcConfig config) {
        boolean hasChanged = !MathUtil.isEquivalent(this.config_, config);
        this.config_ = config;
        if (this.rowCtrl_ == null) {
            this.rowCtrl_ = new JdbcRowCtrl(this.table_, this.config_, new HashMap());
            this.rowCtrl_.setDisabledBtn(this.disabledBtn);
            this.rowCtrl_.setStatusLabel(this.statusLbl);
            this.rowCtrl_.setThreadObserver(this);
        } else {
            this.rowCtrl_.setConfig(this.config_);
        }
        this.tableCtrl_ = this.isConfigSet() ? new JdbcDbTableCtrl(this.db_, this.table_, this.config_) : null;
        if (hasChanged) {
            this.buildWidgetGroups();
        }
    }

    public void setCurrentValues(Map currentValues) {
        this.rowCtrl_.setCurrentValues(currentValues);
        this.buildWidgetGroups();
    }

    public void setSelectedGridColumn(int selectedGridCol) {
        this.selectedGridCol = selectedGridCol;
    }

    public int getSelectedGridCol() {
        return this.selectedGridCol;
    }

    public ITestResult getSqlCmdResult() {
        return this.sqlCmdResult;
    }

    public void setDisabledBtn(JButton disabledBtn) {
        this.disabledBtn = disabledBtn;
    }

    public void setStatusLabel(JLabel statusLbl) {
        this.statusLbl = statusLbl;
    }

    public void setThreadObserver(IThreadObserver threadObserver) {
        this.externalThreadObserver = threadObserver;
    }

    public Map getCurrentValues() {
        return this.rowCtrl_.getCurrentValues();
    }

    public Object getCurrentValue(String columnName) {
        return this.rowCtrl_.getCurrentValue(columnName);
    }

    public List getWidgetGroups() {
        return this.widgetGroups_;
    }

    public void resetWidgets() {
        for (DbValueWidgetGroup group : this.widgetGroups_) {
            group.reset();
        }
    }

    public Rectangle getPreferredBounds() {
        int totalHeight = 0;
        for (int i = 0; i < this.widgetGroups_.size(); ++i) {
            DbValueWidgetGroup group = (DbValueWidgetGroup)this.widgetGroups_.get(i);
            int height = group.getHeight();
            totalHeight += height;
        }
        return new Rectangle(350, totalHeight);
    }

    public ITestResult startInsert() {
        ITestResult result = this.validateGuiValues();
        if (result.getPassed()) {
            Map newDbValues = this.getGuiDbValues();
            Integer newIdObj = new Integer(-1);
            this.rowCtrl_.setDisabledBtn(this.disabledBtn);
            result = this.rowCtrl_.startRowInsert(newDbValues, newIdObj);
        }
        return result;
    }

    public ITestResult startUpdate() {
        ITestResult result = this.validateGuiValues();
        if (result.getPassed()) {
            Map newDbValues = this.getGuiDbValues();
            this.rowCtrl_.setDisabledBtn(this.disabledBtn);
            result = this.rowCtrl_.startRowUpdate(newDbValues);
        }
        return result;
    }

    public ITestResult startDelete() {
        this.rowCtrl_.setDisabledBtn(this.disabledBtn);
        ITestResult result = this.rowCtrl_.startRowDelete();
        return result;
    }

    public String getInsertSql() {
        Map newDbValues = this.getGuiDbValues();
        String sql = this.rowCtrl_.getInsertSql(newDbValues);
        return sql;
    }

    public String getUpdateSql() {
        Map newDbValues = this.getGuiDbValues();
        String sql = this.rowCtrl_.getUpdateSql(newDbValues);
        return sql;
    }

    public String getDeleteSql() {
        String sql = this.rowCtrl_.getDeleteSql();
        return sql;
    }

    private void buildWidgetGroups() {
        this.widgetGroups_ = new ArrayList();
        int i = 0;
        for (Column column : this.table_.values(Column.getClassName())) {
            String colName = column.getName();
            Object valueObj = this.getCurrentValue(colName);
            BasicDbValue dbValue = new BasicDbValue(column, valueObj, false);
            List domainValues = this.tableCtrl_ != null ? this.tableCtrl_.getDomainValues(colName) : null;
            DbValueWidgetGroup widgetGroup = new DbValueWidgetGroup(dbValue, domainValues);
            this.widgetGroups_.add(widgetGroup);
            if (i == this.selectedGridCol) {
                widgetGroup.setWantsFocus(true);
            }
            ++i;
        }
    }

    private Map getGuiDbValues() {
        LinkedHashMap<String, IDbValue> guiDbValues = new LinkedHashMap<String, IDbValue>();
        for (DbValueWidgetGroup widgetGroup : this.getWidgetGroups()) {
            IDbValue newDbValue = widgetGroup.getCurrentDbValue();
            if (newDbValue == null) {
                LogUtil.logErr("DbRowEditPanelCtrl.widgetGroup: " + widgetGroup.getName() + " has NULL dbValue");
            }
            guiDbValues.put(widgetGroup.getName(), newDbValue);
        }
        return guiDbValues;
    }

    private ITestResult validateGuiValues() {
        DataEntryResult result = new DataEntryResult(true);
        StringBuffer sb = new StringBuffer();
        for (DbValueWidgetGroup widgetGroup : this.getWidgetGroups()) {
            ITestResult widgetResult = widgetGroup.validateCurrentValue();
            if (widgetResult.getPassed()) continue;
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(widgetResult.getDetail());
        }
        if (sb.length() > 0) {
            result = new DataEntryResult(false, sb.toString());
        }
        return result;
    }

    public boolean isConfigSet() {
        return this.config_ != null;
    }

    @Override
    public void threadDone(SwingWorker threadWorker) {
        this.sqlCmdResult = this.rowCtrl_.getSqlCmdResult();
        this.externalThreadObserver.threadDone(threadWorker);
    }
}

