/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db;

import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.text.scanner.BasicKeywordScanner;
import com.harrand.coregui.Icons;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.jdesktop.swingworker.IThreadObserver;
import com.harrand.coregui.jdesktop.swingworker.SwingWorker;
import com.harrand.coregui.label.StatusLabel;
import com.harrand.coregui.panel.StatusPanel;
import com.harrand.coregui.panel.XpHeaderPanel;
import com.harrand.coregui.text.TextPanel;
import com.harrand.dbwrench.jdbc.IDataType;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrenchgui.db.DbRowEditPanelCtrl;
import com.harrand.dbwrenchgui.db.DbValueWidgetGroup;
import com.harrand.dbwrenchgui.db.dataEdit.WidgetFocusCtrl;
import com.harrand.util.ResMgr;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class DbRowEditPanel
extends JPanel
implements ISized,
IThreadObserver {
    private DbRowEditPanelCtrl panelCtrl_;
    private XpHeaderPanel header_;
    private Database db_;
    private Table table_;
    private int mode_;
    private JdbcConfig config_;
    private JDialog parentDlg_;
    private boolean dataChanged_ = false;
    private boolean isAnInsert;
    private JTabbedPane tabPane_ = new JTabbedPane(3);
    private JButton btnInsert_ = new JButton(ResMgr.getRes("insert.label"));
    private JButton btnUpdate_ = new JButton(ResMgr.getRes("update.label"));
    private JButton btnDelete_ = new JButton(ResMgr.getRes("delete.label"));
    private JButton btnReset_ = new JButton(ResMgr.getRes("reset.label"));
    private JButton btnClose_ = new JButton(ResMgr.getRes("close"));
    private TextPanel txtSqlPreview_;
    private TextPanel txtLog_;
    private StatusLabel readyStatusLbl_;
    private StatusLabel serverStatusLbl_;
    private StatusPanel statusPanel_;
    private ActionListener lisInsert_;
    private ActionListener lisUpdate_;
    private ActionListener lisDelete_;
    private ActionListener lisReset_;
    private ActionListener lisClose_;
    private ChangeListener lisTab_;
    private SwingThemeCtrl themeCtrl_;
    public static final int PREFERRED_WIDTH = 625;
    public static final int INSERT_MODE = 0;
    public static final int UPDATE_MODE = 1;
    private static final int SQL_PREVIEW_IDX = 1;

    public DbRowEditPanel(Database db, Table table, Map currentValues, JdbcConfig config, int selectedGridCol) {
        this.db_ = db;
        this.table_ = table;
        this.config_ = config;
        this.calcMode(currentValues);
        this.panelCtrl_ = new DbRowEditPanelCtrl(this.db_, this.table_, null);
        this.setSelectedGridColumn(selectedGridCol);
        this.panelCtrl_.setConfig(this.config_);
        this.panelCtrl_.setCurrentValues(currentValues);
        this.themeCtrl_ = App.getThemeCtrl();
        this.setupGui();
        this.panelCtrl_.setStatusLabel(this.readyStatusLbl_);
        this.panelCtrl_.setThreadObserver(this);
    }

    public void setSelectedGridColumn(int selectedGridCol) {
        this.panelCtrl_.setSelectedGridColumn(selectedGridCol);
    }

    public int getSelectedGridCol() {
        return this.panelCtrl_.getSelectedGridCol();
    }

    public void setParentDialog(JDialog parentDlg) {
        this.parentDlg_ = parentDlg;
        this.addParentListeners();
    }

    public boolean getDataChanged() {
        return this.dataChanged_;
    }

    private void setDataChanged(boolean dataChanged) {
        this.dataChanged_ = dataChanged;
    }

    private void calcMode(Map currentValues) {
        this.mode_ = currentValues == null || currentValues.isEmpty() ? 0 : 1;
    }

    private void setReadyStatus() {
        this.readyStatusLbl_.setText(StrHelper.READY_STR);
    }

    private void setupGui() {
        this.layoutComponents();
        this.setCosmetics();
        this.setNames();
        this.buildListeners();
        this.addListeners();
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        this.buildStatusPanel();
        this.header_ = new XpHeaderPanel("Table: " + this.table_.getName(), null);
        JPanel mainPanel = new JPanel(new BorderLayout(0, 4));
        mainPanel.add((Component)this.header_, "North");
        mainPanel.add((Component)this.getTabPanel(), "Center");
        mainPanel.add((Component)this.getSouthPanel(), "South");
        this.add((Component)mainPanel, "Center");
        this.add((Component)this.statusPanel_, "South");
    }

    private JPanel getSouthPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(new JSeparator());
        panel.add(this.getButtonPanel());
        return panel;
    }

    private JPanel getTabPanel() {
        JPanel panel = new JPanel(new BorderLayout(0, 4));
        this.tabPane_.addTab(ResMgr.getRes("edit.record.title"), this.getEditPanel());
        this.tabPane_.addTab("SQL Text", this.getSqlPreviewPanel());
        this.tabPane_.addTab(ResMgr.getRes("session.log.title"), this.getLogPanel());
        panel.add((Component)this.tabPane_, "Center");
        GuiHelper.addMedBorder(panel);
        return panel;
    }

    private void buildStatusPanel() {
        this.readyStatusLbl_ = new StatusLabel(25, StrHelper.READY_STR, null);
        this.serverStatusLbl_ = new StatusLabel(25, this.config_.getServer(), Icons.SERVER);
        StatusLabel dbStatus = new StatusLabel(25, this.db_.getName(), Icons.DATABASE);
        StatusLabel tabStatus = new StatusLabel(25, this.table_.getName(), Icons.TABLE);
        this.serverStatusLbl_.setToolTipText(ResMgr.getRes("server.label"));
        dbStatus.setToolTipText(App.getRes("database.label"));
        tabStatus.setToolTipText(App.getRes("table.label"));
        ArrayList<StatusLabel> labels = new ArrayList<StatusLabel>();
        labels.add(this.readyStatusLbl_);
        labels.add(this.serverStatusLbl_);
        labels.add(dbStatus);
        labels.add(tabStatus);
        this.statusPanel_ = new StatusPanel(labels, true);
    }

    private JPanel getSqlPreviewPanel() {
        this.txtSqlPreview_ = new TextPanel("");
        this.txtSqlPreview_.setKeywordScanner(new BasicKeywordScanner(new String[]{"note", "error", "err"}, "Error"));
        this.txtSqlPreview_.setEditable(false);
        JPanel sqlPreviewPanel = new JPanel();
        sqlPreviewPanel.setLayout(new BorderLayout(4, 4));
        GuiHelper.addEmptyBorder(sqlPreviewPanel);
        JLabel lblTitle = GuiHelper.getTitleLabel("SQL Text");
        sqlPreviewPanel.add((Component)lblTitle, "North");
        sqlPreviewPanel.add((Component)this.txtSqlPreview_, "Center");
        this.themeCtrl_.process(sqlPreviewPanel);
        return sqlPreviewPanel;
    }

    private JPanel getLogPanel() {
        this.txtLog_ = new TextPanel("");
        this.txtLog_.setKeywordScanner(new BasicKeywordScanner(new String[]{"note", "error", "err"}, "Error"));
        this.txtLog_.setEditable(false);
        JPanel logPanel = new JPanel();
        logPanel.setLayout(new BorderLayout(4, 4));
        GuiHelper.addEmptyBorder(logPanel);
        JLabel lblTitle = GuiHelper.getTitleLabel(ResMgr.getRes("session.log.title"));
        logPanel.add((Component)lblTitle, "North");
        logPanel.add((Component)this.txtLog_, "Center");
        this.themeCtrl_.process(logPanel);
        return logPanel;
    }

    private JPanel getEditPanel() {
        JPanel editPanel = new JPanel();
        JPanel widgetNorthPanel = new JPanel(new BorderLayout());
        widgetNorthPanel.add((Component)this.getWidgetPanel(), "North");
        JScrollPane scrollPane = new JScrollPane(widgetNorthPanel, 20, 31);
        scrollPane.setBorder(null);
        scrollPane.getVerticalScrollBar().setUnitIncrement(10);
        GuiHelper.addEmptyBorder(editPanel);
        editPanel.setLayout(new BorderLayout());
        editPanel.add((Component)scrollPane, "Center");
        this.themeCtrl_.process(editPanel);
        return editPanel;
    }

    private JPanel getWidgetPanel() {
        JPanel widgetPanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        widgetPanel.setLayout(gbl);
        int row = 0;
        List widgetGroups = this.panelCtrl_.getWidgetGroups();
        for (DbValueWidgetGroup group : widgetGroups) {
            boolean fullWidth;
            JLabel lblName = group.getNameLabel();
            JLabel lblToolTip = group.getTooltipLabel();
            lblName.setToolTipText(lblToolTip.getText());
            JComponent widget = group.getEditWidget();
            Column column = this.table_.getColumn(group.getName());
            IDataType dataType = column.getDataType();
            boolean isNumeric = dataType.isNumberLikeType();
            boolean isEnum = dataType.getId() == 706;
            boolean isFkCol = this.table_.getIsFkCol(column.getName());
            boolean bl = fullWidth = !isNumeric && !isEnum && !isFkCol;
            if (widget instanceof JTextArea) {
                JScrollPane scr = new JScrollPane(widget);
                GuiHelper.addGridbagPair(lblName, scr, gbc, widgetPanel, row++);
                continue;
            }
            if (fullWidth) {
                this.addGridbagPair(lblName, widget, gbc, widgetPanel, row++, true, false);
                continue;
            }
            this.addGridbagPair(lblName, widget, gbc, widgetPanel, row++, true, true);
        }
        Rectangle rect = this.panelCtrl_.getPreferredBounds();
        widgetPanel.setPreferredSize(new Dimension(rect.width, rect.height + 10));
        this.themeCtrl_.process(widgetPanel);
        return widgetPanel;
    }

    private void addGridbagPair(JComponent firstItem, JComponent secondItem, GridBagConstraints gbc, JPanel panel, int row, boolean expandSecond, boolean addInset) {
        int secondFill = expandSecond ? 2 : 0;
        GuiHelper.buildGridBagConstraints(gbc, 0, row, 1, 1, 10.0, 0.0);
        gbc.fill = 0;
        gbc.anchor = 17;
        panel.add((Component)firstItem, gbc);
        GuiHelper.buildGridBagConstraints(gbc, 1, row, 1, 1, 90.0, 0.0);
        gbc.fill = secondFill;
        gbc.anchor = 17;
        if (addInset) {
            Insets rightInsets;
            gbc.insets = rightInsets = new Insets(2, 2, 2, 200);
        }
        panel.add((Component)secondItem, gbc);
    }

    public void setWidgetFocus() {
        WidgetFocusCtrl widgetFocusCtrl = new WidgetFocusCtrl();
        widgetFocusCtrl.setWidgetFocus(this.panelCtrl_.getWidgetGroups());
    }

    private JPanel getButtonPanel() {
        JPanel buttonPanel = new JPanel();
        this.themeCtrl_.process(buttonPanel);
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createGlue());
        if (this.mode_ == 0) {
            buttonPanel.add(this.btnInsert_);
            buttonPanel.add(Box.createHorizontalStrut(5));
            buttonPanel.add(this.btnReset_);
        } else {
            buttonPanel.add(this.btnUpdate_);
            buttonPanel.add(Box.createHorizontalStrut(5));
            buttonPanel.add(this.btnDelete_);
        }
        buttonPanel.add(Box.createHorizontalStrut(5));
        buttonPanel.add(this.btnClose_);
        Border border = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        buttonPanel.setBorder(border);
        return buttonPanel;
    }

    private void setCosmetics() {
        this.themeCtrl_.process(this);
        this.btnInsert_.setMnemonic('I');
        this.btnUpdate_.setMnemonic('U');
        this.btnDelete_.setMnemonic('D');
        this.btnReset_.setMnemonic('R');
        this.btnClose_.setMnemonic('C');
        this.btnReset_.setToolTipText(ResMgr.getRes("reset.fields.msg"));
    }

    private void setNames() {
    }

    private void buildListeners() {
        this.addButtonListeners();
    }

    private void addButtonListeners() {
        this.lisInsert_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DbRowEditPanel.this.startInsert();
            }
        };
        this.lisUpdate_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DbRowEditPanel.this.startUpdate();
            }
        };
        this.lisDelete_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DbRowEditPanel.this.startDelete();
            }
        };
        this.lisReset_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DbRowEditPanel.this.doReset();
            }
        };
        this.lisClose_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DbRowEditPanel.this.closeParentDlg();
            }
        };
        this.lisTab_ = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (DbRowEditPanel.this.tabPane_.getSelectedIndex() == 1) {
                    DbRowEditPanel.this.refreshSql();
                }
            }
        };
    }

    private void addListeners() {
        this.btnInsert_.addActionListener(this.lisInsert_);
        this.btnUpdate_.addActionListener(this.lisUpdate_);
        this.btnDelete_.addActionListener(this.lisDelete_);
        this.btnReset_.addActionListener(this.lisReset_);
        this.btnClose_.addActionListener(this.lisClose_);
        this.tabPane_.addChangeListener(this.lisTab_);
    }

    private void addParentListeners() {
        if (this.parentDlg_ != null) {
            KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
            this.parentDlg_.getRootPane().getInputMap(2).put(escapeKeyStroke, "ESCAPE");
            this.parentDlg_.getRootPane().getActionMap().put("ESCAPE", new CancelAction());
        }
    }

    private void closeParentDlg() {
        if (this.parentDlg_ != null) {
            this.parentDlg_.setVisible(false);
            this.parentDlg_.dispose();
        }
    }

    private void doReset() {
        this.setReadyStatus();
        this.panelCtrl_.resetWidgets();
        this.setWidgetFocus();
    }

    private void setInsertStatus() {
        this.readyStatusLbl_.setText(StrHelper.INSERTING_DATA_STR);
    }

    private void setUpdateStatus() {
        this.readyStatusLbl_.setText(StrHelper.UPDATING_DATA_STR);
    }

    private void setDeleteStatus() {
        this.readyStatusLbl_.setText(StrHelper.DELETING_DATA_STR);
    }

    private void startInsert() {
        this.setInsertStatus();
        this.isAnInsert = true;
        this.panelCtrl_.setDisabledBtn(this.btnInsert_);
        ITestResult startResult = this.panelCtrl_.startInsert();
        if (!startResult.getPassed()) {
            GuiMessageHelper.showInputErrMsg(null, startResult);
            this.setReadyStatus();
        }
    }

    private void startUpdate() {
        this.setUpdateStatus();
        this.isAnInsert = false;
        this.panelCtrl_.setDisabledBtn(this.btnUpdate_);
        ITestResult startResult = this.panelCtrl_.startUpdate();
        if (!startResult.getPassed()) {
            GuiMessageHelper.showInputErrMsg(null, startResult);
            this.setReadyStatus();
        }
    }

    private void startDelete() {
        String msg = ResMgr.getRes("delete.confirm.db.record.msg");
        boolean response = GuiMessageHelper.showYesNoMsg(null, "Confirm Remove", msg);
        if (response) {
            this.setDeleteStatus();
            this.isAnInsert = false;
            this.panelCtrl_.setDisabledBtn(this.btnDelete_);
            this.panelCtrl_.startDelete();
        }
    }

    private void showErrorTab() {
        int sessionIdx = 2;
        this.tabPane_.setSelectedIndex(sessionIdx);
    }

    private void updateLog(ITestResult result) {
        StringBuffer sb = new StringBuffer(this.txtLog_.getText());
        if (sb.length() > 0) {
            sb.append("\n-------------------------------------\n\n");
        }
        if (!result.getPassed()) {
            sb.append("ERROR: ");
        }
        sb.append(result.getDetail());
        this.txtLog_.setText(sb.toString());
        this.txtLog_.scrollDown();
    }

    private void refreshSql() {
        this.txtSqlPreview_.setText("");
        String sql = "";
        if (this.mode_ == 0) {
            sql = this.panelCtrl_.getInsertSql();
        } else {
            String updateSql = this.panelCtrl_.getUpdateSql();
            String deleteSql = this.panelCtrl_.getDeleteSql();
            sql = updateSql + "\n" + deleteSql;
        }
        this.txtSqlPreview_.setText(sql);
    }

    @Override
    public Rectangle getPreferredBounds() {
        DbValueWidgetGroup aWidgetGroup = (DbValueWidgetGroup)this.panelCtrl_.getWidgetGroups().get(0);
        int lineHeight = aWidgetGroup.getLineHeightPixels();
        int calcHeight = this.panelCtrl_.getPreferredBounds().height + 9 * lineHeight;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int screenHeight = toolkit.getScreenSize().height;
        int maxHeight = screenHeight - 100;
        int prefHeight = calcHeight > maxHeight ? maxHeight : calcHeight;
        return new Rectangle(625, prefHeight);
    }

    @Override
    public void threadDone(SwingWorker threadWorker) {
        ITestResult result = this.panelCtrl_.getSqlCmdResult();
        this.updateLog(result);
        if (result.getPassed()) {
            this.setDataChanged(true);
            if (this.isAnInsert) {
                this.doReset();
            } else {
                this.closeParentDlg();
            }
        } else {
            this.setDataChanged(false);
            this.showErrorTab();
        }
    }

    class CancelAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            DbRowEditPanel.this.closeParentDlg();
        }
    }
}

