/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.command.table;

import com.harrand.coregui.Icons;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.CommandChain;
import com.harrand.coregui.command.CommandChainMgr;
import com.harrand.coregui.command.idf.RenameIdf;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrench.object.Table;

public class ChangeTableProps
extends Command {
    private Table table;
    private String cmdName_;
    private RenameIdf cmdRnm;
    private String newNm;
    private String oldCmm;
    private String newCmm;
    private String oldTblOpts;
    private String newTblOpts;

    public ChangeTableProps(Table table, String newNm, String newCmm, String newTblOpts) {
        this.init(table, null, newNm, table.getComment(), newCmm, table.getTableOptions(), newTblOpts);
        this.buildObject();
    }

    private ChangeTableProps(Table table, RenameIdf cmdRnm, String newNm, String oldCmm, String newCmm, String oldTblOpts, String newTblOpts) {
        this.init(table, cmdRnm, newNm, oldCmm, newCmm, oldTblOpts, newTblOpts);
    }

    private void init(Table table, RenameIdf cmdRnm, String newNm, String oldCmm, String newCmm, String oldTblOpts, String newTblOpts) {
        this.table = table;
        this.cmdRnm = cmdRnm;
        this.newNm = newNm;
        this.oldCmm = oldCmm;
        this.newCmm = newCmm;
        this.oldTblOpts = oldTblOpts;
        this.newTblOpts = newTblOpts;
        CommandChain cmdChain = CommandChainMgr.getInstance().getCommandChain();
        this.setCommandChain(cmdChain);
        this.buildObject();
    }

    public void buildRnmCmd() {
        String oldNm = this.table.getName();
        if (this.getNmChanged(oldNm)) {
            this.cmdRnm = new RenameIdf(this.table.getSchema(), this.table, oldNm, this.newNm, null);
            this.cmdRnm.setRenameMgr(this.getDb().getRenameMgr());
        } else {
            this.cmdRnm = null;
        }
    }

    private void buildObject() {
        this.cmdName_ = "Update Table Properties For : " + this.table.getDotNote();
        this.setProps();
    }

    @Override
    protected void execute() {
        if (this.getState() == ChangeTableProps.getStateDo()) {
            this.buildRnmCmd();
            this.doForward();
        } else if (this.getState() == ChangeTableProps.getStateRedo()) {
            this.doForward();
        }
    }

    public void doForward() {
        if (this.isRename()) {
            this.cmdRnm.setState(Command.getStateDo());
            this.cmdRnm.actionPerformed(null);
        }
        this.table.setComment(this.newCmm);
        this.table.setTableOptions(this.newTblOpts);
    }

    private boolean isRename() {
        return this.cmdRnm != null;
    }

    @Override
    protected void undo() {
        if (this.isRename()) {
            this.cmdRnm.setState(Command.getStateUndo());
            this.cmdRnm.actionPerformed(null);
        }
        this.table.setComment(this.oldCmm);
        this.table.setTableOptions(this.oldTblOpts);
    }

    @Override
    public Command duplicate() {
        ChangeTableProps cmdNew = new ChangeTableProps(this.table, this.cmdRnm, this.newNm, this.oldCmm, this.newCmm, this.oldTblOpts, this.newTblOpts);
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.cmdName_;
        this.putValue("Name", "Change Table Properties");
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
        this.putValue("SmallIcon", Icons.TABLE);
    }

    private boolean getNmChanged(String oldNm) {
        return !oldNm.equals(this.newNm);
    }

    private Database getDb() {
        return LookupUtil.getLookupDb();
    }
}

