/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.command.column;

import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.CommandChainMgr;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Table;

public class ToggleSigned
extends Command {
    private Table table;
    private Column oldColumn;
    private Column newColumn;
    private String cmdName;

    public ToggleSigned(Column column) {
        this.init(column, null);
        this.buildObject();
    }

    private ToggleSigned(Column oldColumn, Column newColumn) {
        this.init(oldColumn, newColumn);
    }

    private void init(Column oldColumn, Column newColumn) {
        this.oldColumn = oldColumn;
        this.newColumn = newColumn;
        this.table = oldColumn.getTable();
        this.buildObject();
    }

    private void buildObject() {
        this.cmdName = "Update signed on: " + this.oldColumn.getName();
        this.setProps();
    }

    @Override
    protected void execute() {
        if (this.getState() == ToggleSigned.getStateDo()) {
            this.doToggle();
        } else if (this.getState() == ToggleSigned.getStateRedo()) {
            this.doForward();
        }
    }

    private void doToggle() {
        this.setCommandChain(CommandChainMgr.getInstance().getCommandChain());
        boolean newValue = !this.oldColumn.getSignedFlag();
        this.newColumn = (Column)this.oldColumn.getDup();
        this.newColumn.setSigned(newValue);
        this.doForward();
    }

    public void doForward() {
        this.table.updateItem(this.oldColumn, this.newColumn);
    }

    @Override
    protected void undo() {
        this.table.updateItem(this.newColumn, this.oldColumn);
    }

    @Override
    public Command duplicate() {
        ToggleSigned cmdNew = new ToggleSigned(this.oldColumn, this.newColumn);
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.cmdName;
        this.putValue("Name", "Column Signed");
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
    }
}

