/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.command;

import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.idf.ISpecificIdfRemoveCmd;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Schema;
import com.harrand.sketch.core.Diagram;
import com.harrand.util.LogUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RemoveSchCmd
extends Command
implements ISpecificIdfRemoveCmd {
    private Database db_;
    private Schema schema_;
    private String cmdName_;
    private Map removeGlyphsMap_ = null;
    private boolean showWarning_ = true;

    public RemoveSchCmd(Database db) {
        this.db_ = db;
    }

    private RemoveSchCmd(Database db, Schema schema, Map removeGlyphsMap, boolean showWarning) {
        this(db);
        this.schema_ = schema;
        this.removeGlyphsMap_ = removeGlyphsMap;
        this.setShowWarning(showWarning);
        this.buildObject();
    }

    @Override
    public void setIdfDotNote(String dotNote) {
        this.schema_ = this.db_.getSchema(dotNote);
        this.buildObject();
    }

    public String getIdfName() {
        if (this.schema_ != null) {
            return this.schema_.getName();
        }
        return "RemoveSchCmd.err: IdfName is not set.";
    }

    @Override
    public void setShowWarning(boolean show) {
        this.showWarning_ = show;
    }

    @Override
    public boolean getShowWarning() {
        return this.showWarning_;
    }

    private void buildObject() {
        this.cmdName_ = "Remove Schema";
        this.setProps();
    }

    @Override
    public Command duplicate() {
        RemoveSchCmd cmdNew = new RemoveSchCmd(this.db_, this.schema_, this.removeGlyphsMap_, this.getShowWarning());
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void execute() {
        if (this.schema_ == null) {
            LogUtil.logErr("RemoveSchCmd.err: idfName not set.");
            return;
        }
        boolean yesHit = true;
        if (this.getShowWarning()) {
            yesHit = GuiMessageHelper.showYesNoMsg(null, "Confirm - Remove Schema", "Removing a schema will remove dependent diagram glyphs. Continue?");
        }
        if (!yesHit) {
            return;
        }
        String schNm = this.schema_.getName();
        String searchPrefix = schNm + ".";
        this.removeGlyphsMap_ = new HashMap();
        for (Diagram diagram : this.db_.getDiagrams()) {
            ArrayList<DbTableGlyph> removeGlyphs = new ArrayList<DbTableGlyph>();
            List<String> glyphNms = diagram.getGlyphNames();
            for (String glyNm : glyphNms) {
                if (glyNm.indexOf(searchPrefix) != 0) continue;
                DbTableGlyph glyph = (DbTableGlyph)diagram.getGlyph(glyNm);
                removeGlyphs.add(glyph);
                diagram.removeGlyph(glyNm);
            }
            if (removeGlyphs.isEmpty()) continue;
            this.removeGlyphsMap_.put(diagram.getName(), removeGlyphs);
        }
        try {
            this.db_.remove(this.schema_.getMapName(), schNm);
        }
        catch (Exception e) {
            LogUtil.logErr("RemoveSchCmd.err: " + e.getMessage());
        }
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.cmdName_;
        this.putValue("Name", display);
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
        this.putValue("MnemonicKey", new Integer(82));
    }

    @Override
    protected void undo() {
        this.db_.add(this.schema_);
        for (String diagramNm : this.removeGlyphsMap_.keySet()) {
            Diagram diagram = this.db_.getDiagram(diagramNm);
            List removeGlyphs = (List)this.removeGlyphsMap_.get(diagramNm);
            for (DbTableGlyph glyph : removeGlyphs) {
                diagram.addGlyph(glyph);
            }
        }
    }
}

