/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.command;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.CommandChain;
import com.harrand.coregui.dialog.CloseDialog;
import com.harrand.coregui.dialog.ParentFrameSvr;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.dbwrench.element.ISchemaObj;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrenchgui.transfer.ChangeSchemaPanel;
import java.util.ArrayList;
import java.util.List;

public class PromptChangeSchema
extends Command {
    private Database db_;
    private List schObjs_;
    private CommandChain cmdChain_ = null;
    private String cmdName_;

    public PromptChangeSchema(Database db, List idfs) {
        this.db_ = db;
        this.setSchemaObjs(idfs);
        this.buildObject();
    }

    private void setSchemaObjs(List idfs) {
        this.schObjs_ = new ArrayList();
        for (Identifiable idf : idfs) {
            if (!(idf instanceof ISchemaObj)) continue;
            this.schObjs_.add(idf);
        }
    }

    private void buildObject() {
        this.cmdName_ = "Prompt Change Schema";
        this.setProps();
    }

    public ITestResult checkOk() {
        DataEntryResult rslt = new DataEntryResult(true);
        if (!this.db_.getHasManySchemas()) {
            rslt = new DataEntryResult(false, "Can Not Change Schema", "Can not change schema if only one schema is defined \nin the database.");
            return rslt;
        }
        if (this.schObjs_.isEmpty()) {
            rslt = new DataEntryResult(false, "No Schema Items", "None of the selected are directly contained by schemas.");
        }
        return rslt;
    }

    @Override
    protected void execute() {
        ITestResult ok = this.checkOk();
        if (!ok.getPassed()) {
            GuiMessageHelper.showInputErrMsg(null, ok);
            return;
        }
        ChangeSchemaPanel panel = new ChangeSchemaPanel(this.db_);
        panel.setTransferIdfs(this.schObjs_);
        CloseDialog dlg = new CloseDialog(ParentFrameSvr.instance().getParentFrame(), true, panel, true, true);
        dlg.addOkListener(panel.getOkListener());
        panel.setParentDlg(dlg);
        dlg.setVisible(true);
    }

    @Override
    protected void undo() {
    }

    @Override
    public Command duplicate() {
        PromptChangeSchema cmdNew = new PromptChangeSchema(this.db_, this.schObjs_);
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void setProps() {
        String display = "Change Schema";
        this.putValue("Name", display);
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
        this.putValue("MnemonicKey", new Integer(67));
    }
}

