/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.command;

import com.harrand.coregui.command.Command;
import com.harrand.dbwrench.diagram.ForeignKeyGlyph;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Table;
import com.harrand.sketch.command.RemoveGlyphs;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.util.LogUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DwrDeleteGlyphsCmd
extends Command {
    private Diagram diagram_;
    private List selectedGlyphsAll_;
    private RemoveGlyphs removeGlyphsCmd_;
    private List fksDeleted_;
    private Map backColors_ = new HashMap();
    private String cmdName_;

    public DwrDeleteGlyphsCmd(Diagram diagram, List selectedGlyphsAll) {
        this.diagram_ = diagram;
        this.selectedGlyphsAll_ = selectedGlyphsAll;
        this.buildObject();
    }

    private DwrDeleteGlyphsCmd(Diagram diagram, List selectedGlyphsAll, RemoveGlyphs removeGlyphsCmd, List fksDeleted, Map backColors) {
        this.diagram_ = diagram;
        this.selectedGlyphsAll_ = selectedGlyphsAll;
        this.removeGlyphsCmd_ = removeGlyphsCmd;
        this.fksDeleted_ = fksDeleted;
        this.backColors_ = backColors;
        this.buildObject();
    }

    private void buildObject() {
        this.cmdName_ = "Delete Selected Glyphs & FKs";
        this.setProps();
    }

    @Override
    public Command duplicate() {
        DwrDeleteGlyphsCmd cmdNew = new DwrDeleteGlyphsCmd(this.diagram_, this.selectedGlyphsAll_, this.removeGlyphsCmd_, this.fksDeleted_, this.backColors_);
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void execute() {
        this.deleteTblGlyphs();
        this.deleteFksObjs();
    }

    private void deleteTblGlyphs() {
        ArrayList<Glyph> selectedGlyphs = new ArrayList<Glyph>();
        for (Object obj : this.selectedGlyphsAll_) {
            boolean notFk = obj instanceof ForeignKeyGlyph;
            if (notFk) continue;
            selectedGlyphs.add((Glyph)obj);
        }
        this.removeGlyphsCmd_ = new RemoveGlyphs(this.diagram_, selectedGlyphs, Command.getStateDo());
        this.removeGlyphsCmd_.actionPerformed(null);
    }

    private void deleteFksObjs() {
        this.fksDeleted_ = new ArrayList();
        for (Object obj : this.selectedGlyphsAll_) {
            if (!(obj instanceof ForeignKeyGlyph)) continue;
            ForeignKeyGlyph fkGlyph = (ForeignKeyGlyph)obj;
            Color bkColor = fkGlyph.getColor("BackColor");
            this.backColors_.put(fkGlyph.getName(), bkColor);
            ForeignKey fk = fkGlyph.getForeignKey();
            Table chdTbl = fk.getChdTbl();
            try {
                chdTbl.remove(fk.getClassName(), fk.getName());
                this.fksDeleted_.add(fk);
            }
            catch (Exception e) {
                LogUtil.logErr("DwrDelGlyphCmd.remove fk failed: " + e.getMessage());
            }
        }
    }

    @Override
    protected void undo() {
        for (ForeignKey fk : this.fksDeleted_) {
            Table chdTbl = fk.getChdTbl();
            chdTbl.add(fk);
        }
        this.removeGlyphsCmd_.undo();
        this.restoreLinkColors();
    }

    private void restoreLinkColors() {
        for (ForeignKey fk : this.fksDeleted_) {
            String fkNm = fk.getDotNote();
            ForeignKeyGlyph fkGlyph = (ForeignKeyGlyph)this.diagram_.getLink(fkNm);
            if (fkGlyph != null) {
                Color bkColor = (Color)this.backColors_.get(fkNm);
                fkGlyph.setColor("BackColor", bkColor);
                continue;
            }
            LogUtil.logErr("dwrDeleteGlyphsCmd.fkNull.color restore failed for " + fkNm);
        }
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.cmdName_;
        this.putValue("Name", display);
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
        this.putValue("MnemonicKey", new Integer(82));
    }
}

