/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.command;

import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.prompt.PromptCollectionAdd;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.nb.IWindowUtil;
import com.harrand.dbwrench.element.CollectorProvider;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.CustomType;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Sequence;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.table.constraint.UniqueConstraint;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.dbwrenchgui.command.AddNewTableGlyph;
import com.harrand.dbwrenchgui.command.AddQuickFkFromDiagramCmdDisp;
import com.harrand.dbwrenchgui.command.PromptQuickFk;
import com.harrand.dbwrenchgui.command.glyph.AddDiagramIdfCmd;
import com.harrand.dbwrenchgui.db.query.command.prompt.query.AddQueryCmd;
import com.harrand.dbwrenchgui.diagram.DiagramEditPanel;
import com.harrand.dbwrenchgui.panel.ColumnEditPanel;
import com.harrand.dbwrenchgui.panel.CustomTypePanel;
import com.harrand.dbwrenchgui.panel.ForeignKeyPanel;
import com.harrand.dbwrenchgui.panel.IndexEditPanel;
import com.harrand.dbwrenchgui.panel.ProcEditPanel;
import com.harrand.dbwrenchgui.panel.SchemaEditPanel;
import com.harrand.dbwrenchgui.panel.SequenceEditPanel;
import com.harrand.dbwrenchgui.panel.TableAddPanel;
import com.harrand.dbwrenchgui.panel.TriggerEditPanel;
import com.harrand.dbwrenchgui.panel.ViewEditPanel;
import com.harrand.dbwrenchgui.panel.subpanel.table.UniqueConstraintPanel;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.object.Note;
import com.harrand.sketch.object.Zone;
import com.harrand.util.MathUtil;
import java.awt.Point;
import java.util.ArrayList;

public class DbwCmdFactory {
    private static final DbwCmdFactory instance__ = new DbwCmdFactory();
    private IWindowUtil windowUtil_ = null;

    public static DbwCmdFactory getInstance() {
        return instance__;
    }

    public void setWindowUtil(IWindowUtil windowUtil) {
        this.windowUtil_ = windowUtil;
    }

    private Database getDb() {
        return LookupUtil.getLookupDb();
    }

    public Command getAddSchemaCmd() {
        SchemaEditPanel dataEditor = new SchemaEditPanel(this.getDb());
        String clzNm = Schema.getClassName();
        return new PromptCollectionAdd(this.getDb(), clzNm, dataEditor);
    }

    public Command getAddDiagramCmd() {
        DiagramEditPanel dataEditor = DiagramEditPanel.getInstance();
        dataEditor.setItems(null, this.getDb());
        DbUser user = this.getUser();
        IOptionMgr optMgr = user.getOptionMgr("diagram.option.mgr");
        dataEditor.setOptionMgr(optMgr);
        String clzNm = Diagram.getClassName();
        dataEditor.refresh();
        return new PromptCollectionAdd(this.getDb(), clzNm, dataEditor);
    }

    public Command getAddTableCmd(Schema schIn) {
        Schema schema = this.getEvaluatedSchema(schIn);
        Diagram diagram = this.getEvaluatedDiagram(null);
        Database db = this.getDb();
        if (diagram != null) {
            Point p = MathUtil.getRectCenter(diagram.getViewportRect());
            AddNewTableGlyph cmd = new AddNewTableGlyph(db, schema, this.getUser(), diagram, p);
            return cmd;
        }
        TableAddPanel dataEditor = new TableAddPanel(schema, this.getUser(), db);
        String clzNm = Table.getClassName();
        return new PromptCollectionAdd(db, clzNm, dataEditor);
    }

    public Command getAddProcCmd(Schema schIn) {
        if (!this.isWindowUtilSet()) {
            return null;
        }
        Schema schema = this.getEvaluatedSchema(schIn);
        if (schema == null) {
            return null;
        }
        ProcEditPanel dataEditor = new ProcEditPanel(schema);
        return this.windowUtil_.getShowEditorCmd(dataEditor, "Add Procedure");
    }

    public Command getAddViewCmd(Schema schIn) {
        if (!this.isWindowUtilSet()) {
            return null;
        }
        Schema schema = this.getEvaluatedSchema(schIn);
        if (schema == null) {
            return null;
        }
        ViewEditPanel dataEditor = new ViewEditPanel(schema);
        return this.windowUtil_.getShowEditorCmd(dataEditor, "Add View");
    }

    public Command getAddSequenceCmd(Schema schIn) {
        Schema schema = this.getEvaluatedSchema(schIn);
        if (schema == null) {
            return null;
        }
        SequenceEditPanel dataEditor = new SequenceEditPanel(schema);
        return new PromptCollectionAdd(schema, Sequence.getClassName(), dataEditor);
    }

    public Command getAddCustomTypeCmd(Schema schIn) {
        Schema schema = this.getEvaluatedSchema(schIn);
        if (schema == null) {
            return null;
        }
        CustomTypePanel dataEditor = new CustomTypePanel(schema);
        return new PromptCollectionAdd(schema, CustomType.getClassName(), dataEditor);
    }

    public Command getAddQueryCmd(Database db) {
        return new AddQueryCmd(db, new ArrayList<Table>());
    }

    public Command getAddColumnCmd(Table tblIn) {
        Table tbl = this.getEvaluatedTable(tblIn);
        if (tbl == null) {
            return null;
        }
        ColumnEditPanel dataEditor = new ColumnEditPanel(null, tbl);
        return new PromptCollectionAdd(tbl, Column.getClassName(), dataEditor);
    }

    public Command getAddFkCmd(Table tblIn) {
        Table tbl = this.getEvaluatedTable(tblIn);
        if (tbl == null) {
            return null;
        }
        ForeignKeyPanel dataEditor = new ForeignKeyPanel(null, this.getDb());
        dataEditor.setChildTable(tbl);
        return new PromptCollectionAdd(tbl, ForeignKey.getClassName(), dataEditor);
    }

    public Command getAddQuickFkCmd(Table tblIn) {
        Diagram diagram = this.getEvaluatedDiagram(null);
        Table tbl = this.getEvaluatedTable(tblIn);
        if (tbl == null) {
            return null;
        }
        PromptQuickFk cmd = new PromptQuickFk(this.getUser(), this.getDb(), diagram, tbl);
        return cmd;
    }

    public Command getAddIndexCmd(Table tblIn) {
        Table tbl = this.getEvaluatedTable(tblIn);
        if (tbl == null) {
            return null;
        }
        IndexEditPanel dataEditor = new IndexEditPanel(null, tbl);
        return new PromptCollectionAdd(tbl, Index.getClassName(), dataEditor);
    }

    public Command getAddTriggerCmd(Table tblIn) {
        Table tbl = this.getEvaluatedTable(tblIn);
        if (tbl == null) {
            return null;
        }
        if (this.isWindowUtilSet()) {
            TriggerEditPanel dataEditor = new TriggerEditPanel(null, tbl);
            return this.windowUtil_.getShowEditorCmd(dataEditor, "Add Trigger");
        }
        this.showWindowUtilNotSetMsg();
        return null;
    }

    public Command getAddFkFromDiagramCmd(Table tblIn) {
        new AddQuickFkFromDiagramCmdDisp().initiateCommand(tblIn);
        return null;
    }

    public Command getAddUniqueConstraintCmd(Table tblIn) {
        Table tbl = this.getEvaluatedTable(tblIn);
        if (tbl == null) {
            return null;
        }
        UniqueConstraintPanel dataEditor = new UniqueConstraintPanel(tbl, null);
        return new PromptCollectionAdd(tbl, UniqueConstraint.getClassName(), dataEditor);
    }

    public Command getAddZoneCmd(Diagram diagramIn) {
        Diagram diagram = this.getEvaluatedDiagram(diagramIn);
        if (diagram != null) {
            return new AddDiagramIdfCmd(diagram, Zone.getClassName());
        }
        this.showNoDiagramMsg("zone");
        return null;
    }

    public Command getAddNoteCmd(Diagram diagramIn) {
        Diagram diagram = this.getEvaluatedDiagram(diagramIn);
        if (diagram != null) {
            return new AddDiagramIdfCmd(diagram, Note.getClassName());
        }
        this.showNoDiagramMsg("note");
        return null;
    }

    private Table getTable() {
        return CollectorProvider.getInstance().getTable();
    }

    private Schema getSchema() {
        return CollectorProvider.getInstance().getSchema();
    }

    private Diagram getDiagram() {
        return CollectorProvider.getInstance().getDiagram();
    }

    private Table getEvaluatedTable(Table tblIn) {
        Table tblBest;
        Table table = tblBest = tblIn != null ? tblIn : this.getTable();
        if (tblBest == null) {
            GuiMessageHelper.showWarningMsg(null, "Unable to Add Object Yet", "No table has yet received focus to which to add this object.");
        }
        return tblBest;
    }

    private Schema getEvaluatedSchema(Schema schIn) {
        Schema schBest;
        Schema schema = schBest = schIn != null ? schIn : this.getSchema();
        if (schBest == null) {
            schBest = this.getDb().getFirstSchema();
        }
        return schBest;
    }

    private Diagram getEvaluatedDiagram(Diagram diagramIn) {
        Diagram diagramBest = diagramIn != null ? diagramIn : this.getDiagram();
        return diagramBest;
    }

    private DbUser getUser() {
        return App.getUser();
    }

    private boolean isWindowUtilSet() {
        boolean isSet;
        boolean bl = isSet = this.windowUtil_ != null;
        if (!isSet) {
            this.showWindowUtilNotSetMsg();
        }
        return isSet;
    }

    private void showNoDiagramMsg(String objNm) {
        String msg = "A diagram must be open and displaying to which the new " + objNm + " would be added to.";
        GuiMessageHelper.showWarningMsg(null, "No Diagram Displaying", msg);
    }

    private void showWindowUtilNotSetMsg() {
        GuiMessageHelper.showWarningMsg(null, "Show Editor Failed", "WindowUtil not set.");
    }
}

