/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.command;

import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.command.Command;
import com.harrand.dbwrench.element.ISchemaObj;
import com.harrand.dbwrench.notification.NotifyMgr;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChangeSchema
extends Command {
    private Database db_;
    private NotifyMgr notifyMgr_;
    private Schema newSchema_;
    private List idfs_;
    private String cmdName_;
    private Map oldSchemas_ = new HashMap();

    public ChangeSchema(Schema newSchema, List idfs) {
        this.newSchema_ = newSchema;
        this.db_ = this.newSchema_.getDb();
        this.notifyMgr_ = this.db_.getNotifyMgr();
        this.idfs_ = idfs;
        this.buildObject();
    }

    private void setOldSchemas(Map oldSchemas) {
        this.oldSchemas_ = oldSchemas;
    }

    private void buildObject() {
        this.cmdName_ = "Change Schema";
        this.setProps();
    }

    @Override
    protected void execute() {
        this.notifyMgr_.setDbEnabled(false);
        for (Identifiable idf : this.idfs_) {
            this.transferObj(idf, this.newSchema_);
        }
        this.notifyMgr_.setDbEnabled(true);
        this.notifyMgr_.updateDb();
    }

    @Override
    protected void undo() {
        for (Identifiable idf : this.idfs_) {
            Schema previousSch = (Schema)this.oldSchemas_.get(idf);
            this.transferObj(idf, previousSch);
        }
    }

    private void transferObj(Identifiable idf, Schema toSchema) {
        boolean isTbl;
        if (!(idf instanceof ISchemaObj)) {
            return;
        }
        ISchemaObj schObj = (ISchemaObj)((Object)idf);
        Schema fromSchema = schObj.getSchema();
        if (this.getState() != ChangeSchema.getStateUndo()) {
            this.oldSchemas_.put(idf, fromSchema);
        }
        if (isTbl = idf instanceof Table) {
            fromSchema.setTableRenameInProgress(true);
        }
        fromSchema.remove(idf.getMapName(), idf.getName());
        if (isTbl) {
            fromSchema.setTableRenameInProgress(false);
        }
        fromSchema.notifyObservers(new UpdateChain());
        toSchema.add(idf);
    }

    @Override
    public Command duplicate() {
        ChangeSchema cmdNew = new ChangeSchema(this.newSchema_, this.idfs_);
        cmdNew.setOldSchemas(this.oldSchemas_);
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.cmdName_;
        this.putValue("Name", display);
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
    }
}

