/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.command;

import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coregui.dialog.CloseDialog;
import com.harrand.coregui.dialog.ParentFrameSvr;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.dbwrenchgui.diagram.plugin.addfk.AddFkByDiagramPlugin;
import com.harrand.dbwrenchnb.diagram.DiagramTC;
import com.harrand.dbwrenchnb.nb.NbUtil;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.j2d.DiagramPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openide.awt.StatusDisplayer;
import org.openide.windows.TopComponent;

public class AddQuickFkFromDiagramCmdDisp {
    public void initiateCommand(Table tblIn) {
        TopComponent tc = NbUtil.findShowingSelectedTC(DiagramTC.class.getName());
        if (tc == null) {
            GuiMessageHelper.showWarningMsg(null, "Add Foreign Key", "Please select the child table on the diagram.");
            return;
        }
        DiagramTC diagramTc = (DiagramTC)tc;
        DiagramPanel diagramPanel = diagramTc.getDiagramPanel();
        Diagram diagram = diagramPanel.getDiagram();
        Table childTable = diagram.getSelectedTable();
        if (childTable == null) {
            GuiMessageHelper.showWarningMsg(null, "Add Foreign Key", "Please select the child table on the diagram.");
            return;
        }
        DbTableGlyph childGlyph = diagram.getSelectedDbTableGlyph();
        AddFkByDiagramPlugin plugin = new AddFkByDiagramPlugin(diagramPanel, childGlyph);
        diagramPanel.setPlugin(plugin);
        this.showSelectParentDlg();
        StatusDisplayer.getDefault().setStatusText("Select parent glyph.");
    }

    private void showSelectParentDlg() {
        boolean showMsg;
        DbUser user = App.getUser();
        IOptionMgr optMgr = user.getOptionMgr("diagram.option.mgr");
        String OPTION_KEY = "diagram.do.not.show.select.parent.msg";
        boolean bl = showMsg = !optMgr.getBoolValue("diagram.do.not.show.select.parent.msg");
        if (showMsg) {
            SelectParentTablePanel panel = new SelectParentTablePanel();
            CloseDialog closeDialog = new CloseDialog(ParentFrameSvr.instance().getParentFrame(), true, panel);
            closeDialog.setTitle("Add Quick Foreign Key");
            closeDialog.setVisible(true);
            boolean doNotShowAgain = panel.getDoNotShowAgain();
            optMgr.setBoolValue("diagram.do.not.show.select.parent.msg", doNotShowAgain);
        }
    }

    private static class SelectParentTablePanel
    extends JPanel
    implements ISized {
        private final JCheckBox checkBox = new JCheckBox("Do not show this dialog again");
        private final JLabel text = new JLabel("Now select the parent table from the diagram.");
        public static final int PREFERRED_WIDTH = 340;
        public static final int PREFERRED_HEIGHT = 160;

        public SelectParentTablePanel() {
            this.setLayout(new BorderLayout(4, 4));
            this.text.setHorizontalAlignment(0);
            this.checkBox.setHorizontalAlignment(0);
            this.add((Component)this.text, "Center");
            this.add((Component)this.checkBox, "South");
            this.setBorder(GuiHelper.getEmptyBorder());
        }

        public boolean getDoNotShowAgain() {
            return this.checkBox.isSelected();
        }

        @Override
        public Rectangle getPreferredBounds() {
            return new Rectangle(340, 160);
        }
    }
}

