/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.command;

import com.harrand.coreclasses.element.Cardinality;
import com.harrand.coreclasses.element.StringPair;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.CommandChain;
import com.harrand.coregui.command.idf.AddToCollector;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.dbwrench.naming.DbwNameBldrSvr;
import com.harrand.dbwrench.naming.FkNameBldr;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.security.App;
import com.harrand.util.ResMgr;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class AddFkFromPk
extends Command
implements Comparable {
    private String name_;
    private Database db_;
    private Table childTable_;
    private Table parentTable_;
    private PrimaryKey parentPk_;
    private final List pkColNms_ = new ArrayList();
    private List subCmds_;
    private FkNameBldr fkNmBldr_;
    private CommandChain cmdChain_;

    public AddFkFromPk(Database db, Table childTable, Table parentTable, CommandChain cmdChain) {
        this(db, childTable, parentTable, cmdChain, null, Command.getStateDo());
    }

    private AddFkFromPk(Database db, Table childTable, Table parentTable, CommandChain cmdChain, List subCmds, int state) {
        this.db_ = db;
        this.childTable_ = childTable;
        this.parentTable_ = parentTable;
        this.parentPk_ = this.parentTable_.getPrimaryKey();
        this.cmdChain_ = cmdChain;
        this.subCmds_ = subCmds;
        this.fkNmBldr_ = (FkNameBldr)DbwNameBldrSvr.instance().getNameBldr("FkNameBldr");
        String tblDisplayNm = this.parentTable_.getSchemaBracket();
        this.setName(tblDisplayNm);
        this.setState(state);
        this.setProps();
    }

    public void setName(String name) {
        this.name_ = name;
        this.setProps();
    }

    public String getName() {
        return this.name_;
    }

    public int compareTo(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (!(obj instanceof AddFkFromPk)) {
            return 0;
        }
        AddFkFromPk other = (AddFkFromPk)obj;
        String otherNm = other.getName();
        return this.getName().compareTo(otherNm);
    }

    @Override
    public Command duplicate() {
        AddFkFromPk cmdNew = new AddFkFromPk(this.db_, this.childTable_, this.parentTable_, this.cmdChain_, this.subCmds_, Command.getStateDo());
        this.cloneCommon(cmdNew);
        String tblDisplayNm = this.parentTable_.getSchemaBracket();
        String longName = App.getRes("foreignKey.add.quick.label") + ": " + tblDisplayNm;
        cmdNew.setName(longName);
        return cmdNew;
    }

    @Override
    protected void execute() {
        if (this.isParentPkValid()) {
            if (!this.getFkAlreadyExists()) {
                Command addFkCmd;
                this.subCmds_ = new ArrayList();
                List addPkColumnCmds = this.getAddPkColumnsCmds();
                if (!addPkColumnCmds.isEmpty()) {
                    this.subCmds_.addAll(addPkColumnCmds);
                }
                if ((addFkCmd = this.getFkAddCmd()) != null) {
                    this.subCmds_.add(this.getFkAddCmd());
                    this.setCommandChain(this.cmdChain_);
                    for (Object obj : this.subCmds_) {
                        Command cmd = (Command)obj;
                        cmd.actionPerformed(null);
                    }
                }
            } else {
                String msg = App.getRes("err.foreignkey.exists.for.parent") + ": " + this.parentTable_.getName();
                String title = ResMgr.getRes("command.invalid.label");
                GuiMessageHelper.showInputErrMsg(null, title, msg);
            }
        } else {
            String msg = App.getRes("err.foreignkey.pk.req") + " (" + this.parentTable_.getName() + ")";
            String title = ResMgr.getRes("command.invalid.label");
            GuiMessageHelper.showInputErrMsg(null, title, msg);
        }
    }

    @Override
    protected void undo() {
        int start;
        for (int i = start = this.subCmds_.size() - 1; i >= 0; --i) {
            Command cmd = (Command)this.subCmds_.get(i);
            cmd.setState(Command.getStateUndo());
            cmd.actionPerformed(null);
        }
    }

    private boolean isParentPkValid() {
        boolean ok = false;
        this.parentPk_ = this.parentTable_.getPrimaryKey();
        if (this.parentPk_ != null && !this.parentPk_.getKeyColumnNames().isEmpty()) {
            ok = true;
        }
        return ok;
    }

    private boolean getFkAlreadyExists() {
        boolean exists = false;
        String newChildTableName = this.childTable_.getName();
        Iterator it = this.db_.getFkUtil().getFksForTable(this.parentTable_, 0).iterator();
        while (it.hasNext() && !exists) {
            ForeignKey fk = (ForeignKey)it.next();
            String existsChildTableName = fk.getChdTbl().getName();
            if (!existsChildTableName.equalsIgnoreCase(newChildTableName)) continue;
            exists = true;
        }
        return exists;
    }

    private Command getFkAddCmd() {
        AddToCollector addFkCmd = null;
        try {
            Cardinality childCardi = ForeignKey.getDefaultCardinality(1);
            List parentCols = StringPair.getItemList(this.pkColNms_, 1);
            String parentLinkColNm = (String)parentCols.get(0);
            ForeignKey tempFk = new ForeignKey("tempFk", this.parentTable_, this.childTable_, this.pkColNms_, 3, 3, "", childCardi, parentLinkColNm);
            String fkName = this.fkNmBldr_.getFormedName(tempFk);
            ForeignKey newFk = new ForeignKey(fkName, this.parentTable_, this.childTable_, this.pkColNms_, 3, 3, "", childCardi, parentLinkColNm);
            addFkCmd = new AddToCollector(this.childTable_, newFk);
        }
        catch (Exception e) {
            String title = ResMgr.getRes("command.invalid.label");
            GuiMessageHelper.showInputErrMsg(null, title, e.getMessage());
        }
        return addFkCmd;
    }

    private List getAddPkColumnsCmds() {
        ArrayList<Command> cmds = new ArrayList<Command>();
        ArrayList childPkCols = this.childTable_.getPrimaryKey() != null ? this.childTable_.getPrimaryKey().getKeyColumnNames() : new ArrayList();
        Iterator itParent = this.parentPk_.getKeyColumnNames().iterator();
        while (itParent.hasNext()) {
            boolean foundRegularCol = false;
            boolean foundPkCol = false;
            String parentColumnName = (String)itParent.next();
            String childColumnName = null;
            Iterator itChild = this.childTable_.getKeys(Column.getClassName()).iterator();
            while (itChild.hasNext() && !foundRegularCol) {
                childColumnName = (String)itChild.next();
                if (!parentColumnName.equalsIgnoreCase(childColumnName)) continue;
                foundPkCol = false;
                for (String childPkColName : childPkCols) {
                    if (!childPkColName.equalsIgnoreCase(parentColumnName)) continue;
                    foundPkCol = true;
                }
                if (foundPkCol) continue;
                foundRegularCol = true;
            }
            if (foundPkCol) {
                String seperator = this.fkNmBldr_.getSeparator();
                String newChildColName = this.parentTable_.getName() + seperator + parentColumnName;
                cmds.add(this.getPkColumnAddCommand(parentColumnName, newChildColName));
                this.pkColNms_.add(new StringPair(parentColumnName, newChildColName));
                continue;
            }
            if (!foundRegularCol) {
                cmds.add(this.getColumnAddCmd(parentColumnName));
                this.pkColNms_.add(new StringPair(parentColumnName, parentColumnName));
                continue;
            }
            this.pkColNms_.add(new StringPair(parentColumnName, childColumnName));
        }
        return cmds;
    }

    private Command getColumnAddCmd(String parentColumnName) {
        Column parentCol = this.parentTable_.getColumn(parentColumnName);
        AddToCollector cmd = null;
        try {
            Column copyCol = new Column(parentCol.getName(), parentCol.getDataTypeId(), parentCol.getLength(), true, false, "", parentCol.getScale(), parentCol.getComment(), parentCol.getSignedFlag(), parentCol.getEnumCsv());
            cmd = new AddToCollector(this.childTable_, copyCol);
        }
        catch (Exception e) {
            GuiMessageHelper.showGeneralAppErrMsg(null, e.getMessage());
        }
        return cmd;
    }

    private Command getPkColumnAddCommand(String parentColumnName, String newColumnName) {
        Column parentCol = this.parentTable_.getColumn(parentColumnName);
        AddToCollector cmd = null;
        try {
            Column copyCol = new Column(newColumnName, parentCol.getDataTypeId(), parentCol.getLength(), true, false, "", parentCol.getScale(), parentCol.getComment(), parentCol.getSignedFlag(), parentCol.getEnumCsv());
            cmd = new AddToCollector(this.childTable_, copyCol);
        }
        catch (Exception e) {
            GuiMessageHelper.showGeneralAppErrMsg(null, e.getMessage());
        }
        return cmd;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.name_;
        this.putValue("Name", display);
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
    }
}

