/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.xml.table;

import com.harrand.coreclasses.xml.IXmlCtrl;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.table.constraint.UniqueConstraint;
import com.harrand.util.LogUtil;
import com.harrand.util.XmlHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UniqueConstraintXmlCtrl
implements IXmlCtrl {
    public static final String UC_TAG_NM = "UnCon";
    public static final String COL_NAMES = "ClNs";

    public Element asXmlElement(Document doc, UniqueConstraint uc) {
        Element elmUC = doc.createElement(UC_TAG_NM);
        elmUC.setAttribute("nm", uc.getName());
        String colNamesCsv = uc.getColumnsCsv();
        XmlHelper.addElementSimple(doc, elmUC, COL_NAMES, colNamesCsv);
        return elmUC;
    }

    public static UniqueConstraint fromXml(Element element, Table table) {
        String name = element.getAttribute("nm");
        String colNameCsv = XmlHelper.getFirstElementValue(element, COL_NAMES);
        ArrayList<String> colNames = new ArrayList<String>(Arrays.asList(colNameCsv.split(", ")));
        List<Column> cols = table.getColsFromNms(colNames);
        UniqueConstraint newUc = null;
        try {
            newUc = new UniqueConstraint(table, cols, name);
        }
        catch (Exception e) {
            LogUtil.logErr("UniqueConstraintXmlCtr.fromXml.error: " + e.getMessage());
        }
        return newUc;
    }
}

